/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;

public class FindClassResolutionsOperation
implements IRunnableWithProgress {
    String fClassName = null;
    IProject fProject = null;
    AbstractClassResolutionCollector fCollector = null;

    public FindClassResolutionsOperation(IProject project, String className, AbstractClassResolutionCollector collector) {
        this.fProject = project;
        this.fClassName = className;
        this.fCollector = collector;
    }

    public void run(IProgressMonitor monitor) {
        int idx = this.fClassName.lastIndexOf(46);
        String packageName = idx != -1 ? this.fClassName.substring(0, idx) : null;
        String typeName = this.fClassName.substring(idx + 1);
        if (typeName.length() == 1 && typeName.charAt(0) == '*') {
            typeName = null;
        }
        if (packageName != null && !this.isImportedPackage(packageName)) {
            Set validPackages = FindClassResolutionsOperation.getValidPackages(packageName);
            Iterator validPackagesIter = validPackages.iterator();
            Set visiblePkgs = null;
            while (validPackagesIter.hasNext() && !this.fCollector.isDone()) {
                ExportPackageDescription currentPackage;
                if (visiblePkgs == null) {
                    visiblePkgs = this.getVisiblePackages();
                }
                if (visiblePkgs.contains(currentPackage = (ExportPackageDescription)validPackagesIter.next())) continue;
                this.fCollector.addResolutionModification(this.fProject, currentPackage);
            }
        }
    }

    private boolean isImportedPackage(String packageName) {
        IPluginModelBase model = PluginRegistry.findModel((IProject)this.fProject.getProject());
        if (model != null && model.getBundleDescription() != null) {
            ImportPackageSpecification[] importPkgs = model.getBundleDescription().getImportPackages();
            int i = 0;
            while (i < importPkgs.length) {
                if (importPkgs[i].getName().equals(packageName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private static Set getValidPackages(String pkgName) {
        ExportPackageDescription[] knownPackages = PDECore.getDefault().getModelManager().getState().getState().getExportedPackages();
        HashSet<ExportPackageDescription> validPackages = new HashSet<ExportPackageDescription>();
        int i = 0;
        while (i < knownPackages.length) {
            if (knownPackages[i].getName().equals(pkgName)) {
                validPackages.add(knownPackages[i]);
            }
            ++i;
        }
        if (!validPackages.isEmpty()) {
            knownPackages = PDECore.getDefault().getModelManager().getState().getState().getSystemPackages();
            i = 0;
            while (i < knownPackages.length) {
                validPackages.remove(knownPackages[i]);
                ++i;
            }
        }
        return validPackages;
    }

    private Set getVisiblePackages() {
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.fProject);
        BundleDescription desc = base.getBundleDescription();
        StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
        ExportPackageDescription[] visiblePkgs = helper.getVisiblePackages(desc);
        HashSet<ExportPackageDescription> set = new HashSet<ExportPackageDescription>();
        int i = 0;
        while (i < visiblePkgs.length) {
            set.add(visiblePkgs[i]);
            ++i;
        }
        return set;
    }

    public static abstract class AbstractClassResolutionCollector {
        public abstract void addResolutionModification(IProject var1, ExportPackageDescription var2);

        public boolean isDone() {
            return false;
        }
    }
}

