/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteDescription;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CategoryDetailsSection
extends PDESection
implements IFormPart,
IPartSelectionListener {
    private static final String PROPERTY_DESC = "desc";
    private static final String PROPERTY_NAME = "url";
    private static final String PROPERTY_TYPE = "type";
    private ISiteCategoryDefinition fCurrentCategoryDefinition;
    private FormEntry fDescriptionText;
    private FormEntry fLabelText;
    private FormEntry fNameText;

    public CategoryDetailsSection(PDEFormPage page, Composite parent) {
        this(page, parent, PDEUIMessages.CategoryDetails_title, PDEUIMessages.CategoryDetails_sectionDescription, 0);
    }

    public CategoryDetailsSection(PDEFormPage page, Composite parent, String title, String desc, int toggleStyle) {
        super(page, parent, 0x80 | toggleStyle);
        this.getSection().setText(title);
        this.getSection().setDescription(desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    private boolean alreadyExists(String name) {
        ISiteCategoryDefinition[] defs = this.fCurrentCategoryDefinition.getModel().getSite().getCategoryDefinitions();
        int i = 0;
        while (i < defs.length) {
            String dname;
            ISiteCategoryDefinition def = defs[i];
            if (def != this.fCurrentCategoryDefinition && (dname = def.getName()) != null && dname.equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void applyValue(String property, String value) throws CoreException {
        if (this.fCurrentCategoryDefinition == null) {
            return;
        }
        if (property.equals(PROPERTY_NAME)) {
            String oldName = this.fCurrentCategoryDefinition.getName();
            this.fCurrentCategoryDefinition.setName(value);
            this.bringFeatures(oldName);
        } else if (property.equals(PROPERTY_TYPE)) {
            this.fCurrentCategoryDefinition.setLabel(value);
        } else if (property.equals(PROPERTY_DESC)) {
            if (value == null || value.length() == 0) {
                this.fCurrentCategoryDefinition.setDescription(null);
            } else {
                ISiteDescription siteDesc = this.fCurrentCategoryDefinition.getDescription();
                if (siteDesc == null) {
                    siteDesc = this.fCurrentCategoryDefinition.getModel().getFactory().createDescription((ISiteObject)this.fCurrentCategoryDefinition);
                    siteDesc.setText(value);
                    this.fCurrentCategoryDefinition.setDescription(siteDesc);
                } else {
                    siteDesc.setText(value);
                }
            }
        }
    }

    public void cancelEdit() {
        this.fNameText.cancelEdit();
        this.fLabelText.cancelEdit();
        this.fDescriptionText.cancelEdit();
        super.cancelEdit();
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private void clearField(String property) {
        if (property.equals(PROPERTY_NAME)) {
            this.fNameText.setValue(null, true);
        } else if (property.equals(PROPERTY_TYPE)) {
            this.fLabelText.setValue(null, true);
        } else if (property.equals(PROPERTY_DESC)) {
            this.fDescriptionText.setValue(null, true);
        }
    }

    private void clearFields() {
        this.fNameText.setValue(null, true);
        this.fLabelText.setValue(null, true);
        this.fDescriptionText.setValue(null, true);
    }

    public void commit(boolean onSave) {
        this.fNameText.commit();
        this.fLabelText.commit();
        this.fDescriptionText.commit();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        this.fNameText = new FormEntry(container, toolkit, PDEUIMessages.CategoryDetails_name, null, false);
        this.fNameText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    if (text.getValue().length() <= 0 || CategoryDetailsSection.this.alreadyExists(text.getValue())) {
                        CategoryDetailsSection.this.setValue(CategoryDetailsSection.PROPERTY_NAME);
                        String message = PDEUIMessages.CategoryDetails_alreadyExists;
                        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.CategoryDetails_alreadyExists_title, (String)message);
                    } else {
                        CategoryDetailsSection.this.applyValue(CategoryDetailsSection.PROPERTY_NAME, text.getValue());
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.limitTextWidth(this.fNameText);
        this.fNameText.setEditable(this.isEditable());
        this.fLabelText = new FormEntry(container, toolkit, PDEUIMessages.CategoryDetails_label, null, false);
        this.fLabelText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    CategoryDetailsSection.this.applyValue(CategoryDetailsSection.PROPERTY_TYPE, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.limitTextWidth(this.fLabelText);
        this.fLabelText.setEditable(this.isEditable());
        this.fDescriptionText = new FormEntry(container, toolkit, PDEUIMessages.CategoryDetails_desc, 66);
        this.fDescriptionText.getText().setLayoutData((Object)new GridData(1808));
        this.fDescriptionText.getLabel().setLayoutData((Object)new GridData(2));
        this.fDescriptionText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    CategoryDetailsSection.this.applyValue(CategoryDetailsSection.PROPERTY_DESC, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.limitTextWidth(this.fDescriptionText);
        this.fDescriptionText.setEditable(this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void limitTextWidth(FormEntry entry) {
        GridData gd = (GridData)entry.getText().getLayoutData();
        gd.widthHint = 30;
    }

    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    private void bringFeatures(String oldCategory) {
        ISiteFeature[] siteFeatures = this.fCurrentCategoryDefinition.getModel().getSite().getFeatures();
        int i = 0;
        while (i < siteFeatures.length) {
            ISiteCategory[] categories = siteFeatures[i].getCategories();
            int c = 0;
            while (c < categories.length) {
                if (oldCategory.equals(categories[c].getName())) {
                    try {
                        categories[c].setName(this.fCurrentCategoryDefinition.getName());
                    }
                    catch (CoreException coreException) {}
                }
                ++c;
            }
            ++i;
        }
    }

    public void refresh() {
        if (this.fCurrentCategoryDefinition == null) {
            this.clearFields();
            super.refresh();
            return;
        }
        this.setValue(PROPERTY_NAME);
        this.setValue(PROPERTY_TYPE);
        this.setValue(PROPERTY_DESC);
        super.refresh();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object o;
        this.fCurrentCategoryDefinition = selection instanceof IStructuredSelection && !selection.isEmpty() ? ((o = ((IStructuredSelection)selection).getFirstElement()) instanceof ISiteCategoryDefinition ? (ISiteCategoryDefinition)o : null) : null;
        this.refresh();
    }

    public void setFocus() {
        if (this.fNameText != null) {
            this.fNameText.getText().setFocus();
        }
    }

    private void setValue(String property) {
        if (this.fCurrentCategoryDefinition == null) {
            this.clearField(property);
        } else if (property.equals(PROPERTY_NAME)) {
            this.fNameText.setValue(this.fCurrentCategoryDefinition.getName(), true);
        } else if (property.equals(PROPERTY_TYPE)) {
            this.fLabelText.setValue(this.fCurrentCategoryDefinition.getLabel(), true);
        } else if (property.equals(PROPERTY_DESC)) {
            ISiteDescription siteDesc = this.fCurrentCategoryDefinition.getDescription();
            if (siteDesc == null) {
                this.clearField(property);
            } else {
                this.fDescriptionText.setValue(siteDesc.getText(), true);
            }
        }
    }
}

