/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WordPatternRule;

public class ExternalizedStringRule
extends WordPatternRule {
    public ExternalizedStringRule(IToken token) {
        super((IWordDetector)new ExternalizedStringDetector(), "%", null, token);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        char character = (char)scanner.read();
        if (Character.isWhitespace(character)) {
            return true;
        }
        if (character == '<') {
            return true;
        }
        scanner.unread();
        return super.endSequenceDetected(scanner);
    }

    private static class ExternalizedStringDetector
    implements IWordDetector {
        public boolean isWordStart(char character) {
            return character == '%';
        }

        public boolean isWordPart(char character) {
            if (Character.isLetterOrDigit(character)) {
                return true;
            }
            if (character == '.') {
                return true;
            }
            if (character == '-') {
                return true;
            }
            return character == '_';
        }
    }
}

