/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.EditableRevision;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.history.IFileRevision;

public class FileEditableRevision
extends EditableRevision {
    private final IFile file;
    private final IRunnableContext runnableContext;

    public FileEditableRevision(IFileRevision fileRevision, IFile file, IRunnableContext runnableContext) {
        super(fileRevision, CompareCoreUtils.getResourceEncoding((IResource)file));
        this.file = file;
        Assert.isNotNull((Object)runnableContext);
        this.runnableContext = runnableContext;
    }

    public void setContent(final byte[] newContent) {
        try {
            this.runnableContext.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor myMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        FileEditableRevision.this.file.setContents((InputStream)new ByteArrayInputStream(newContent), false, true, myMonitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e.getTargetException().getMessage(), e.getTargetException(), true);
        }
        catch (InterruptedException interruptedException) {}
    }
}

