/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithPreviousActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        if (resources.length == 1) {
            JobUtil.scheduleUserJob((IEGitOperation)new CompareWithPreviousOperation(event, repository, resources[0]), (String)UIText.CompareWithPreviousActionHandler_TaskGeneratingInput, null);
        }
        return null;
    }

    private static class CompareWithPreviousOperation
    implements IEGitOperation {
        private ExecutionEvent event;
        private Repository repository;
        private IResource resource;

        private CompareWithPreviousOperation(ExecutionEvent event, Repository repository, IResource resource) {
            this.event = event;
            this.repository = repository;
            this.resource = resource;
        }

        private String getRepositoryPath() {
            return RepositoryMapping.getMapping((IResource)this.resource.getProject()).getRepoRelativePath(this.resource);
        }

        public void execute(IProgressMonitor monitor) throws CoreException {
            RevCommit previous = this.findPreviousCommit();
            if (previous != null) {
                if (this.resource instanceof IFile) {
                    ITypedElement base = SaveableCompareEditorInput.createFileElement((IFile)((IFile)this.resource));
                    ITypedElement next = CompareUtils.getFileRevisionTypedElement(this.getRepositoryPath(), previous, this.repository);
                    GitCompareFileRevisionEditorInput input = new GitCompareFileRevisionEditorInput(base, next, null);
                    CompareUI.openCompareEditor((CompareEditorInput)input);
                } else {
                    this.openCompareTreeView(previous);
                }
            } else {
                this.showNotFoundDialog();
            }
        }

        private void openCompareTreeView(final RevCommit previous) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)this.event);
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                        view.setInput(new IResource[]{CompareWithPreviousOperation.this.resource}, previous.name());
                    }
                    catch (PartInitException e) {
                        Activator.handleError(e.getMessage(), e, true);
                    }
                }
            });
        }

        private RevCommit findPreviousCommit() {
            RevWalk rw = new RevWalk(this.repository);
            try {
                String path = this.getRepositoryPath();
                if (path.length() > 0) {
                    rw.setTreeFilter((TreeFilter)FollowFilter.create((String)path));
                }
                RevCommit headCommit = rw.parseCommit((AnyObjectId)this.repository.getRef("HEAD").getObjectId());
                rw.markStart(headCommit);
                headCommit = rw.next();
                if (headCommit != null) {
                    RevCommit revCommit = rw.next();
                    return revCommit;
                }
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            finally {
                rw.dispose();
            }
            return null;
        }

        private void showNotFoundDialog() {
            final Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)this.event);
            final String message = MessageFormat.format(UIText.CompareWithPreviousActionHandler_MessageRevisionNotFound, this.resource.getName());
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openWarning((Shell)shell, (String)UIText.CompareWithPreviousActionHandler_TitleRevisionNotFound, (String)message);
                }
            });
        }

        public ISchedulingRule getSchedulingRule() {
            return this.resource;
        }
    }
}

