/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.internal.components.CenteredImageLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class CheckboxLabelProvider
extends CenteredImageLabelProvider {
    private final CheckBoxImages checkBoxes;
    private final LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    private static CheckBoxImages createCheckboxImage(ResourceManager resourceManager, Control control) {
        String checkboxhack = System.getProperty("egit.swt.checkboxhack");
        if (checkboxhack == null) {
            checkboxhack = Platform.getOS().equals("macosx") ? "hardwired" : "screenshot";
        }
        if ("hardwired".equals(checkboxhack)) {
            return new CheckBoxImages(UIIcons.CHECKBOX_ENABLED_CHECKED.createImage(), UIIcons.CHECKBOX_ENABLED_UNCHECKED.createImage(), UIIcons.CHECKBOX_DISABLED_CHECKED.createImage(), UIIcons.CHECKBOX_DISABLED_UNCHECKED.createImage());
        }
        Shell shell = new Shell(control.getShell(), 8);
        Color gray = resourceManager.createColor(new RGB(222, 223, 224));
        Composite composite = new Composite((Composite)shell, 0);
        RowLayout layout = new RowLayout();
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        composite.setLayout((Layout)layout);
        CheckboxLabelProvider.createButton(composite, gray, true, true);
        CheckboxLabelProvider.createButton(composite, gray, false, true);
        CheckboxLabelProvider.createButton(composite, gray, true, false);
        CheckboxLabelProvider.createButton(composite, gray, false, false);
        Point cSize = composite.computeSize(-1, -1);
        composite.setSize(cSize);
        shell.setBackground(gray);
        shell.setLocation(0, 0);
        shell.setSize(cSize);
        shell.open();
        GC gc = new GC((Drawable)composite);
        int buttonX = cSize.x / 4;
        Image[] images = new Image[4];
        Display display = shell.getShell().getDisplay();
        int i = 0;
        while (i < 4) {
            Image image = new Image((Device)display, buttonX, buttonX);
            gc.copyArea(image, buttonX * i, 0);
            images[i] = CheckboxLabelProvider.getImage(resourceManager, gray, image);
            ++i;
        }
        gc.dispose();
        shell.close();
        return new CheckBoxImages(images[0], images[1], images[2], images[3]);
    }

    private static void createButton(Composite parent, Color bgColor, boolean checked, boolean enabled) {
        Button button = new Button(parent, 32);
        button.setSelection(checked);
        button.setEnabled(enabled);
        button.setBackground(bgColor);
        Point bSize = button.computeSize(-1, -1);
        button.setSize(bSize);
    }

    private static Image getImage(ResourceManager rm, Color bgColor, Image img) {
        ImageData imageData = img.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(bgColor.getRGB());
        Image image = rm.createImage(ImageDescriptor.createFromImageData((ImageData)imageData));
        img.dispose();
        return image;
    }

    public CheckboxLabelProvider(Control control) {
        this.checkBoxes = CheckboxLabelProvider.createCheckboxImage((ResourceManager)this.resourceManager, control);
    }

    protected Image getImage(Object element) {
        if (this.isEnabled(element)) {
            if (this.isChecked(element)) {
                return this.checkBoxes.checkedEnabled;
            }
            return this.checkBoxes.uncheckedEnabled;
        }
        if (this.isChecked(element)) {
            return this.checkBoxes.checkedDisabled;
        }
        return this.checkBoxes.uncheckedDisabled;
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }

    protected abstract boolean isChecked(Object var1);

    protected boolean isEnabled(Object element) {
        return true;
    }

    private static class CheckBoxImages {
        private final Image checkedEnabled;
        private final Image uncheckedEnabled;
        private final Image checkedDisabled;
        private final Image uncheckedDisabled;

        public CheckBoxImages(Image checkedEnabled, Image uncheckedEnabled, Image checkedDisabled, Image uncheckedDisabled) {
            this.checkedEnabled = checkedEnabled;
            this.uncheckedEnabled = uncheckedEnabled;
            this.checkedDisabled = checkedDisabled;
            this.uncheckedDisabled = uncheckedDisabled;
        }
    }
}

