/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentState;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public class CommitMessageComponentStateManager {
    private static final String COMMIT_MESSAGE_COMPONENT_SECTION = "GitCommitMessageComponent";
    private static final String EMPTY = "empty";
    private static final int MEMBER_COUNT = 5;

    public static void persistState(Repository repository, CommitMessageComponentState state) {
        IDialogSettings dialogSettings = CommitMessageComponentStateManager.getDialogSettings();
        String[] values = new String[]{Boolean.toString(state.getAmend()), state.getAuthor(), state.getCommitMessage(), state.getCommitter(), state.getHeadCommit().getName().toString()};
        dialogSettings.put(repository.getDirectory().getAbsolutePath(), values);
    }

    public static CommitMessageComponentState loadState(Repository repository) {
        IDialogSettings dialogSettings = CommitMessageComponentStateManager.getDialogSettings();
        String[] values = dialogSettings.getArray(repository.getDirectory().getAbsolutePath());
        if (values == null || values.length < 5) {
            return null;
        }
        CommitMessageComponentState state = new CommitMessageComponentState();
        state.setAmend(Boolean.parseBoolean(values[0]));
        state.setAuthor(values[1]);
        state.setCommitMessage(values[2]);
        state.setCommitter(values[3]);
        state.setHeadCommit(ObjectId.fromString((String)values[4]));
        return state;
    }

    private static IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(COMMIT_MESSAGE_COMPONENT_SECTION);
        if (section == null) {
            section = settings.addNewSection(COMMIT_MESSAGE_COMPONENT_SECTION);
        }
        return section;
    }

    public static void deleteState(Repository repository) {
        IDialogSettings dialogSettings = CommitMessageComponentStateManager.getDialogSettings();
        String key = repository.getDirectory().getAbsolutePath();
        if (dialogSettings != null && dialogSettings.getArray(key) != null) {
            dialogSettings.put(key, new String[]{EMPTY});
        }
    }
}

