/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ConfigurationChecker;
import org.eclipse.egit.ui.internal.repository.RepositoryPropertySourceProvider;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class RepositoriesView
extends CommonNavigator {
    public static final String REMOTE = "remote";
    public static final String URL = "url";
    public static final String PUSHURL = "pushurl";
    public static final String PUSH = "push";
    public static final String FETCH = "fetch";
    public static final String VIEW_ID = "org.eclipse.egit.ui.RepositoriesView";
    private static final long DEFAULT_REFRESH_DELAY = 1000L;
    private final Set<Repository> repositories = new HashSet<Repository>();
    private final RefsChangedListener myRefsChangedListener;
    private final IndexChangedListener myIndexChangedListener;
    private final ConfigChangedListener myConfigChangeListener;
    private final List<ListenerHandle> myListeners = new LinkedList<ListenerHandle>();
    private Job scheduledJob;
    private final RepositoryUtil repositoryUtil = Activator.getDefault().getRepositoryUtil();
    private final RepositoryCache repositoryCache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
    private Composite emptyArea;
    private StackLayout layout;
    private long lastInputChange = 0L;
    private long lastRepositoryChange = 0L;
    private long lastInputUpdate = -1L;
    private boolean reactOnSelection = false;
    private final IEclipsePreferences.IPreferenceChangeListener configurationListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            RepositoriesView.this.lastInputChange = System.currentTimeMillis();
            RepositoriesView.this.scheduleRefresh(1000L);
        }
    };
    private ISelectionListener selectionChangedListener;

    public RepositoriesView() {
        this.myRefsChangedListener = new RefsChangedListener(){

            public void onRefsChanged(RefsChangedEvent e) {
                RepositoriesView.this.lastRepositoryChange = System.currentTimeMillis();
                RepositoriesView.this.scheduleRefresh(1000L);
            }
        };
        this.myIndexChangedListener = new IndexChangedListener(){

            public void onIndexChanged(IndexChangedEvent event) {
                RepositoriesView.this.lastRepositoryChange = System.currentTimeMillis();
                RepositoriesView.this.scheduleRefresh(1000L);
            }
        };
        this.myConfigChangeListener = new ConfigChangedListener(){

            public void onConfigChanged(ConfigChangedEvent event) {
                RepositoriesView.this.lastRepositoryChange = System.currentTimeMillis();
                RepositoriesView.this.scheduleRefresh(1000L);
            }
        };
        this.selectionChangedListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!RepositoriesView.this.reactOnSelection) {
                    return;
                }
                if (part instanceof IEditorPart) {
                    IEditorInput input = ((IEditorPart)part).getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        RepositoriesView.this.reactOnSelection((ISelection)new StructuredSelection((Object)((IFileEditorInput)input).getFile()));
                    }
                } else {
                    RepositoriesView.this.reactOnSelection(selection);
                }
            }
        };
    }

    protected void createEmptyArea(Composite parent) {
        this.emptyArea = new Composite(parent, 0);
        this.emptyArea.setBackgroundMode(2);
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu((Control)this.emptyArea);
        this.emptyArea.setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.getCommonViewer());
        GridLayoutFactory.fillDefaults().applyTo(this.emptyArea);
        Composite infoArea = new Composite(this.emptyArea, 0);
        infoArea.setMenu(menu);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)infoArea);
        GridLayoutFactory.swtDefaults().applyTo(infoArea);
        Label messageLabel = new Label(infoArea, 64);
        messageLabel.setText(UIText.RepositoriesView_messsageEmpty);
        messageLabel.setMenu(menu);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)messageLabel);
        Composite optionsArea = new Composite(infoArea, 0);
        optionsArea.setMenu(menu);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(optionsArea);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)optionsArea);
        final FormToolkit toolkit = new FormToolkit(this.emptyArea.getDisplay());
        this.emptyArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        Color linkColor = JFaceColors.getHyperlinkText((Display)this.emptyArea.getDisplay());
        Label addLabel = new Label(optionsArea, 0);
        addLabel.setImage(UIIcons.CREATE_REPOSITORY.createImage());
        Hyperlink addLink = toolkit.createHyperlink(optionsArea, UIText.RepositoriesView_linkAdd, 64);
        addLink.setForeground(linkColor);
        addLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IHandlerService service = (IHandlerService)RepositoriesView.this.getViewSite().getService(IHandlerService.class);
                UIUtils.executeCommand(service, "org.eclipse.egit.ui.RepositoriesViewAddRepository");
            }
        });
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)addLink);
        Label cloneLabel = new Label(optionsArea, 0);
        cloneLabel.setImage(UIIcons.CLONEGIT.createImage());
        Hyperlink cloneLink = toolkit.createHyperlink(optionsArea, UIText.RepositoriesView_linkClone, 64);
        cloneLink.setForeground(linkColor);
        cloneLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IHandlerService service = (IHandlerService)RepositoriesView.this.getViewSite().getService(IHandlerService.class);
                UIUtils.executeCommand(service, "org.eclipse.egit.ui.RepositoriesViewClone");
            }
        });
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)cloneLink);
        Label createLabel = new Label(optionsArea, 0);
        createLabel.setImage(UIIcons.NEW_REPOSITORY.createImage());
        Hyperlink createLink = toolkit.createHyperlink(optionsArea, UIText.RepositoriesView_linkCreate, 64);
        createLink.setForeground(linkColor);
        createLink.setText(UIText.RepositoriesView_linkCreate);
        createLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IHandlerService service = (IHandlerService)RepositoriesView.this.getViewSite().getService(IHandlerService.class);
                UIUtils.executeCommand(service, "org.eclipse.egit.ui.RepositoriesViewCreateRepository");
            }
        });
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)createLink);
    }

    public void createPartControl(Composite aParent) {
        Composite displayArea = new Composite(aParent, 0);
        this.layout = new StackLayout();
        displayArea.setLayout((Layout)this.layout);
        this.createEmptyArea(displayArea);
        super.createPartControl(displayArea);
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ICommandService csrv = (ICommandService)w.getService(ICommandService.class);
        Command command = csrv.getCommand("org.eclipse.egit.ui.RepositoriesLinkWithSelection");
        this.reactOnSelection = (Boolean)command.getState("org.eclipse.ui.commands.toggleState").getValue();
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getSite().getService(IWorkbenchSiteProgressService.class);
        if (service != null) {
            service.showBusyForFamily(JobFamilies.REPO_VIEW_REFRESH);
            service.showBusyForFamily(JobFamilies.CLONE);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            PropertySheetPage page = new PropertySheetPage();
            page.setPropertySourceProvider((IPropertySourceProvider)new RepositoryPropertySourceProvider(page));
            return page;
        }
        return super.getAdapter(adapter);
    }

    public void setReactOnSelection(boolean reactOnSelection) {
        this.reactOnSelection = reactOnSelection;
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        ConfigurationChecker.checkConfiguration();
        CommonViewer viewer = super.createCommonViewer(aParent);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection sel = (TreeSelection)event.getSelection();
                RepositoryTreeNode element = (RepositoryTreeNode)sel.getFirstElement();
                if (element instanceof RefNode || element instanceof TagNode) {
                    RepositoriesView.this.executeOpenCommand();
                }
            }
        });
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TreeSelection sel = (TreeSelection)event.getSelection();
                RepositoryTreeNode element = (RepositoryTreeNode)sel.getFirstElement();
                if (element instanceof FileNode || element instanceof StashedCommitNode) {
                    RepositoriesView.this.executeOpenCommand();
                }
            }
        });
        ISelectionService srv = (ISelectionService)this.getSite().getService(ISelectionService.class);
        srv.addPostSelectionListener(this.selectionChangedListener);
        this.repositoryUtil.getPreferences().addPreferenceChangeListener(this.configurationListener);
        this.initRepositoriesAndListeners();
        this.activateContextService();
        this.emptyArea.setBackground(viewer.getControl().getBackground());
        this.layout.topControl = !this.repositories.isEmpty() ? viewer.getControl() : this.emptyArea;
        return viewer;
    }

    private void executeOpenCommand() {
        IHandlerService srv = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
        try {
            srv.executeCommand("org.eclipse.egit.ui.RepositoriesViewOpen", null);
        }
        catch (Exception e) {
            Activator.handleError(e.getMessage(), e, false);
        }
    }

    private void activateContextService() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext(VIEW_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepositoriesAndListeners() {
        Set<Repository> set = this.repositories;
        synchronized (set) {
            this.repositories.clear();
            this.unregisterRepositoryListener();
            for (String dir : this.repositoryUtil.getConfiguredRepositories()) {
                File repoDir = new File(dir);
                try {
                    Repository repo = this.repositoryCache.lookupRepository(repoDir);
                    this.myListeners.add(repo.getListenerList().addIndexChangedListener(this.myIndexChangedListener));
                    this.myListeners.add(repo.getListenerList().addRefsChangedListener(this.myRefsChangedListener));
                    this.myListeners.add(repo.getListenerList().addConfigChangedListener(this.myConfigChangeListener));
                    this.repositories.add(repo);
                }
                catch (IOException e) {
                    String message = NLS.bind((String)UIText.RepositoriesView_ExceptionLookingUpRepoMessage, (Object)repoDir.getPath());
                    Activator.handleError(message, e, false);
                    this.repositoryUtil.removeDir(repoDir);
                }
            }
        }
    }

    public void dispose() {
        if (this.scheduledJob != null) {
            this.scheduledJob.cancel();
            this.scheduledJob = null;
        }
        this.repositoryUtil.getPreferences().removePreferenceChangeListener(this.configurationListener);
        ISelectionService srv = (ISelectionService)this.getSite().getService(ISelectionService.class);
        srv.removePostSelectionListener(this.selectionChangedListener);
        this.unregisterRepositoryListener();
        this.repositories.clear();
        super.dispose();
    }

    private void showResource(IResource resource) {
        try {
            RepositoryTreeNode childNode;
            Object child;
            int n;
            int n2;
            Object[] objectArray;
            IProject project = resource.getProject();
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
            if (mapping == null) {
                return;
            }
            boolean added = this.repositoryUtil.addConfiguredRepository(mapping.getRepository().getDirectory());
            if (added) {
                this.scheduleRefresh(0L);
            }
            if (this.scheduledJob != null) {
                try {
                    this.scheduledJob.join();
                }
                catch (InterruptedException e) {
                    Activator.handleError(e.getMessage(), e, false);
                }
            }
            RepositoryTreeNode currentNode = null;
            ITreeContentProvider cp = (ITreeContentProvider)this.getCommonViewer().getContentProvider();
            Object[] objectArray2 = cp.getElements(this.getCommonViewer().getInput());
            int n3 = objectArray2.length;
            int n4 = 0;
            block4: while (n4 < n3) {
                Object repo = objectArray2[n4];
                RepositoryTreeNode node = (RepositoryTreeNode)repo;
                if (mapping.getRepository().getDirectory().equals(((Repository)node.getObject()).getDirectory())) {
                    objectArray = cp.getChildren((Object)node);
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        child = objectArray[n];
                        childNode = (RepositoryTreeNode)child;
                        if (childNode.getType() == RepositoryTreeNodeType.WORKINGDIR) {
                            currentNode = childNode;
                            break block4;
                        }
                        ++n;
                    }
                    break;
                }
                ++n4;
            }
            Path relPath = new Path(mapping.getRepoRelativePath(resource));
            String[] stringArray = relPath.segments();
            int n5 = stringArray.length;
            n3 = 0;
            while (n3 < n5) {
                String segment = stringArray[n3];
                objectArray = cp.getChildren(currentNode);
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    child = objectArray[n];
                    childNode = (RepositoryTreeNode)child;
                    if (((File)childNode.getObject()).getName().equals(segment)) {
                        currentNode = childNode;
                        break;
                    }
                    ++n;
                }
                ++n3;
            }
            final RepositoryTreeNode selNode = currentNode;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    RepositoriesView.this.selectReveal((ISelection)new StructuredSelection((Object)selNode));
                }
            });
        }
        catch (RuntimeException rte) {
            Activator.handleError(rte.getMessage(), rte, false);
        }
    }

    public void showRepository(Repository repositoryToShow) {
        ITreeContentProvider cp = (ITreeContentProvider)this.getCommonViewer().getContentProvider();
        Object[] objectArray = cp.getElements(this.getCommonViewer().getInput());
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object repo = objectArray[n2];
            RepositoryTreeNode node = (RepositoryTreeNode)repo;
            if (repositoryToShow.getDirectory().equals(node.getRepository().getDirectory())) {
                this.selectReveal((ISelection)new StructuredSelection((Object)node));
            }
            ++n2;
        }
    }

    public void refresh() {
        this.lastInputUpdate = -1L;
        this.scheduleRefresh(0L);
    }

    private Job scheduleRefresh(long delay) {
        boolean needsNewInput;
        boolean trace = GitTraceLocation.REPOSITORIESVIEW.isActive();
        if (trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORIESVIEW.getLocation(), "Entering scheduleRefresh()");
        }
        if (this.scheduledJob != null && (this.scheduledJob.getState() == 4 || this.scheduledJob.getState() == 2 || this.scheduledJob.getState() == 1)) {
            if (trace) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORIESVIEW.getLocation(), "Pending refresh job, returning");
            }
            return this.scheduledJob;
        }
        final CommonViewer tv = this.getCommonViewer();
        boolean bl = needsNewInput = this.lastInputChange > this.lastInputUpdate;
        if (trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORIESVIEW.getLocation(), "New input required: " + needsNewInput);
        }
        Job job = new Job("Refreshing Git Repositories view"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean actTrace = GitTraceLocation.REPOSITORIESVIEW.isActive();
                if (actTrace) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORIESVIEW.getLocation(), "Running the update");
                }
                RepositoriesView.this.lastInputUpdate = System.currentTimeMillis();
                if (needsNewInput) {
                    RepositoriesView.this.initRepositoriesAndListeners();
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PropertySheet sheet;
                        IPage page;
                        IViewPart part;
                        if (tv.getTree().isDisposed()) {
                            return;
                        }
                        long start = 0L;
                        boolean traceActive = GitTraceLocation.REPOSITORIESVIEW.isActive();
                        if (traceActive) {
                            start = System.currentTimeMillis();
                            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORIESVIEW.getLocation(), "Starting async update job");
                        }
                        Object[] expanded = tv.getExpandedElements();
                        IStructuredSelection sel = (IStructuredSelection)tv.getSelection();
                        if (needsNewInput) {
                            tv.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                        } else {
                            tv.refresh(true);
                        }
                        tv.setExpandedElements(expanded);
                        Object selected = sel.getFirstElement();
                        if (selected != null) {
                            tv.reveal(selected);
                        }
                        if ((part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.views.PropertySheet")) instanceof PropertySheet && (page = (sheet = (PropertySheet)part).getCurrentPage()) instanceof PropertySheetPage) {
                            ((PropertySheetPage)page).refresh();
                        }
                        if (traceActive) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORIESVIEW.getLocation(), "Ending async update job after " + (System.currentTimeMillis() - start) + " ms");
                        }
                        ((RepositoriesView)(this).RepositoriesView.this).layout.topControl = !RepositoriesView.this.repositories.isEmpty() ? RepositoriesView.this.getCommonViewer().getControl() : RepositoriesView.this.emptyArea;
                        RepositoriesView.this.emptyArea.getParent().layout(true, true);
                    }
                });
                if (RepositoriesView.this.lastInputChange > RepositoriesView.this.lastInputUpdate || RepositoriesView.this.lastRepositoryChange > RepositoriesView.this.lastInputUpdate) {
                    if (actTrace) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORIESVIEW.getLocation(), "Rescheduling refresh job");
                    }
                    this.schedule(1000L);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family.equals(JobFamilies.REPO_VIEW_REFRESH)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setSystem(true);
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getSite().getService(IWorkbenchSiteProgressService.class);
        if (trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORIESVIEW.getLocation(), "Scheduling refresh job");
        }
        service.schedule(job, delay);
        this.scheduledJob = job;
        return this.scheduledJob;
    }

    private void unregisterRepositoryListener() {
        for (ListenerHandle lh : this.myListeners) {
            lh.remove();
        }
        this.myListeners.clear();
    }

    public boolean show(ShowInContext context) {
        IResource resource;
        Object element;
        IStructuredSelection ss;
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable && (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null) {
            this.showResource(resource);
            return true;
        }
        if (context.getInput() instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)context.getInput();
            this.showResource((IResource)input.getFile());
        }
        return false;
    }

    private void reactOnSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            IResource adapted;
            StructuredSelection ssel = (StructuredSelection)selection;
            if (ssel.size() != 1) {
                return;
            }
            if (ssel.getFirstElement() instanceof IResource) {
                this.showResource((IResource)ssel.getFirstElement());
            }
            if (ssel.getFirstElement() instanceof IAdaptable && (adapted = (IResource)((IAdaptable)ssel.getFirstElement()).getAdapter(IResource.class)) != null) {
                this.showResource(adapted);
            }
        }
    }
}

