/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCacheFile;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCacheTree;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingTree;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitModelCache
extends GitModelObjectContainer {
    private final Path location;
    private final FileModelFactory fileFactory;
    private final Map<String, GitModelCacheTree> cacheTreeMap;
    private static final int BASE_NTH = 0;
    private static final int REMOTE_NTH = 1;
    protected final TreeFilter pathFilter;

    public GitModelCache(GitModelObject parent, RevCommit baseCommit, TreeFilter pathFilter) throws IOException {
        this(parent, baseCommit, pathFilter, new FileModelFactory(){

            public GitModelBlob createFileModel(GitModelObjectContainer modelParent, RevCommit commit, ObjectId repoId, ObjectId cacheId, IPath location) throws IOException {
                return new GitModelCacheFile(modelParent, commit, repoId, cacheId, location);
            }

            public boolean isWorkingTree() {
                return false;
            }
        });
    }

    GitModelCache(GitModelObject parent, RevCommit baseCommit) throws IOException {
        this(parent, baseCommit, null);
    }

    protected GitModelCache(GitModelObject parent, RevCommit baseCommit, TreeFilter pathFilter, FileModelFactory fileFactory) throws IOException {
        super(parent, baseCommit, 8);
        this.fileFactory = fileFactory;
        this.pathFilter = pathFilter;
        this.cacheTreeMap = new HashMap<String, GitModelCacheTree>();
        this.location = new Path(this.getRepository().getWorkTree().toString());
    }

    public String getName() {
        return UIText.GitModelIndex_index;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GitModelCache && !(obj instanceof GitModelWorkingTree)) {
            GitModelCache left = (GitModelCache)((Object)obj);
            return left.baseCommit.equals((AnyObjectId)this.baseCommit) && ((Object)((Object)left.getParent())).equals((Object)this.getParent());
        }
        return false;
    }

    public int hashCode() {
        return this.baseCommit.hashCode() ^ ((Object)((Object)this.getParent())).hashCode();
    }

    public String toString() {
        return "ModelCache";
    }

    protected GitModelObject[] getChildrenImpl() {
        ArrayList<GitModelObject> result = new ArrayList<GitModelObject>();
        try {
            TreeWalk tw = this.createAndConfigureTreeWalk();
            while (tw.next()) {
                GitModelObject entry = this.extractFromCache(tw);
                if (entry == null) continue;
                result.add(entry);
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        return result.toArray(new GitModelObject[result.size()]);
    }

    protected TreeWalk createAndConfigureTreeWalk() throws IOException {
        TreeWalk tw = this.createTreeWalk();
        tw.setRecursive(true);
        Repository repo = this.getRepository();
        DirCache index = repo.readDirCache();
        ObjectId headId = repo.getRef("HEAD").getObjectId();
        tw.addTree((AnyObjectId)new RevWalk(repo).parseTree((AnyObjectId)headId));
        tw.addTree((AbstractTreeIterator)new DirCacheIterator(index));
        if (this.pathFilter != null) {
            tw.setFilter(this.pathFilter);
        }
        return tw;
    }

    private GitModelObject extractFromCache(TreeWalk tw) throws IOException {
        if (this.shouldIncludeEntry(tw)) {
            String path = tw.getPathString();
            ObjectId repoId = tw.getObjectId(0);
            ObjectId cacheId = tw.getObjectId(1);
            if (path.contains("/")) {
                return this.handleCacheTree(repoId, cacheId, path);
            }
            return this.fileFactory.createFileModel(this, this.baseCommit, repoId, cacheId, this.getLocation().append(path));
        }
        return null;
    }

    private boolean shouldIncludeEntry(TreeWalk tw) {
        int mHead = tw.getRawMode(0);
        int mCache = tw.getRawMode(1);
        return mHead == FileMode.MISSING.getBits() || mCache == FileMode.MISSING.getBits() || mHead != mCache || mCache != FileMode.TREE.getBits() && !tw.idEqual(0, 1);
    }

    private GitModelObject handleCacheTree(ObjectId repoId, ObjectId cacheId, String path) throws IOException {
        int firstSlash = path.indexOf("/");
        String pathKey = path.substring(0, firstSlash);
        GitModelCacheTree cacheTree = this.cacheTreeMap.get(pathKey);
        if (cacheTree == null) {
            cacheTree = new GitModelCacheTree(this, this.baseCommit, repoId, cacheId, this.getLocation().append(pathKey), this.fileFactory);
            this.cacheTreeMap.put(pathKey, cacheTree);
        }
        cacheTree.addChild(repoId, cacheId, path.substring(firstSlash + 1));
        return cacheTree;
    }

    public IPath getLocation() {
        return this.location;
    }

    protected static interface FileModelFactory {
        public GitModelBlob createFileModel(GitModelObjectContainer var1, RevCommit var2, ObjectId var3, ObjectId var4, IPath var5) throws IOException;

        public boolean isWorkingTree();
    }
}

