/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;

public class GitModelCommit
extends GitModelObjectContainer
implements ISynchronizationCompareInput {
    protected final RevCommit ancestorCommit;
    private final TreeFilter pathFilter;

    public GitModelCommit(GitModelRepository parent, RevCommit commit, int direction, TreeFilter pathFilter) throws IOException {
        super(parent, commit, direction);
        this.pathFilter = pathFilter;
        this.ancestorCommit = this.calculateAncestor(commit);
    }

    protected GitModelCommit(GitModelObject parent, RevCommit commit, RevCommit ancestorCommit, int direction) throws IOException {
        super(parent, commit, direction);
        this.pathFilter = null;
        this.ancestorCommit = ancestorCommit;
    }

    GitModelCommit(GitModelRepository parent, RevCommit commit, int direction) throws IOException {
        this(parent, commit, direction, null);
    }

    public IPath getLocation() {
        return new Path(this.getRepository().getWorkTree().toString());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        GitModelCommit objCommit = (GitModelCommit)((Object)obj);
        return objCommit.getBaseCommit().equals((AnyObjectId)this.baseCommit) && ((Object)((Object)objCommit.getParent())).equals((Object)this.getParent());
    }

    public int hashCode() {
        return this.baseCommit.hashCode() ^ ((Object)((Object)this.getParent())).hashCode();
    }

    public String toString() {
        return "ModelCommit[" + this.baseCommit.getId() + "]";
    }

    protected GitModelObject[] getChildrenImpl() {
        TreeWalk tw = this.createTreeWalk();
        ArrayList<GitModelObject> result = new ArrayList<GitModelObject>();
        try {
            RevTree actualTree = this.baseCommit.getTree();
            int baseNth = tw.addTree((AnyObjectId)actualTree);
            int remoteNth = -1;
            if (this.remoteCommit != null) {
                remoteNth = tw.addTree((AnyObjectId)this.remoteCommit.getTree());
            }
            int ancestorNth = tw.addTree((AnyObjectId)this.ancestorCommit.getTree());
            while (tw.next()) {
                GitModelObject obj = this.getModelObject(tw, this.ancestorCommit, ancestorNth, remoteNth, baseNth);
                if (obj == null) continue;
                result.add(obj);
            }
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
        return result.toArray(new GitModelObject[result.size()]);
    }

    private RevCommit calculateAncestor(RevCommit actual) throws IOException {
        RevWalk rw = new RevWalk(this.getRepository());
        rw.setRevFilter(RevFilter.MERGE_BASE);
        if (this.pathFilter != null) {
            rw.setTreeFilter(this.pathFilter);
        }
        RevCommit[] revCommitArray = actual.getParents();
        int n = revCommitArray.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit parent = revCommitArray[n2];
            RevCommit parentCommit = rw.parseCommit((AnyObjectId)parent.getId());
            rw.markStart(parentCommit);
            ++n2;
        }
        rw.markStart(rw.parseCommit((AnyObjectId)actual.getId()));
        RevCommit result = rw.next();
        return result != null ? result : rw.parseCommit((AnyObjectId)ObjectId.zeroId());
    }
}

