/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.internal.launching.ext.UpdateVMArgs;
import org.eclipse.rcptt.internal.launching.ext.ui.wizards.NewAUTPage;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.ext.Q7LaunchingUtil;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.ui.IWorkbench;

public class NewAUTWizard
extends Wizard {
    private static final String ATTR_D32 = "-d32";
    private NewAUTPage page;

    public NewAUTWizard() {
        this.setWindowTitle("New Application Under Test");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page = new NewAUTPage("new", "New Application Under Test", null);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        ITargetPlatformHelper target = this.page.getTarget();
        if (target.isValid()) {
            try {
                String programArgs;
                IVMInstall install;
                target.setTargetName(Q7TargetPlatformManager.getTargetPlatformName((String)this.page.getTargetName()));
                target.save();
                ILaunchConfigurationWorkingCopy workingCopy = Q7LaunchingUtil.createLaunchConfiguration((ITargetPlatformHelper)target, (String)this.page.getTargetName());
                OSArchitecture autArch = this.page.getArchitecture();
                workingCopy.setAttribute("com.xored.launching.common.attrArch", autArch.name());
                OSArchitecture jvmArch = this.page.getJVMArch();
                String vmArgs = target.getIniVMArgs();
                vmArgs = vmArgs == null ? LaunchArgumentsHelper.getInitialVMArguments().trim() : vmArgs.trim();
                if (!autArch.equals((Object)jvmArch) && Platform.getOS().equals("macosx")) {
                    vmArgs = vmArgs != null && !vmArgs.contains(ATTR_D32) ? String.valueOf(vmArgs) + " -d32" : ATTR_D32;
                }
                if (vmArgs != null && vmArgs.length() > 0) {
                    vmArgs = UpdateVMArgs.updateAttr((String)vmArgs);
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
                }
                if ((install = this.page.getJVMInstall()) != null) {
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, String.format("org.eclipse.jdt.launching.JRE_CONTAINER/%s/%s", install.getVMInstallType().getId(), install.getName()));
                }
                if ((programArgs = (programArgs = LaunchArgumentsHelper.getInitialProgramArguments().trim()).contains("${target.arch}") ? programArgs.replace("${target.arch}", autArch.name()) : String.valueOf(programArgs) + " -arch " + autArch.name()).length() > 0) {
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArgs);
                }
                workingCopy.setAttribute("append.args", true);
                String product = target.getDefaultProduct();
                if (product != null) {
                    workingCopy.setAttribute("useProduct", true);
                    workingCopy.setAttribute("product", product);
                }
                workingCopy.setAttribute("clearws", false);
                workingCopy.setAttribute("askclear", true);
                workingCopy.setAttribute("clearwslog", false);
                workingCopy.setAttribute("location", NewAUTWizard.getDefaultWorkspaceLocation(workingCopy.getName()));
                workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
                workingCopy.setAttribute("org.eclipse.debug.core.capture_output", false);
                workingCopy.doSave();
                Q7TargetPlatformManager.setHelper((String)target.getName(), (ITargetPlatformHelper)target);
                return true;
            }
            catch (CoreException e) {
                Q7UIPlugin.log((Throwable)e);
            }
        }
        target.delete();
        return false;
    }

    public static String getDefaultWorkspaceLocation(String uniqueName) {
        return "${workspace_loc}/../aut-" + uniqueName.replaceAll("\\s", "");
    }
}

