/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.internal.core.search.ISearchResultCollector;
import org.eclipse.pde.internal.core.search.PluginSearchInput;
import org.eclipse.pde.internal.core.search.PluginSearchOperation;
import org.eclipse.pde.internal.ui.search.SearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class PluginSearchQuery
implements ISearchQuery {
    private SearchResult fSearchResult;
    private PluginSearchInput fSearchInput;

    public PluginSearchQuery(PluginSearchInput input) {
        this.fSearchInput = input;
    }

    public IStatus run(IProgressMonitor monitor) {
        final AbstractTextSearchResult result = (AbstractTextSearchResult)this.getSearchResult();
        result.removeAll();
        ISearchResultCollector collector = new ISearchResultCollector(){

            public void accept(Object match) {
                if (match instanceof ISourceObject) {
                    ISourceObject object = (ISourceObject)match;
                    result.addMatch(new Match(match, 1, object.getStartLine() - 1, 1));
                }
            }
        };
        PluginSearchOperation op = new PluginSearchOperation(this.fSearchInput, collector);
        op.execute(monitor);
        monitor.done();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return this.fSearchInput.getSearchString();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fSearchResult == null) {
            this.fSearchResult = new SearchResult(this);
        }
        return this.fSearchResult;
    }
}

