/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.sef;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class SelfEncapsulateFieldInputPage
extends UserInputWizardPage {
    private SelfEncapsulateFieldRefactoring fRefactoring;
    private IDialogSettings fSettings;
    private List<Control> fEnablements;
    private Text fGetterName;
    private Text fSetterName;
    private Label fGetterInfo;
    private Label fSetterInfo;
    private static final String GENERATE_JAVADOC = "GenerateJavadoc";

    public SelfEncapsulateFieldInputPage() {
        super("InputPage");
        this.setDescription(RefactoringMessages.SelfEncapsulateFieldInputPage_description);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_REFACTOR_CU);
    }

    public void createControl(Composite parent) {
        this.fRefactoring = (SelfEncapsulateFieldRefactoring)this.getRefactoring();
        this.fEnablements = new ArrayList<Control>();
        this.loadSettings();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        this.initializeDialogUnits((Control)result);
        result.setLayout((Layout)new GridLayout(3, false));
        Composite nameComposite = new Composite(result, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        nameComposite.setLayout((Layout)gridLayout);
        Label label = new Label(nameComposite, 16384);
        label.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_getter_name);
        this.fGetterName = new Text(nameComposite, 2048);
        this.fGetterName.setText(this.fRefactoring.getGetterName());
        TextFieldNavigationHandler.install(this.fGetterName);
        this.fGetterName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelfEncapsulateFieldInputPage.this.doGetterModified();
            }
        });
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(25);
        this.fGetterName.setLayoutData((Object)gd);
        this.fGetterInfo = new Label(nameComposite, 16384);
        this.fGetterInfo.setLayoutData((Object)new GridData(768));
        this.updateUseGetter();
        if (this.needsSetter()) {
            label = new Label(nameComposite, 16384);
            label.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_setter_name);
            this.fSetterName = new Text(nameComposite, 2048);
            this.fSetterName.setText(this.fRefactoring.getSetterName());
            this.fSetterName.setLayoutData((Object)new GridData(768));
            this.fSetterName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelfEncapsulateFieldInputPage.this.doSetterModified();
                }
            });
            TextFieldNavigationHandler.install(this.fSetterName);
            this.fSetterInfo = new Label(nameComposite, 16384);
            this.fSetterInfo.setLayoutData((Object)new GridData(768));
            this.updateUseSetter();
        }
        Link link = new Link(nameComposite, 0);
        link.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_configure_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelfEncapsulateFieldInputPage.this.doOpenPreference();
            }
        });
        link.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        Label separator = new Label(result, 0);
        separator.setText("");
        separator.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.createFieldAccessBlock(result);
        label = new Label(result, 16384);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        label.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_insert_after);
        this.fEnablements.add((Control)label);
        final Combo combo = new Combo(result, 8);
        SWTUtil.setDefaultVisibleItemCount(combo);
        this.fillWithPossibleInsertPositions(combo, this.fRefactoring.getField());
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelfEncapsulateFieldInputPage.this.fRefactoring.setInsertionIndex(combo.getSelectionIndex() - 1);
            }
        });
        combo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.fEnablements.add((Control)combo);
        this.createAccessModifier(result);
        Button checkBox = new Button(result, 32);
        checkBox.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_generateJavadocComment);
        checkBox.setSelection(this.fRefactoring.getGenerateJavadoc());
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelfEncapsulateFieldInputPage.this.setGenerateJavadoc(((Button)e.widget).getSelection());
            }
        });
        checkBox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.fEnablements.add((Control)checkBox);
        this.updateEnablements();
        this.processValidation();
        this.fGetterName.setFocus();
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.self_encapsulate_field_wizard_page_context");
    }

    private void updateUseSetter() {
        if (this.fRefactoring.isUsingLocalSetter()) {
            this.fSetterInfo.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_useexistingsetter_label);
        } else {
            this.fSetterInfo.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_usenewgetter_label);
        }
        this.updateEnablements();
    }

    private void updateEnablements() {
        boolean enable = !this.fRefactoring.isUsingLocalSetter() || !this.fRefactoring.isUsingLocalGetter();
        for (Control control : this.fEnablements) {
            control.setEnabled(enable);
        }
    }

    private void updateUseGetter() {
        if (this.fRefactoring.isUsingLocalGetter()) {
            this.fGetterInfo.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_useexistinggetter_label);
        } else {
            this.fGetterInfo.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_usenewsetter_label);
        }
        this.updateEnablements();
    }

    private void loadSettings() {
        this.fSettings = this.getDialogSettings().getSection("SelfEncapsulateFieldWizard");
        if (this.fSettings == null) {
            this.fSettings = this.getDialogSettings().addNewSection("SelfEncapsulateFieldWizard");
            this.fSettings.put(GENERATE_JAVADOC, JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)this.fRefactoring.getField().getJavaProject()).createComments);
        }
        this.fRefactoring.setGenerateJavadoc(this.fSettings.getBoolean(GENERATE_JAVADOC));
    }

    private void createAccessModifier(Composite result) {
        int visibility = this.fRefactoring.getVisibility();
        if (Flags.isPublic((int)visibility)) {
            return;
        }
        Label label = new Label(result, 0);
        label.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_access_Modifiers);
        this.fEnablements.add((Control)label);
        Composite group = new Composite(result, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Object[] info = this.createData(visibility);
        String[] labels = (String[])info[0];
        Integer[] data = (Integer[])info[1];
        int i = 0;
        while (i < labels.length) {
            Button radio = new Button(group, 16);
            radio.setText(labels[i]);
            radio.setData((Object)data[i]);
            int iData = data[i];
            if (iData == visibility) {
                radio.setSelection(true);
            }
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfEncapsulateFieldInputPage.this.fRefactoring.setVisibility((Integer)event.widget.getData());
                }
            });
            this.fEnablements.add((Control)radio);
            ++i;
        }
    }

    private void createFieldAccessBlock(Composite result) {
        Label label = new Label(result, 16384);
        label.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_field_access);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Composite group = new Composite(result, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Button radio = new Button(group, 16);
        radio.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_use_setter_getter);
        radio.setSelection(true);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelfEncapsulateFieldInputPage.this.fRefactoring.setEncapsulateDeclaringClass(true);
            }
        });
        radio.setLayoutData((Object)new GridData());
        radio = new Button(group, 16);
        radio.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_keep_references);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelfEncapsulateFieldInputPage.this.fRefactoring.setEncapsulateDeclaringClass(false);
            }
        });
        radio.setLayoutData((Object)new GridData());
    }

    private Object[] createData(int visibility) {
        String pub = RefactoringMessages.SelfEncapsulateFieldInputPage_public;
        String pro = RefactoringMessages.SelfEncapsulateFieldInputPage_protected;
        String def = RefactoringMessages.SelfEncapsulateFieldInputPage_default;
        String priv = RefactoringMessages.SelfEncapsulateFieldInputPage_private;
        String[] labels = null;
        Integer[] data = null;
        if (Flags.isPrivate((int)visibility)) {
            labels = new String[]{pub, pro, def, priv};
            data = new Integer[]{new Integer(1), new Integer(4), new Integer(0), new Integer(2)};
        } else if (Flags.isProtected((int)visibility)) {
            labels = new String[]{pub, pro};
            data = new Integer[]{new Integer(1), new Integer(4)};
        } else {
            labels = new String[]{pub, def};
            data = new Integer[]{new Integer(1), new Integer(0)};
        }
        return new Object[]{labels, data};
    }

    private void fillWithPossibleInsertPositions(Combo combo, IField field) {
        int select = 0;
        combo.add(RefactoringMessages.SelfEncapsulateFieldInputPage_first_method);
        try {
            IMethod[] methods = field.getDeclaringType().getMethods();
            int i = 0;
            while (i < methods.length) {
                combo.add(JavaElementLabels.getElementLabel((IJavaElement)methods[i], 1L));
                ++i;
            }
            if (methods.length > 0) {
                select = methods.length;
            }
        }
        catch (JavaModelException javaModelException) {}
        combo.select(select);
        this.fRefactoring.setInsertionIndex(select - 1);
    }

    private void setGenerateJavadoc(boolean value) {
        this.fSettings.put(GENERATE_JAVADOC, value);
        this.fRefactoring.setGenerateJavadoc(value);
    }

    private void processValidation() {
        RefactoringStatus status = this.fRefactoring.checkMethodNames();
        String message = null;
        boolean valid = true;
        if (status.hasFatalError()) {
            message = status.getMessageMatchingSeverity(4);
            valid = false;
        }
        this.setErrorMessage(message);
        this.setPageComplete(valid);
    }

    private boolean needsSetter() {
        try {
            return !JdtFlags.isFinal((IMember)this.fRefactoring.getField());
        }
        catch (JavaModelException javaModelException) {
            return true;
        }
    }

    private void doOpenPreference() {
        String id = "org.eclipse.jdt.ui.propertyPages.CodeStylePreferencePage";
        IJavaProject project = this.fRefactoring.getField().getJavaProject();
        Object[] relevantOptions = this.getRelevantOptions(project);
        int open = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, null).open();
        if (open == 0 && !Arrays.equals(relevantOptions, this.getRelevantOptions(project))) {
            this.fRefactoring.reinitialize();
            this.fGetterName.setText(this.fRefactoring.getGetterName());
            this.fSetterName.setText(this.fRefactoring.getSetterName());
        }
    }

    private String[] getRelevantOptions(IJavaProject project) {
        return new String[]{project.getOption("org.eclipse.jdt.core.codeComplete.fieldPrefixes", true), project.getOption("org.eclipse.jdt.core.codeComplete.fieldSuffixes", true), PreferenceConstants.getPreference("org.eclipse.jdt.ui.gettersetter.use.is", project)};
    }

    private void doSetterModified() {
        this.fRefactoring.setSetterName(this.fSetterName.getText());
        this.updateUseSetter();
        this.processValidation();
    }

    private void doGetterModified() {
        this.fRefactoring.setGetterName(this.fGetterName.getText());
        this.updateUseGetter();
        this.processValidation();
    }
}

