/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.connection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IConnectionMethod;
import org.eclipse.team.internal.ccvs.core.IUserAuthenticator;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.core.connection.CVSCommunicationException;
import org.eclipse.team.internal.ccvs.core.connection.Connection;
import org.eclipse.team.internal.ccvs.core.connection.PServerConnectionMethod;
import org.eclipse.team.internal.ccvs.core.connection.UserInfo;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteModule;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CVSRepositoryLocation
extends PlatformObject
implements ICVSRepositoryLocation,
IUserInfo {
    private static final String cvsNameSegment = "/CVS/";
    private static final String PASSWORD_KEY = "password";
    private static final String USERNAME_KEY = "login";
    public static final String PREF_REPOSITORIES_NODE = "repositories";
    private static final String DEFAULT_REPOSITORY_SETTINGS_NODE = "default_repository_settings";
    public static final String PREF_LOCATION = "location";
    public static final String PREF_SERVER_ENCODING = "encoding";
    public static final int UNDETERMINED_PLATFORM = 0;
    public static final int CVS_SERVER = 1;
    public static final int CVSNT_SERVER = 2;
    public static final int UNSUPPORTED_SERVER = 3;
    public static final int UNKNOWN_SERVER = 4;
    private static IUserAuthenticator authenticator;
    private static IConnectionMethod[] pluggedInConnectionMethods;
    private static Map hostLocks;
    private IConnectionMethod method;
    private String user;
    private String password;
    private String host;
    private int port;
    private String root;
    private boolean userFixed;
    private boolean passwordFixed;
    private boolean allowCaching;
    private int serverPlatform = 0;
    public static final char COLON = ':';
    public static final char SEMICOLON = ';';
    public static final char HOST_SEPARATOR = '@';
    public static final char PORT_SEPARATOR = '#';
    public static final boolean STANDALONE_MODE;
    private static final String INVOKE_SVR_CMD = "server";
    public static final String INFO_PASSWORD = "org.eclipse.team.cvs.core.password";
    public static final String INFO_USERNAME = "org.eclipse.team.cvs.core.username";
    public static final String AUTH_SCHEME = "";
    public static final String USER_VARIABLE = "{user}";
    public static final String PASSWORD_VARIABLE = "{password}";
    public static final String HOST_VARIABLE = "{host}";
    public static final String PORT_VARIABLE = "{port}";
    private static String extProxy;
    private boolean previousAuthenticationFailed = false;

    static {
        pluggedInConnectionMethods = null;
        hostLocks = new HashMap();
        STANDALONE_MODE = System.getProperty("eclipse.cvs.standalone") == null ? false : Boolean.valueOf(System.getProperty("eclipse.cvs.standalone"));
    }

    public static Preferences getParentPreferences() {
        return CVSProviderPlugin.getPlugin().getInstancePreferences().node(PREF_REPOSITORIES_NODE);
    }

    public static Preferences getDefaultPreferences() {
        Preferences defaults = new DefaultScope().getNode("org.eclipse.team.cvs.core").node(DEFAULT_REPOSITORY_SETTINGS_NODE);
        defaults.put(PREF_SERVER_ENCODING, CVSRepositoryLocation.getDefaultEncoding());
        return defaults;
    }

    private static String getDefaultEncoding() {
        return System.getProperty("file.encoding", "UTF-8");
    }

    public static void setExtConnectionMethodProxy(String string) {
        extProxy = string;
    }

    public static CVSRepositoryLocation fromProperties(Properties configuration) throws CVSException {
        String host;
        IConnectionMethod method;
        String connection = configuration.getProperty("connection");
        if (connection == null) {
            connection = "pserver";
        }
        if ((method = CVSRepositoryLocation.getPluggedInConnectionMethod(connection)) == null) {
            throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -6, NLS.bind((String)CVSMessages.CVSRepositoryLocation_methods, (Object[])new Object[]{CVSRepositoryLocation.getPluggedInConnectionMethodNames()}), null));
        }
        String user = configuration.getProperty("user");
        if (user.length() == 0) {
            user = null;
        }
        String password = configuration.getProperty(PASSWORD_KEY);
        if (user == null) {
            password = null;
        }
        if ((host = configuration.getProperty("host")) == null) {
            throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -6, CVSMessages.CVSRepositoryLocation_hostRequired, null));
        }
        String portString = configuration.getProperty("port");
        int port = portString == null ? 0 : Integer.parseInt(portString);
        String root = configuration.getProperty("root");
        if (root == null) {
            throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -6, CVSMessages.CVSRepositoryLocation_rootRequired, null));
        }
        String encoding = configuration.getProperty(PREF_SERVER_ENCODING);
        return new CVSRepositoryLocation(method, user, password, host, port, root, encoding, user != null, false);
    }

    public static CVSRepositoryLocation fromString(String location) throws CVSException {
        try {
            return CVSRepositoryLocation.fromString(location, false);
        }
        catch (CVSException e) {
            MultiStatus error = new MultiStatus("org.eclipse.team.cvs.core", 4, NLS.bind((String)CVSMessages.CVSRepositoryLocation_invalidFormat, (Object[])new Object[]{location}), null);
            error.merge((IStatus)new CVSStatus(4, CVSMessages.CVSRepositoryLocation_locationForm));
            error.merge(e.getStatus());
            throw new CVSException((IStatus)error);
        }
    }

    public static CVSRepositoryLocation fromString(String location, boolean validateOnly) throws CVSException {
        String errorMessage = null;
        try {
            String methodName;
            int end;
            errorMessage = CVSMessages.CVSRepositoryLocation_parsingMethod;
            int start = location.indexOf(58);
            int optionStart = location.indexOf(59);
            HashMap<String, String> hmOptions = new HashMap<String, String>();
            if (start == 0) {
                end = location.indexOf(58, start + 1);
                if (optionStart != -1) {
                    methodName = location.substring(start + 1, optionStart);
                    StringTokenizer stOpt = new StringTokenizer(location.substring(optionStart + 1, end), "=;");
                    while (stOpt.hasMoreTokens()) {
                        hmOptions.put(stOpt.nextToken(), stOpt.nextToken());
                    }
                    start = end + 1;
                } else {
                    methodName = location.substring(start + 1, end);
                    start = end + 1;
                }
            } else {
                methodName = "ext";
                start = 0;
            }
            IConnectionMethod method = CVSRepositoryLocation.getPluggedInConnectionMethod(methodName);
            if (method == null) {
                throw new CVSException((IStatus)new CVSStatus(4, NLS.bind((String)CVSMessages.CVSRepositoryLocation_methods, (Object[])new Object[]{CVSRepositoryLocation.getPluggedInConnectionMethodNames()})));
            }
            errorMessage = CVSMessages.CVSRepositoryLocation_parsingUser;
            end = location.indexOf(64, start);
            String user = null;
            String password = null;
            if (end != -1) {
                user = location.substring(start, end);
                if ((start = user.indexOf(58)) != -1) {
                    errorMessage = CVSMessages.CVSRepositoryLocation_parsingPassword;
                    password = user.substring(start + 1);
                    user = user.substring(0, start);
                }
                start = end + 1;
            } else if (optionStart != -1) {
                if (hmOptions.containsKey("username")) {
                    user = hmOptions.get("username").toString();
                }
                if (hmOptions.containsKey(PASSWORD_KEY)) {
                    password = hmOptions.get(PASSWORD_KEY).toString();
                }
            }
            errorMessage = CVSMessages.CVSRepositoryLocation_parsingHost;
            int hostEnd = end = location.indexOf(58, start);
            if (end == -1) {
                hostEnd = end = location.indexOf(47, start);
                if (end != -1) {
                    --end;
                }
            }
            String host = hmOptions.containsKey("hostname") ? hmOptions.get("hostname").toString() : location.substring(start, hostEnd);
            int port = 0;
            boolean havePort = false;
            if (hmOptions.containsKey("port")) {
                port = Integer.parseInt(hmOptions.get("port").toString());
                havePort = true;
            }
            if ((start = host.indexOf(35)) != -1) {
                try {
                    errorMessage = CVSMessages.CVSRepositoryLocation_parsingPort;
                    port = Integer.parseInt(host.substring(start + 1));
                    host = host.substring(0, start);
                    havePort = true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (!havePort) {
                errorMessage = CVSMessages.CVSRepositoryLocation_parsingPort;
                int index = end;
                char c = location.charAt(++index);
                String portString = new String();
                while (Character.isDigit(c)) {
                    portString = String.valueOf(portString) + c;
                    c = location.charAt(++index);
                }
                if (portString.length() > 0) {
                    end = index - 1;
                    port = Integer.parseInt(portString);
                }
            }
            errorMessage = CVSMessages.CVSRepositoryLocation_parsingRoot;
            start = end + 1;
            String root = location.substring(start);
            if (validateOnly) {
                throw new CVSException((IStatus)new CVSStatus(0, CVSMessages.ok));
            }
            return new CVSRepositoryLocation(method, user, password, host, port, root, null, user != null, password != null);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CVSStatus status = new CVSStatus(4, errorMessage);
            throw new CVSException((IStatus)status);
        }
        catch (NumberFormatException numberFormatException) {
            CVSStatus status = new CVSStatus(4, errorMessage);
            throw new CVSException((IStatus)status);
        }
    }

    public static IUserAuthenticator getAuthenticator() {
        if (authenticator == null) {
            authenticator = CVSRepositoryLocation.getPluggedInAuthenticator();
        }
        return authenticator;
    }

    public static IConnectionMethod[] getPluggedInConnectionMethods() {
        if (pluggedInConnectionMethods == null) {
            ArrayList<Object> connectionMethods = new ArrayList<Object>();
            if (STANDALONE_MODE) {
                connectionMethods.add(new PServerConnectionMethod());
            } else {
                IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.cvs.core", "connectionmethods").getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] configs = extension.getConfigurationElements();
                    if (configs.length == 0) {
                        CVSProviderPlugin.log(4, NLS.bind((String)"Connection method {0} is missing required fields", (Object[])new Object[]{extension.getUniqueIdentifier()}), null);
                    } else {
                        try {
                            IConfigurationElement config = configs[0];
                            connectionMethods.add(config.createExecutableExtension("run"));
                        }
                        catch (CoreException ex) {
                            CVSProviderPlugin.log(4, NLS.bind((String)"Could not instantiate connection method for  {0}", (Object[])new Object[]{extension.getUniqueIdentifier()}), ex);
                        }
                    }
                    ++i;
                }
            }
            IConnectionMethod[] methods = connectionMethods.toArray(new IConnectionMethod[0]);
            Arrays.sort(methods, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof IConnectionMethod && o2 instanceof IConnectionMethod) {
                        IConnectionMethod cm1 = (IConnectionMethod)o1;
                        IConnectionMethod cm2 = (IConnectionMethod)o2;
                        return cm1.getName().compareTo(cm2.getName());
                    }
                    return 0;
                }
            });
            pluggedInConnectionMethods = methods;
        }
        return pluggedInConnectionMethods;
    }

    private static IConnectionMethod getPluggedInConnectionMethod(String methodName) {
        Assert.isNotNull((Object)methodName);
        IConnectionMethod[] methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i].getName())) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    private static String getPluggedInConnectionMethodNames() {
        IConnectionMethod[] methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        StringBuffer methodNames = new StringBuffer();
        int i = 0;
        while (i < methods.length) {
            String name = methods[i].getName();
            if (i > 0) {
                methodNames.append(", ");
            }
            methodNames.append(name);
            ++i;
        }
        return methodNames.toString();
    }

    private static IUserAuthenticator getPluggedInAuthenticator() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.cvs.core", "authenticator").getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            CVSProviderPlugin.log(4, NLS.bind((String)"User autheticator {0} is missing required fields", (Object[])new Object[]{extension.getUniqueIdentifier()}), null);
            return null;
        }
        try {
            IConfigurationElement config = configs[0];
            return (IUserAuthenticator)config.createExecutableExtension("run");
        }
        catch (CoreException ex) {
            CVSProviderPlugin.log(4, NLS.bind((String)"Unable to instantiate user authenticator {0}", (Object[])new Object[]{extension.getUniqueIdentifier()}), ex);
            return null;
        }
    }

    private CVSRepositoryLocation(IConnectionMethod method, String user, String password, String host, int port, String root, String encoding, boolean userFixed, boolean passwordFixed) {
        this.method = method;
        this.user = user;
        this.password = password;
        this.host = host;
        this.port = port;
        this.root = root;
        if (userFixed && user != null) {
            this.userFixed = true;
        }
        if (userFixed && passwordFixed && password != null) {
            this.passwordFixed = true;
        }
        if (encoding != null) {
            this.setEncoding(encoding);
        }
    }

    private Connection createConnection(String password, IProgressMonitor monitor) throws CVSException {
        IConnectionMethod methodToUse = this.method;
        if (this.method.getName().equals("ext") && extProxy != null && !extProxy.equals(this.method.getName())) {
            methodToUse = CVSRepositoryLocation.getPluggedInConnectionMethod(extProxy);
        }
        Connection connection = new Connection(this, methodToUse.createConnection(this, password));
        connection.open(monitor);
        return connection;
    }

    public void dispose() {
        this.removeNode();
        try {
            if (this.hasPreferences()) {
                this.internalGetPreferences().removeNode();
                CVSRepositoryLocation.getParentPreferences().flush();
            }
        }
        catch (BackingStoreException e) {
            CVSProviderPlugin.log(4, NLS.bind((String)CVSMessages.CVSRepositoryLocation_73, (Object[])new String[]{this.getLocation(true)}), e);
        }
    }

    private void removeNode() {
        ISecurePreferences node = this.getCVSNode();
        if (node == null) {
            return;
        }
        try {
            node.clear();
            node.flush();
        }
        catch (IllegalStateException e) {
            CVSProviderPlugin.log(4, e.getMessage(), e);
        }
        catch (IOException e) {
            CVSProviderPlugin.log(4, e.getMessage(), e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getLocation() {
        return this.getLocation(false);
    }

    public String getLocation(boolean forDisplay) {
        return String.valueOf(':') + this.method.getName() + ':' + (this.userFixed ? String.valueOf(this.user) + (this.passwordFixed && !forDisplay ? String.valueOf(':') + this.password : AUTH_SCHEME) + '@' : AUTH_SCHEME) + this.host + ':' + (this.port == 0 ? AUTH_SCHEME : new Integer(this.port).toString()) + this.root;
    }

    public IConnectionMethod getMethod() {
        return this.method;
    }

    public int getPort() {
        return this.port;
    }

    public String getEncoding() {
        if (this.hasPreferences()) {
            return this.internalGetPreferences().get(PREF_SERVER_ENCODING, CVSRepositoryLocation.getDefaultEncoding());
        }
        return CVSRepositoryLocation.getDefaultEncoding();
    }

    public void setEncoding(String encoding) {
        if (encoding == null || encoding == CVSRepositoryLocation.getDefaultEncoding()) {
            if (this.hasPreferences()) {
                this.internalGetPreferences().remove(PREF_SERVER_ENCODING);
            }
        } else {
            this.ensurePreferencesStored();
            this.internalGetPreferences().put(PREF_SERVER_ENCODING, encoding);
            this.flushPreferences();
        }
    }

    public ICVSRemoteResource[] members(CVSTag tag, boolean modules, IProgressMonitor progress) throws CVSException {
        try {
            if (modules) {
                return RemoteModule.getRemoteModules(this, tag, progress);
            }
            RemoteFolder root = new RemoteFolder(null, this, AUTH_SCHEME, tag);
            ICVSRemoteResource[] resources = root.members(progress);
            ArrayList<ICVSRemoteResource> folders = new ArrayList<ICVSRemoteResource>(resources.length);
            int i = 0;
            while (i < resources.length) {
                ICVSRemoteResource remoteResource = resources[i];
                if (remoteResource.isContainer()) {
                    folders.add(remoteResource);
                }
                ++i;
            }
            return folders.toArray(new ICVSRemoteResource[folders.size()]);
        }
        catch (CVSException e) {
            throw e;
        }
        catch (TeamException e1) {
            throw new CVSException(e1.getStatus());
        }
    }

    public ICVSRemoteFolder getRemoteFolder(String remotePath, CVSTag tag) {
        return new RemoteFolder(null, this, remotePath, tag);
    }

    public ICVSRemoteFile getRemoteFile(String remotePath, CVSTag tag) {
        Path path = new Path(null, remotePath);
        RemoteFolderTree remoteFolder = new RemoteFolderTree(null, this, path.removeLastSegments(1).toString(), tag);
        RemoteFile remoteFile = new RemoteFile(remoteFolder, 1, path.lastSegment(), null, null, tag);
        remoteFolder.setChildren(new ICVSRemoteResource[]{remoteFile});
        return remoteFile;
    }

    public String getRootDirectory() {
        return this.root;
    }

    public int getTimeout() {
        return CVSProviderPlugin.getPlugin().getTimeout();
    }

    public IUserInfo getUserInfo(boolean makeUsernameMutable) {
        return new UserInfo(this.getUsername(), this.password, makeUsernameMutable ? true : this.isUsernameMutable());
    }

    public String getUsername() {
        if (this.user == null && this.isUsernameMutable()) {
            this.retrieveUsername();
        }
        return this.user == null ? AUTH_SCHEME : this.user;
    }

    public boolean isUsernameMutable() {
        return !this.userFixed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection openConnection(IProgressMonitor monitor) throws CVSException {
        ILock hostLock;
        Policy.checkCanceled(monitor);
        Map map = hostLocks;
        synchronized (map) {
            hostLock = (ILock)hostLocks.get(this.getHost());
            if (hostLock == null) {
                hostLock = Job.getJobManager().newLock();
                hostLocks.put(this.getHost(), hostLock);
            }
        }
        try {
            boolean acquired = false;
            int count = 0;
            int timeout = CVSProviderPlugin.getPlugin().getTimeout();
            while (!acquired) {
                try {
                    acquired = hostLock.acquire(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (timeout > 0 && count > timeout) {
                    throw new CVSCommunicationException(NLS.bind((String)CVSMessages.CVSRepositoryLocation_72, (Object)this.getHost()));
                }
                ++count;
                Policy.checkCanceled(monitor);
            }
            monitor.beginTask(NLS.bind((String)CVSMessages.CVSRepositoryLocation_openingConnection, (Object[])new String[]{this.getHost()}), 2);
            this.ensureLocationCached();
            boolean cacheNeedsUpdate = false;
            if (this.previousAuthenticationFailed) {
                this.promptForUserInfo(null);
                cacheNeedsUpdate = true;
            }
            while (true) {
                try {
                    String password = this.password;
                    if (password == null) {
                        password = this.retrievePassword();
                    }
                    if (this.user == null) {
                        throw new CVSAuthenticationException(CVSMessages.CVSRepositoryLocation_usernameRequired, 1, this, null);
                    }
                    Connection connection = this.createConnection(password, monitor);
                    if (cacheNeedsUpdate) {
                        this.updateCachedLocation();
                    }
                    this.previousAuthenticationFailed = false;
                    Connection connection2 = connection;
                    return connection2;
                }
                catch (CVSAuthenticationException ex) {
                    this.previousAuthenticationFailed = true;
                    if (ex.getRetryStatus() == 1) {
                        String message = ex.getMessage();
                        this.promptForUserInfo(message);
                        cacheNeedsUpdate = true;
                        continue;
                    }
                    throw ex;
                }
                break;
            }
        }
        finally {
            hostLock.release();
            monitor.done();
        }
    }

    private void promptForUserInfo(String message) throws CVSException {
        IUserAuthenticator authenticator = CVSRepositoryLocation.getAuthenticator();
        if (authenticator == null) {
            throw new CVSAuthenticationException(CVSMessages.CVSRepositoryLocation_noAuthenticator, 2, this);
        }
        authenticator.promptForUserInfo(this, this, message);
    }

    private void ensureLocationCached() {
        String location = this.getLocation();
        KnownRepositories repositories = KnownRepositories.getInstance();
        if (repositories.isKnownRepository(location)) {
            try {
                this.setAuthenticationInformation((CVSRepositoryLocation)repositories.getRepository(location));
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
        } else {
            repositories.addRepository(this, true);
        }
    }

    private void setAuthenticationInformation(CVSRepositoryLocation other) {
        if (other != this) {
            if (other.getUserInfoCached()) {
                this.allowCaching = true;
                if (!this.userFixed) {
                    this.user = null;
                }
                if (!this.passwordFixed) {
                    this.password = null;
                }
            } else {
                this.setAllowCaching(false);
                if (!other.userFixed) {
                    this.user = other.user;
                }
                if (!other.passwordFixed) {
                    this.password = other.password;
                }
            }
        }
    }

    private void updateCachedLocation() {
        try {
            CVSRepositoryLocation known = (CVSRepositoryLocation)KnownRepositories.getInstance().getRepository(this.getLocation());
            known.setAuthenticationInformation(this);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
    }

    public String toString() {
        return this.getLocation(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CVSRepositoryLocation)) {
            return false;
        }
        return this.getLocation().equals(((CVSRepositoryLocation)o).getLocation());
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    private String retrieveUsername() {
        ISecurePreferences node = this.getCVSNode();
        if (node == null) {
            return null;
        }
        try {
            String username = node.get(USERNAME_KEY, null);
            if (username != null && this.isUsernameMutable()) {
                this.setUsername(username);
            }
            return username;
        }
        catch (StorageException e) {
            CVSProviderPlugin.log(4, e.getMessage(), e);
            return null;
        }
    }

    private String retrievePassword() {
        ISecurePreferences node = this.getCVSNode();
        if (node == null) {
            return null;
        }
        try {
            this.retrieveUsername();
            return node.get(PASSWORD_KEY, null);
        }
        catch (StorageException e) {
            CVSProviderPlugin.log(4, e.getMessage(), e);
            return null;
        }
    }

    public void setPassword(String password) {
        if (this.passwordFixed) {
            throw new UnsupportedOperationException();
        }
        this.password = password;
        this.previousAuthenticationFailed = false;
    }

    public void setUsername(String user) {
        if (this.userFixed) {
            throw new UnsupportedOperationException();
        }
        this.user = user;
    }

    public void setUserMuteable(boolean muteable) {
        this.userFixed = !muteable;
    }

    public void setAllowCaching(boolean value) {
        this.allowCaching = value;
        if (this.allowCaching) {
            this.updateCache();
        } else {
            if (this.password == null) {
                this.password = this.retrievePassword();
            }
            this.removeNode();
        }
    }

    public void updateCache() {
        if (this.passwordFixed || !this.allowCaching) {
            return;
        }
        if (this.password == null && this.userFixed) {
            return;
        }
        if (this.updateCache(this.user, this.password)) {
            this.password = null;
        }
        this.ensurePreferencesStored();
    }

    private boolean updateCache(String username, String password) {
        ISecurePreferences node = this.getCVSNode();
        if (node == null) {
            return false;
        }
        try {
            node.put(USERNAME_KEY, username, false);
            node.put(PASSWORD_KEY, password, true);
            node.flush();
        }
        catch (StorageException e) {
            CVSProviderPlugin.log(4, e.getMessage(), e);
            return false;
        }
        catch (IOException e) {
            CVSProviderPlugin.log(4, e.getMessage(), e);
            return false;
        }
        return true;
    }

    public void validateConnection(IProgressMonitor monitor) throws CVSException {
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100);
            ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
            Session session = new Session(this, root, false);
            session.open(Policy.subMonitorFor(monitor, 50), false);
            try {
                IStatus status = Command.VERSION.execute(session, this, Policy.subMonitorFor(monitor, 50));
                if (!status.isOK()) {
                    CVSProviderPlugin.log(status);
                }
            }
            finally {
                session.close();
                monitor.done();
            }
        }
        catch (CVSException e) {
            this.dispose();
            throw e;
        }
    }

    public int getServerPlatform() {
        return this.serverPlatform;
    }

    public void setServerPlaform(int serverType) {
        switch (serverType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.serverPlatform = serverType;
                break;
            }
            default: {
                this.serverPlatform = 0;
            }
        }
    }

    public void flushUserInfo() {
        this.removeNode();
    }

    String[] getExtCommand(String password) throws IOException {
        String CVS_RSH = CVSProviderPlugin.getPlugin().getCvsRshCommand();
        String CVS_RSH_PARAMETERS = CVSProviderPlugin.getPlugin().getCvsRshParameters();
        String CVS_SERVER = CVSProviderPlugin.getPlugin().getCvsServer();
        if (CVS_RSH == null || CVS_SERVER == null) {
            throw new IOException(CVSMessages.EXTServerConnection_varsNotSet);
        }
        if (CVS_RSH_PARAMETERS == null || CVS_RSH_PARAMETERS.length() == 0) {
            if (this.port != 0) {
                throw new IOException(CVSMessages.EXTServerConnection_invalidPort);
            }
            return new String[]{CVS_RSH, this.host, "-l", this.user, CVS_SERVER, INVOKE_SVR_CMD};
        }
        CVS_RSH_PARAMETERS = this.stringReplace(CVS_RSH_PARAMETERS, USER_VARIABLE, this.user);
        CVS_RSH_PARAMETERS = this.stringReplace(CVS_RSH_PARAMETERS, PASSWORD_VARIABLE, password);
        CVS_RSH_PARAMETERS = this.stringReplace(CVS_RSH_PARAMETERS, HOST_VARIABLE, this.host);
        CVS_RSH_PARAMETERS = this.stringReplace(CVS_RSH_PARAMETERS, PORT_VARIABLE, new Integer(this.port).toString());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(CVS_RSH);
        StringTokenizer tokenizer = new StringTokenizer(CVS_RSH_PARAMETERS);
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            commands.add(next);
        }
        commands.add(CVS_SERVER);
        commands.add(INVOKE_SVR_CMD);
        return commands.toArray(new String[commands.size()]);
    }

    private String stringReplace(String string, String oldString, String newString) {
        int index = string.toLowerCase().indexOf(oldString);
        if (index == -1) {
            return string;
        }
        return this.stringReplace(String.valueOf(string.substring(0, index)) + newString + string.substring(index + oldString.length()), oldString, newString);
    }

    public String getServerMessageWithoutPrefix(String errorLine, String prefix) {
        String message = errorLine;
        int firstSpace = message.indexOf(32);
        if (firstSpace != -1) {
            message = message.substring(firstSpace + 1);
            if (prefix.startsWith("[")) {
                int closingBracket = message.indexOf("]: ");
                if (closingBracket == -1) {
                    return null;
                }
                String realPrefix = message.substring(1, closingBracket);
                int space = realPrefix.indexOf(32);
                if (space == -1) {
                    return null;
                }
                if (realPrefix.indexOf(32, space + 1) != -1) {
                    return null;
                }
                if (!realPrefix.substring(space + 1).equals("aborted")) {
                    return null;
                }
                if ((message = message.substring(closingBracket + 2)).charAt(0) == ' ') {
                    message = message.substring(1);
                }
                return message;
            }
            int colon = message.indexOf(": ");
            if (colon == -1) {
                return null;
            }
            String realPrefix = message.substring(0, colon);
            if (realPrefix.indexOf(32) != -1) {
                return null;
            }
            if ((message = message.substring(colon + 1)).charAt(0) == ' ') {
                message = message.substring(1);
            }
            return message;
        }
        return null;
    }

    public IUserAuthenticator getUserAuthenticator() {
        return CVSRepositoryLocation.getAuthenticator();
    }

    public void setUserAuthenticator(IUserAuthenticator authenticator) {
        CVSRepositoryLocation.authenticator = authenticator;
    }

    public Preferences getPreferences() {
        if (!this.hasPreferences()) {
            this.ensurePreferencesStored();
        }
        return this.internalGetPreferences();
    }

    private Preferences internalGetPreferences() {
        return CVSRepositoryLocation.getParentPreferences().node(this.getPreferenceName());
    }

    private boolean hasPreferences() {
        try {
            return CVSRepositoryLocation.getParentPreferences().nodeExists(this.getPreferenceName());
        }
        catch (BackingStoreException e) {
            CVSProviderPlugin.log(4, NLS.bind((String)CVSMessages.CVSRepositoryLocation_74, (Object[])new String[]{this.getLocation(true)}), e);
            return false;
        }
    }

    private String getPreferenceName() {
        return this.getLocation().replace('/', '%').replace(':', '%');
    }

    public void storePreferences() {
        Preferences prefs = this.internalGetPreferences();
        prefs.put(PREF_LOCATION, this.getLocation());
        this.flushPreferences();
    }

    private void flushPreferences() {
        try {
            this.internalGetPreferences().flush();
        }
        catch (BackingStoreException e) {
            CVSProviderPlugin.log(4, NLS.bind((String)CVSMessages.CVSRepositoryLocation_75, (Object[])new String[]{this.getLocation(true)}), e);
        }
    }

    private void ensurePreferencesStored() {
        if (!this.hasPreferences()) {
            this.storePreferences();
        }
    }

    public boolean getUserInfoCached() {
        ISecurePreferences node = this.getCVSNode();
        if (node == null) {
            return false;
        }
        try {
            String password = node.get(PASSWORD_KEY, null);
            return password != null;
        }
        catch (StorageException e) {
            CVSProviderPlugin.log(4, e.getMessage(), e);
            return false;
        }
    }

    private ISecurePreferences getCVSNode() {
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences == null) {
            return null;
        }
        String accountName = EncodingUtils.encodeSlashes((String)this.getLocation(true));
        String path = cvsNameSegment + accountName;
        try {
            return preferences.node(path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

