/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.jobs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.tesla.jobs.IProfilingJobsListener;

public class ProfilingJobsEventManager {
    private static ProfilingJobsEventManager INSTANCE = null;
    private List<IProfilingJobsListener> listeners = new ArrayList<IProfilingJobsListener>();

    public static synchronized ProfilingJobsEventManager getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new ProfilingJobsEventManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IProfilingJobsListener listener) {
        List<IProfilingJobsListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IProfilingJobsListener listener) {
        List<IProfilingJobsListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProfilingJobsListener[] getListeners() {
        List<IProfilingJobsListener> list = this.listeners;
        synchronized (list) {
            return new ArrayList<IProfilingJobsListener>(this.listeners).toArray(new IProfilingJobsListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobChangeState(InternalJob job, int newState) {
        List<IProfilingJobsListener> list = this.listeners;
        synchronized (list) {
            for (IProfilingJobsListener l : this.listeners) {
                l.jobChangeStatus(job, newState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobSchedule(InternalJob job, long delay, boolean reshedule) {
        List<IProfilingJobsListener> list = this.listeners;
        synchronized (list) {
            for (IProfilingJobsListener l : this.listeners) {
                l.jobSchedule(job, delay, reshedule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobCanceled(InternalJob job) {
        List<IProfilingJobsListener> list = this.listeners;
        synchronized (list) {
            for (IProfilingJobsListener l : this.listeners) {
                l.jobCanceled(job);
            }
        }
    }

    public void endJob(InternalJob job, IStatus status, boolean notify) {
        IProfilingJobsListener[] listeners;
        IProfilingJobsListener[] iProfilingJobsListenerArray = listeners = ProfilingJobsEventManager.getDefault().getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IProfilingJobsListener l = iProfilingJobsListenerArray[n2];
            l.endJob(job, status, notify);
            ++n2;
        }
    }
}

