/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.ecl.core.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.VerificationsRuntime;
import org.eclipse.rcptt.core.ecl.core.model.ExecVerification;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.parser.ScriptErrorStatus;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ReportingFactory;
import org.eclipse.rcptt.reporting.ResultStatus;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.InfoFactory;
import org.eclipse.rcptt.tesla.ecl.TeslaErrorStatus;
import org.eclipse.rcptt.tesla.internal.core.TeslaProcessorManager;
import org.eclipse.rcptt.tesla.internal.core.info.GeneralInformationCollector;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.verifications.runtime.VerificationReporter;
import org.eclipse.rcptt.verifications.runtime.VerificationStatus;
import org.eclipse.swt.widgets.Display;

public class ExecVerificationService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        block16: {
            ExecVerification execVerification = (ExecVerification)command;
            Verification verification = execVerification.getVerification();
            INodeBuilder node = ReportManager.getCurrentReportNode().beginTask(verification.getName() == null ? "Unnamed verification" : verification.getName());
            Q7Info info = ReportingFactory.eINSTANCE.createQ7Info();
            info.setType(ItemKind.VERIFICATION);
            info.setId(verification.getId());
            info.setTags(verification.getTags());
            info.setSubtype(verification.getId());
            info.setPhase(execVerification.getPhase().toString());
            try {
                Throwable e2;
                block17: {
                    AdvancedInformation information;
                    try {
                        this.exec(execVerification, context);
                        if (node != null) {
                            info.setResult(ResultStatus.PASS);
                        }
                        break block16;
                    }
                    catch (Throwable e2) {
                        TeslaErrorStatus tes;
                        AdvancedInformation advancedInfo;
                        ScriptErrorStatus sest;
                        if (node != null) {
                            info.setResult(ResultStatus.FAIL);
                            if (e2 instanceof CoreException && ((CoreException)e2).getStatus() instanceof VerificationStatus) {
                                VerificationStatus st = (VerificationStatus)((CoreException)e2).getStatus();
                                info.setMessage(VerificationReporter.getStyledMessage((VerificationStatus)st).getMessage());
                            } else {
                                info.setMessage(e2.getMessage());
                            }
                            info.setDescription(verification.getDescription());
                        }
                        boolean processed = false;
                        if (e2 instanceof CoreException && ((CoreException)e2).getStatus() instanceof ScriptErrorStatus && (sest = (ScriptErrorStatus)((CoreException)e2).getStatus()).getCause() instanceof TeslaErrorStatus && (advancedInfo = (tes = (TeslaErrorStatus)sest.getCause()).getInfo()) != null) {
                            ReportHelper.addSnapshotWithData((INodeBuilder)node, (EObject)advancedInfo);
                            processed = true;
                        }
                        if (processed) break block17;
                        information = InfoFactory.eINSTANCE.createAdvancedInformation();
                        final ITeslaCommandProcessor[] processors = new TeslaProcessorManager().getProcessors();
                        try {
                            final boolean[] infoCollected = new boolean[1];
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ITeslaCommandProcessor[] iTeslaCommandProcessorArray = processors;
                                    int n = processors.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
                                        processor.collectInformation(information, null);
                                        ++n2;
                                    }
                                    infoCollected[0] = true;
                                }
                            });
                            long waitStart = System.currentTimeMillis();
                            while (!infoCollected[0] && System.currentTimeMillis() - waitStart < 15000L) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    GeneralInformationCollector.collectInformation((AdvancedInformation)information);
                    ReportHelper.addSnapshotWithData((INodeBuilder)node, (EObject)information);
                }
                if (e2 instanceof CoreException) {
                    throw (CoreException)e2;
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.core.ecl.core", "Failed to execute verification: " + e2.getMessage(), e2));
            }
            finally {
                ReportHelper.setInfo((INodeBuilder)node, (Q7Info)info);
                node.endTask();
            }
        }
        return Status.OK_STATUS;
    }

    public void exec(ExecVerification execVerification, IProcess process) throws InterruptedException, CoreException {
        Verification verification = execVerification.getVerification();
        switch (execVerification.getPhase()) {
            case START: {
                VerificationsRuntime.getInstance().executeStart(verification, process);
                break;
            }
            case RUN: {
                VerificationsRuntime.getInstance().executeRun(verification, process);
                break;
            }
            case FINISH: {
                VerificationsRuntime.getInstance().executeFinish(verification, process);
                break;
            }
            case AUTO: {
                VerificationType type = VerificationTypeManager.getInstance().getTypeByVerification(verification);
                String[] phases = type.getPhases();
                if (phases.length != 1) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.core.ecl.core", "Failed to execute verification (phase auto-detection failed)."));
                }
                String phase = phases[phases.length - 1];
                if (phase.equals("start")) {
                    VerificationsRuntime.getInstance().executeStart(verification, process);
                    break;
                }
                if (phase.equals("run")) {
                    VerificationsRuntime.getInstance().executeRun(verification, process);
                    break;
                }
                if (!phase.equals("finish")) break;
                VerificationsRuntime.getInstance().executeFinish(verification, process);
            }
        }
    }
}

