/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.projectsettings;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.ProjectMetadata;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.editors.NamedElementEditor;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.editors.projectsettings.Q7ProjectEditorPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class Q7ProjectEditor
extends NamedElementEditor {
    Q7ProjectEditorPage page;

    public IQ7ProjectMetadata getModel() {
        return (IQ7ProjectMetadata)super.getModel();
    }

    public ProjectMetadata getElement() {
        return (ProjectMetadata)super.getElement();
    }

    @Override
    protected void updateElement() throws ModelException, PartInitException {
        super.updateElement();
        this.updateEditorTitle();
    }

    @Override
    protected void updateEditorTitle() {
        this.setPartName(String.valueOf(this.getModel().getQ7Project().getName()) + " - Project Settings");
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.updateEditorTitle();
    }

    protected void addPages() {
        try {
            this.page = new Q7ProjectEditorPage(this);
            this.addPage((IFormPage)this.page);
        }
        catch (PartInitException e) {
            Q7UIPlugin.log(e);
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        this.page.updateContent();
        super.doSave(monitor);
    }

    protected void createPages() {
        super.createPages();
        if (this.getPageCount() < 2) {
            this.hideTabs();
        }
    }

    @Override
    public void createActions() {
        this.actions = new NamedElementEditorActions(new NamedElementEditorActions.INamedElementActions(){

            @Override
            public void undo() {
                Q7ProjectEditor.this.page.undo();
                Q7ProjectEditor.this.updateEnablement();
            }

            @Override
            public void redo() {
                Q7ProjectEditor.this.page.redo();
                Q7ProjectEditor.this.updateEnablement();
            }

            @Override
            public void paste() {
                if (this.isContextsFocus()) {
                    Q7ProjectEditor.this.page.getContextTable().paste();
                }
                if (this.isVerificationFocus()) {
                    Q7ProjectEditor.this.page.getVerificationsTable().paste();
                }
                Q7ProjectEditor.this.updateEnablement();
            }

            @Override
            public void cut() {
                if (this.isContextsFocus()) {
                    Q7ProjectEditor.this.page.getContextTable().cut();
                }
                if (this.isVerificationFocus()) {
                    Q7ProjectEditor.this.page.getVerificationsTable().cut();
                }
                Q7ProjectEditor.this.updateEnablement();
            }

            @Override
            public void copy() {
                if (this.isContextsFocus()) {
                    Q7ProjectEditor.this.page.getContextTable().copy();
                }
                if (this.isVerificationFocus()) {
                    Q7ProjectEditor.this.page.getVerificationsTable().copy();
                }
                Q7ProjectEditor.this.updateEnablement();
            }

            private boolean isContextsFocus() {
                return Q7ProjectEditor.this.page.getContextTable().getControl().isFocusControl();
            }

            private boolean isVerificationFocus() {
                return Q7ProjectEditor.this.page.getVerificationsTable().getControl().isFocusControl();
            }

            @Override
            public boolean canUndo() {
                boolean ctxOrVerif;
                boolean bl = ctxOrVerif = this.isContextsFocus() || this.isVerificationFocus();
                return Q7ProjectEditor.this.page.canUndo() && !ctxOrVerif;
            }

            @Override
            public boolean canRedo() {
                boolean ctxOrVerif;
                boolean bl = ctxOrVerif = this.isContextsFocus() || this.isVerificationFocus();
                return Q7ProjectEditor.this.page.canRedo() && !ctxOrVerif;
            }

            @Override
            public boolean canPaste() {
                if (this.isContextsFocus()) {
                    return Q7ProjectEditor.this.page.getContextTable().canPaste();
                }
                if (this.isVerificationFocus()) {
                    return Q7ProjectEditor.this.page.getVerificationsTable().canPaste();
                }
                return false;
            }

            @Override
            public boolean canCut() {
                if (this.isContextsFocus()) {
                    return Q7ProjectEditor.this.page.getContextTable().canCut();
                }
                if (this.isVerificationFocus()) {
                    return Q7ProjectEditor.this.page.getVerificationsTable().canCut();
                }
                return false;
            }

            @Override
            public boolean canCopy() {
                if (this.isContextsFocus()) {
                    return Q7ProjectEditor.this.page.getContextTable().canCopy();
                }
                if (this.isVerificationFocus()) {
                    return Q7ProjectEditor.this.page.getVerificationsTable().canCopy();
                }
                return false;
            }
        }, this.getEditorSite().getActionBars());
    }

    @Override
    protected void afterMissingReferencesAdded() {
        this.page.refreshPage();
    }
}

