/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.panels.assertion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.rcptt.core.recording.CommandSet;
import org.eclipse.rcptt.ecl.core.BoxedValue;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.tesla.core.protocol.Assert;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.ui.Color;
import org.eclipse.rcptt.tesla.core.ui.DiagramItem;
import org.eclipse.rcptt.tesla.core.ui.PropertyNode;
import org.eclipse.rcptt.tesla.core.ui.UiPackage;
import org.eclipse.rcptt.tesla.ecl.model.GetWidgetDetails;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.tesla.internal.core.SimpleCommandPrinter;
import org.eclipse.rcptt.ui.panels.ActionToolbar;
import org.eclipse.rcptt.ui.panels.Actions;
import org.eclipse.rcptt.ui.panels.MenuToolbar;
import org.eclipse.rcptt.ui.panels.assertion.AssertContentProvider;
import org.eclipse.rcptt.ui.panels.assertion.AssertGroup;
import org.eclipse.rcptt.ui.panels.assertion.AssertImageWindow;
import org.eclipse.rcptt.ui.panels.assertion.AssertInput;
import org.eclipse.rcptt.ui.panels.assertion.AssertOperationEditingSupport;
import org.eclipse.rcptt.ui.panels.assertion.AssertValueEditingSupport;
import org.eclipse.rcptt.ui.panels.assertion.AssertionUtils;
import org.eclipse.rcptt.ui.panels.assertion.WidgetDetailsDialog;
import org.eclipse.rcptt.ui.recording.RecordingSupport;
import org.eclipse.rcptt.ui.utils.ImageManager;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class AssertionPanelWindow
extends Dialog {
    private static final String SETTINGS_KEY = "AssertionPanelWindow";
    private final DataBindingContext dbc = new DataBindingContext();
    private WidgetDetailsDialog widgetDetailsDialog;
    private ImageManager imageManager = new ImageManager();
    private final IAction collapseAll = new Action(){
        {
            this.setImageDescriptor(Images.getImageDescriptor("icons/panel/collapseall.gif"));
            this.setToolTipText(Messages.AssertionPanelWindow_CollapseAllActionToolTip);
        }

        public void run() {
            AssertionPanelWindow.this.viewer.collapseAll();
        }
    };
    private final IAction expandAll = new Action(){
        {
            this.setImageDescriptor(Images.getImageDescriptor("icons/panel/expandall.gif"));
            this.setToolTipText(Messages.AssertionPanelWindow_ExpandAllActionToolTip);
        }

        public void run() {
            AssertionPanelWindow.this.viewer.expandToLevel(2);
        }
    };
    private final IAction selectAll = new Action(Messages.AssertionPanelWindow_SelectAllActionText){
        {
            this.setImageDescriptor(Images.getImageDescriptor("icons/panel/selectall.gif"));
            this.setDisabledImageDescriptor(Images.getImageDescriptor("icons/panel/d-selectall.gif"));
            this.setToolTipText(Messages.AssertionPanelWindow_SelectAllActionToolTip);
        }

        public void run() {
            for (AssertGroup obj : ((AssertInput)AssertionPanelWindow.this.viewer.getInput()).getAsserts()) {
                AssertionPanelWindow.this.checkedObservable.add((Object)obj);
                AssertionPanelWindow.this.checkedObservable.addAll(obj.getAsserts());
            }
        }
    };
    private final IAction deselectAll = new Action(){
        {
            this.setImageDescriptor(Images.getImageDescriptor("icons/panel/deselectall.gif"));
            this.setDisabledImageDescriptor(Images.getImageDescriptor("icons/panel/d-deselectall.gif"));
            this.setToolTipText(Messages.AssertionPanelWindow_DeselectAllActionToolTip);
        }

        public void run() {
            AssertionPanelWindow.this.checkedObservable.clear();
        }
    };
    private final RecordingSupport recordingSupport;
    private final Shell parentShell;
    private CheckboxTreeViewer viewer;
    private FontMetrics fontMetrics;
    private static final List<EAttribute> deprecated = Arrays.asList(UiPackage.Literals.TEXT__RAW_VALUE, UiPackage.Literals.TEXT__VALUE, UiPackage.Literals.TEXT__STYLE_RANGES, UiPackage.Literals.TREE_ITEM__STYLE_RANGES, UiPackage.Literals.TABLE_ITEM__STYLE_RANGES);
    private CommandSet commands;
    private final WritableValue hasAssert = new WritableValue((Object)false, Boolean.class);
    private AssertInput currentInput;
    private IViewerObservableSet checkedObservable;
    private Button appendButton;

    public AssertionPanelWindow(RecordingSupport recordingSupport, Shell parentShell) {
        super(parentShell);
        this.recordingSupport = recordingSupport;
        this.parentShell = parentShell;
        this.setShellStyle(16468);
    }

    protected Shell getParentShell() {
        return this.parentShell;
    }

    protected boolean addImageAssert() {
        if (this.commands == null) {
            return false;
        }
        if (this.commands != null && this.commands.getImageCapture() == null) {
            return false;
        }
        AssertImageWindow win = new AssertImageWindow(this.getShell(), this);
        win.setInput(this.commands.getImageCapture());
        win.setBlockOnOpen(true);
        if (win.open() == 0) {
            Assert result = win.getAssert();
            result.setElement((Element)EcoreUtil.copy((EObject)this.currentInput.getElement()));
            this.recordingSupport.getRecorder().addAsserts(this.commands, new Assert[]{result});
            return true;
        }
        return false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AssertionPanelWindow_Title);
        newShell.setLayout((Layout)new FillLayout());
        newShell.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    AssertionPanelWindow.this.closeAndContinueRecording();
                }
            }
        });
        newShell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\u001b') {
                    AssertionPanelWindow.this.closeAndContinueRecording();
                }
            }
        });
        GridLayoutFactory.fillDefaults().equalWidth(true).spacing(0, 0).margins(0, 0).applyTo((Composite)newShell);
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AssertionPanelWindow.this.imageManager.dispose();
            }
        });
    }

    public boolean close() {
        if (this.recordingSupport.getMode() == RecordingSupport.RecordingMode.Asserting) {
            this.recordingSupport.getRecorder().resetAssertSelection();
        }
        return super.close();
    }

    protected void closeAndContinueRecording() {
        this.close();
        this.recordingSupport.setMode(RecordingSupport.RecordingMode.Recording);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings root = Q7UIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = root.getSection(SETTINGS_KEY);
        if (section == null) {
            section = root.addNewSection(SETTINGS_KEY);
        }
        return section;
    }

    protected boolean hasDialogBoundsSettings() {
        IDialogSettings root = Q7UIPlugin.getDefault().getDialogSettings();
        return root.getSection(SETTINGS_KEY) != null;
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected Point getInitialLocation(Point size) {
        Point loc = Display.getDefault().getCursorLocation();
        Rectangle displayBounds = this.getDisplayBounds(loc);
        if (loc.x + size.x > displayBounds.x + displayBounds.width) {
            loc.x -= size.x;
        }
        if (loc.y + size.y > displayBounds.y + displayBounds.height) {
            loc.y = displayBounds.y + displayBounds.height - size.y;
        }
        return loc;
    }

    protected Rectangle getDisplayBounds(Point loc) {
        Monitor[] ms = this.getShell().getDisplay().getMonitors();
        if (ms.length > 1) {
            int i = 0;
            while (i < ms.length) {
                Rectangle tmp = ms[i].getBounds();
                if (tmp.contains(loc)) {
                    return tmp;
                }
                ++i;
            }
        }
        return this.getShell().getDisplay().getBounds();
    }

    protected Point getInitialSize() {
        if (this.hasDialogBoundsSettings()) {
            return super.getInitialSize();
        }
        Rectangle bounds = this.getShell().getDisplay().getBounds();
        int height = bounds.height / 2 - bounds.height / 10;
        return new Point(450, height);
    }

    protected TreeViewerColumn createPropertyColumn() {
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this.viewer, 0);
        column.getColumn().setText(Messages.AssertionPanelWindow_ColumnPropertyName);
        column.getColumn().setToolTipText(Messages.AssertionPanelWindow_ColumnPropertyToolTip);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String result = null;
                if (element instanceof AssertGroup) {
                    result = ((AssertGroup)element).getName();
                } else if (element instanceof Assert) {
                    Assert a = (Assert)element;
                    String attrName = a.getAttribute();
                    int ind = StringUtils.getAttrLastSplitterInd((String)attrName);
                    if (ind > 0) {
                        attrName = attrName.substring(attrName.lastIndexOf(".") + 1);
                    }
                    if (attrName.indexOf(91) > 0) {
                        attrName = attrName.substring(attrName.indexOf(91), attrName.indexOf(93) + 1);
                    }
                    result = attrName;
                }
                if (result != null) {
                    result = result.replace("\n", "\\n").replace("\r", "");
                }
                return result;
            }
        });
        return column;
    }

    protected TreeViewerColumn createOperationColumn() {
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this.viewer, 0);
        column.getColumn().setText(Messages.AssertionPanelWindow_ColumnOperationName);
        column.getColumn().setToolTipText(Messages.AssertionPanelWindow_ColumnOperationToolTip);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Assert) {
                    return ((Assert)element).getKind().getLiteral();
                }
                return null;
            }
        });
        column.setEditingSupport((EditingSupport)new AssertOperationEditingSupport((ColumnViewer)this.viewer));
        return column;
    }

    protected TreeViewerColumn createValueColumn() {
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this.viewer, 0);
        column.getColumn().setText(Messages.AssertionPanelWindow_ValueOperationName);
        column.getColumn().setToolTipText(Messages.AssertionPanelWindow_ValueOperationToolTip);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String result = null;
                if (element instanceof Assert) {
                    result = ((Assert)element).getValue();
                }
                if (result != null) {
                    result = result.replace("\n", "\\n").replace("\r", "");
                }
                return result;
            }
        });
        column.setEditingSupport((EditingSupport)new AssertValueEditingSupport((TreeViewer)this.viewer));
        return column;
    }

    private void createColumnViewers(TreeColumnLayout layout) {
        layout.setColumnData((Widget)this.createPropertyColumn().getColumn(), (ColumnLayoutData)new ColumnWeightData(20));
        layout.setColumnData((Widget)this.createOperationColumn().getColumn(), (ColumnLayoutData)new ColumnWeightData(8));
        layout.setColumnData((Widget)this.createValueColumn().getColumn(), (ColumnLayoutData)new ColumnWeightData(35));
    }

    protected void processCheck(Object element, boolean checked) {
        if (element instanceof AssertGroup) {
            if (this.viewer.getExpandedState(element)) {
                for (Object a : ((AssertGroup)element).getAsserts()) {
                    this.viewer.setChecked(a, checked);
                    this.viewer.setGrayed(a, false);
                    if (a instanceof Assert) {
                        if (checked) {
                            this.checkedObservable.add(a);
                            continue;
                        }
                        this.checkedObservable.remove(a);
                        continue;
                    }
                    this.processCheck(a, checked);
                }
                this.viewer.setGrayed(element, false);
            } else {
                this.viewer.setChecked(element, false);
                this.viewer.setGrayed(element, false);
            }
        }
        AssertGroup parent = element instanceof Assert ? ((AssertInput)this.viewer.getInput()).getParent(element) : (AssertGroup)element;
        while (parent != null) {
            boolean hasChecked = false;
            boolean hasUnchecked = false;
            for (Object a : parent.getAsserts()) {
                if (this.viewer.getChecked(a)) {
                    hasChecked = true;
                    hasUnchecked |= this.viewer.getGrayed(a);
                    continue;
                }
                hasUnchecked = true;
            }
            if (hasChecked) {
                this.viewer.setChecked((Object)parent, true);
                this.viewer.setGrayed((Object)parent, hasUnchecked);
                this.checkedObservable.add((Object)parent);
            } else {
                this.viewer.setChecked((Object)parent, false);
                this.viewer.setGrayed((Object)parent, false);
                this.checkedObservable.remove((Object)parent);
            }
            parent = ((AssertInput)this.viewer.getInput()).getParent(parent);
        }
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout());
        Composite toolbarComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(toolbarComposite);
        toolbarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ActionToolbar actions = new ActionToolbar(){

            @Override
            protected void fill(ToolBarManager manager) {
                manager.add(AssertionPanelWindow.this.selectAll);
                manager.add(AssertionPanelWindow.this.deselectAll);
                manager.add((IContributionItem)new Separator());
                manager.add(AssertionPanelWindow.this.expandAll);
                manager.add(AssertionPanelWindow.this.collapseAll);
                AssertionPanelWindow.this.dbc.bindValue(Actions.observeEnabled(AssertionPanelWindow.this.selectAll), (IObservableValue)AssertionPanelWindow.this.hasAssert);
                AssertionPanelWindow.this.dbc.bindValue(Actions.observeEnabled(AssertionPanelWindow.this.deselectAll), (IObservableValue)AssertionPanelWindow.this.hasAssert);
                AssertionPanelWindow.this.dbc.bindValue(Actions.observeEnabled(AssertionPanelWindow.this.expandAll), (IObservableValue)AssertionPanelWindow.this.hasAssert);
                AssertionPanelWindow.this.dbc.bindValue(Actions.observeEnabled(AssertionPanelWindow.this.collapseAll), (IObservableValue)AssertionPanelWindow.this.hasAssert);
            }
        };
        actions.create(toolbarComposite).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        MenuToolbar menu = new MenuToolbar(){

            @Override
            protected void fill(MenuManager manager) {
                manager.add((IAction)new Action(Messages.AssertionPanelWindow_CloseActionName){

                    public void run() {
                        AssertionPanelWindow.this.close();
                    }
                });
            }
        };
        menu.create(toolbarComposite).setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.createTreeViewer(composite).setLayoutData((Object)new GridData(4, 4, true, true));
        this.createButtonPanel(composite).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite;
    }

    protected Control createTreeViewer(Composite parent) {
        Composite treeComposite = new Composite(parent, 0);
        TreeColumnLayout layout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)layout);
        Tree tree = new Tree(treeComposite, 67616);
        tree.setHeaderVisible(true);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)tree), (IObservableValue)this.hasAssert);
        this.viewer = new CheckboxTreeViewer(tree);
        this.createColumnViewers(layout);
        this.viewer.setContentProvider((IContentProvider)new AssertContentProvider(this.getAut()));
        this.viewer.setUseHashlookup(true);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AssertionPanelWindow.this.processCheck(event.getElement(), event.getChecked());
            }
        });
        return treeComposite;
    }

    public AutLaunch getAut() {
        return this.recordingSupport.getAUT();
    }

    protected void initializeDialogUnits(Control control) {
        Shell sh = new Shell(control.getDisplay());
        sh.setVisible(false);
        GC gc = new GC((Drawable)sh);
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        sh.dispose();
    }

    public static int convertHorizontalDLUsToPixels(FontMetrics fontMetrics, int dlus) {
        return (fontMetrics.getAverageCharWidth() * dlus + 2) / 4;
    }

    protected int convertHorizontalDLUsToPixels(int dlus) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return AssertionPanelWindow.convertHorizontalDLUsToPixels(this.fontMetrics, dlus);
    }

    protected int getButtonWidth(Button button) {
        Point minSize = button.computeSize(-1, -1, true);
        return minSize.x;
    }

    protected Control createButtonPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        final Button widgetInfo = new Button(composite, 0);
        GridDataFactory.swtDefaults().align(16384, 0x1000000).applyTo((Control)widgetInfo);
        widgetInfo.setText("Widget details...");
        widgetInfo.setImage(Images.getImageDescriptor("icons/panel/widget_details.gif").createImage());
        widgetInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetWidgetDetails getDetails = TeslaFactory.eINSTANCE.createGetWidgetDetails();
                getDetails.setElement((Element)EcoreUtil.copy((EObject)AssertionPanelWindow.this.commands.getElement()));
                Object result = null;
                try {
                    result = AssertionPanelWindow.this.getAut().execute((Command)getDetails);
                }
                catch (Exception eeee) {
                    Q7UIPlugin.log(eeee);
                }
                if (result != null && result instanceof BoxedValue) {
                    String msg = BoxedValues.toString((BoxedValue)((BoxedValue)result));
                    AssertionPanelWindow.this.widgetDetailsDialog = new WidgetDetailsDialog(widgetInfo.getShell(), msg);
                    AssertionPanelWindow.this.widgetDetailsDialog.open();
                }
            }
        });
        this.appendButton = new Button(composite, 0);
        GridDataFactory.swtDefaults().align(131072, 0x1000000).grab(true, false).hint(120, -1).applyTo((Control)this.appendButton);
        this.appendButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD").createImage());
        this.appendButton.setText(Messages.AssertionPanelWindow_AddAssertButton);
        this.appendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssertionPanelWindow.this.addButtonPressed();
                AssertionPanelWindow.this.close();
            }
        });
        this.checkedObservable = ViewersObservables.observeCheckedElements((CheckboxTreeViewer)this.viewer, null);
        ComputedValue computed = new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                if (!((Boolean)AssertionPanelWindow.this.hasAssert.getValue()).booleanValue()) {
                    return false;
                }
                return !AssertionPanelWindow.this.checkedObservable.isEmpty();
            }
        };
        this.dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.appendButton), (IObservableValue)computed);
        return composite;
    }

    protected void addButtonPressed() {
        this.recordingSupport.getRecorder().addAsserts(this.commands, this.getCheckedAsserts().toArray(new Assert[0]));
        this.viewer.setCheckedElements(new Object[0]);
    }

    private List<Assert> getCheckedAsserts() {
        ArrayList<Assert> asserts = new ArrayList<Assert>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof Assert) {
                asserts.add((Assert)element);
            }
            ++n2;
        }
        return asserts;
    }

    protected AssertInput createAssertTree(CommandSet commands) {
        org.eclipse.rcptt.tesla.core.ui.Widget widget = commands.getWidget();
        Element element = commands.getElement();
        ArrayList<AssertGroup> result = new ArrayList<AssertGroup>();
        ArrayList<Object> basicGroup = new ArrayList<Object>();
        this.createWidgetPropertiesAssert(basicGroup, widget, element);
        this.createWidgetReferencesAssert(basicGroup, widget, element);
        if (!basicGroup.isEmpty()) {
            result.add(new AssertGroup(String.valueOf(widget.eClass().getName()) + " (Basic Properties)", basicGroup));
        }
        if (widget instanceof DiagramItem) {
            ArrayList<Object> modelGroup = new ArrayList<Object>();
            AssertionUtils.fillAdvancedPropertiesGroup(modelGroup, (EList<PropertyNode>)((DiagramItem)widget).getModelPropertyNodes(), element, "");
            if (!modelGroup.isEmpty()) {
                result.add(new AssertGroup(String.valueOf(widget.eClass().getName()) + " (Model Properties)", modelGroup));
            }
        }
        ArrayList<Object> advancedGroup = new ArrayList<Object>();
        AssertionUtils.fillAdvancedPropertiesGroup(advancedGroup, (EList<PropertyNode>)((AssertContentProvider)this.viewer.getContentProvider()).loadChildren(element, "").getPropertyNodes(), element, "");
        if (!advancedGroup.isEmpty()) {
            result.add(new AssertGroup(String.valueOf(widget.eClass().getName()) + " (Advanced Properties)", advancedGroup));
        }
        return new AssertInput(result, element);
    }

    private void createWidgetPropertiesAssert(List<Object> group, org.eclipse.rcptt.tesla.core.ui.Widget widget, Element element) {
        this.createWidgetPropertiesAssert(group, (EObject)widget, element, "");
    }

    private void createWidgetPropertiesAssert(List<Object> group, EObject widget, Element element, String propertyPath) {
        if (propertyPath.length() > 0) {
            propertyPath = String.valueOf(propertyPath) + ".";
        }
        for (EAttribute attr : widget.eClass().getEAllAttributes()) {
            Object value;
            if (deprecated.contains(attr) || (value = widget.eGet((EStructuralFeature)attr)) == null) continue;
            String attrName = attr.getName();
            if (attr.isMany()) {
                List list;
                if (!(value instanceof List) || (list = (List)value).isEmpty()) continue;
                ArrayList<Object> children = new ArrayList<Object>();
                int i = 0;
                while (i < list.size()) {
                    String childPropertyPath = String.format("%s%s[%d]", propertyPath, attrName, i);
                    children.add(AssertionUtils.createAssert(childPropertyPath, list.get(i), attr.getEType(), element, null));
                    ++i;
                }
                group.add(new AssertGroup(attrName, children));
                continue;
            }
            group.add(AssertionUtils.createAssert(String.valueOf(propertyPath) + attr.getName(), value, attr.getEType(), element, null));
        }
    }

    private void createWidgetReferencesAssert(List<Object> group, org.eclipse.rcptt.tesla.core.ui.Widget widget, Element element) {
        this.createWidgetReferencesAssert(group, (EObject)widget, element, "");
    }

    private void createWidgetReferencesAssert(List<Object> group, EObject widget, Element element, String propertyPath) {
        if (propertyPath.length() > 0) {
            propertyPath = String.valueOf(propertyPath) + ".";
        }
        for (EReference attr : widget.eClass().getEAllReferences()) {
            Assert a;
            String childPropertyName;
            if (attr.equals(UiPackage.Literals.CONTROL__BOUNDS)) continue;
            if (!attr.isMany()) {
                String childPropertyPath = String.valueOf(propertyPath) + attr.getName();
                Object value = widget.eGet((EStructuralFeature)attr);
                if (value instanceof Color) {
                    if (value == null || !(value instanceof EObject)) continue;
                    group.add(AssertionUtils.createAssert(childPropertyPath, SimpleCommandPrinter.toString((EObject)((EObject)value), (boolean)true, (String[])new String[0]).trim(), (EClassifier)EcorePackage.eINSTANCE.getEString(), element, null));
                    continue;
                }
                if (!(value instanceof EObject)) continue;
                ArrayList<Object> children = new ArrayList<Object>();
                this.createWidgetPropertiesAssert(children, (EObject)value, element, childPropertyPath);
                this.createWidgetReferencesAssert(children, (EObject)value, element, childPropertyPath);
                group.add(new AssertGroup(attr.getName(), children));
                continue;
            }
            Object elements = widget.eGet((EStructuralFeature)attr);
            ArrayList<Object> children = new ArrayList<Object>();
            if (elements instanceof EMap) {
                EMap map = (EMap)elements;
                if (map.isEmpty()) continue;
                for (Map.Entry entry : map.entrySet()) {
                    childPropertyName = String.format("%s%s['%s']", propertyPath, attr.getName(), entry.getKey().toString());
                    a = AssertionUtils.createAssert(childPropertyName, entry.getValue().toString(), (EClassifier)EcorePackage.eINSTANCE.getEString(), element, null);
                    children.add(a);
                }
            } else if (elements instanceof List) {
                List list = (List)elements;
                if (list.isEmpty()) continue;
                int i = 0;
                while (i < list.size()) {
                    Object v = list.get(i);
                    childPropertyName = String.format("%s%s[%d]", propertyPath, attr.getName(), i);
                    if (v instanceof Color) {
                        a = AssertionUtils.createAssert(childPropertyName, SimpleCommandPrinter.toString((EObject)((EObject)v), (boolean)true, (String[])new String[0]).trim(), (EClassifier)EcorePackage.eINSTANCE.getEString(), element, null);
                        children.add(a);
                    } else if (v instanceof EObject) {
                        ArrayList<Object> widgetChildren = new ArrayList<Object>();
                        this.createWidgetPropertiesAssert(widgetChildren, (EObject)v, element, childPropertyName);
                        this.createWidgetReferencesAssert(widgetChildren, (EObject)v, element, childPropertyName);
                        AssertGroup widgetGroup = new AssertGroup("[" + i + "]", widgetChildren);
                        children.add(widgetGroup);
                    }
                    ++i;
                }
            }
            if (children.isEmpty()) continue;
            group.add(new AssertGroup(attr.getName(), children));
        }
    }

    public void setInput(CommandSet commands) {
        if (this.widgetDetailsDialog != null) {
            this.widgetDetailsDialog.close();
        }
        this.commands = commands;
        this.hasAssert.setValue((Object)(commands != null ? 1 : 0));
        if (commands != null) {
            if (this.getShell() == null || this.getShell().isDisposed()) {
                this.setBlockOnOpen(false);
                this.open();
            } else {
                Point size = this.getShell().getSize();
                Point loc = this.getInitialLocation(size);
                this.getShell().setLocation(loc);
                this.getShell().setVisible(true);
            }
            this.currentInput = this.createAssertTree(commands);
            this.viewer.setInput((Object)this.currentInput);
            if (this.currentInput != null && this.currentInput.getAsserts() != null && this.currentInput.getAsserts().size() > 0) {
                this.viewer.expandToLevel((Object)this.currentInput.getAsserts().get(0), 1);
            } else {
                this.viewer.expandToLevel(1);
            }
        } else if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().setVisible(false);
            this.viewer.setInput((Object)AssertInput.EMPTY);
            this.currentInput = null;
        }
    }
}

