/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.tags;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.MultiList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.databinding.EObjectObservableList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.tags.TagsPackage;
import org.eclipse.rcptt.core.tags.TagsRegistry;
import org.eclipse.rcptt.core.utils.TagsUtil;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.RenameAction;
import org.eclipse.rcptt.ui.actions.edit.DeleteAction;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.utils.ModelUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class TagsView
extends ViewPart {
    private IObservableList tags;
    private EContentAdapter tagsLabelListener;
    private TreeViewer tagsViewer;
    private RenameAction renameAction;
    private DeleteAction deleteAction;
    private IAction replayAction;
    private IAction refreshAction;

    public void createPartControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new FillLayout());
        this.tagsViewer = new TreeViewer(panel);
        this.tagsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagsView.this.updateSelection((IStructuredSelection)event.getSelection());
            }
        });
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(new IObservableFactory(){

            public IObservable createObservable(Object target) {
                if (target instanceof IObservable) {
                    return (IObservable)target;
                }
                if (target instanceof Tag) {
                    Tag tag = (Tag)target;
                    EObjectObservableList tags = new EObjectObservableList((EObject)tag, (EStructuralFeature)TagsPackage.Literals.TAG__TAGS);
                    EObjectObservableList refs = new EObjectObservableList((EObject)tag, (EStructuralFeature)TagsPackage.Literals.TAG__REFS);
                    return new MultiList(new IObservableList[]{tags, refs});
                }
                return null;
            }
        }, null);
        this.tagsViewer.setContentProvider((IContentProvider)contentProvider);
        this.createActions();
        this.tagsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof Tag) {
                    return Images.getImage("icons/tag.gif");
                }
                if (element instanceof IQ7NamedElement) {
                    return ModelUtils.getImage((IQ7Element)((IQ7NamedElement)element));
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof Tag) {
                    Tag tag = (Tag)element;
                    String value = tag.getValue().trim();
                    if (value.length() == 0) {
                        return Messages.bind((String)Messages.TagsView_UntaggedLabelFormat, (Object)TagsUtil.getDistinctTagRefsCount((Tag)tag));
                    }
                    return Messages.bind((String)Messages.TagsView_TagLabelFormat, (Object)value, (Object)TagsUtil.getDistinctTagRefsCount((Tag)tag));
                }
                if (element instanceof IQ7NamedElement) {
                    return ModelUtils.getText((IQ7Element)((IQ7NamedElement)element));
                }
                return element != null ? element.toString() : "null";
            }
        });
        MenuManager menuManager = new MenuManager();
        this.fillMenu((IMenuManager)menuManager);
        this.tagsViewer.getControl().setMenu(menuManager.createContextMenu(this.tagsViewer.getControl()));
        this.fillToolbar(this.getViewSite().getActionBars().getToolBarManager());
        this.tagsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection iss = (IStructuredSelection)TagsView.this.tagsViewer.getSelection();
                Object element = iss.getFirstElement();
                if (element instanceof IQ7NamedElement) {
                    IQ7NamedElement q7Element = (IQ7NamedElement)element;
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (activePage != null) {
                        try {
                            IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)q7Element.getResource()));
                        }
                        catch (PartInitException e) {
                            Q7UIPlugin.log(e);
                        }
                    }
                }
            }
        });
        UIJob setInputJob = new UIJob(this.tagsViewer.getControl().getDisplay(), "Initialize tags view"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                TagsRegistry tagsRegistry = Q7UIPlugin.getDefault().getTags();
                TagsView.this.tagsLabelListener = new EContentAdapter(){

                    public void notifyChanged(final Notification notification) {
                        super.notifyChanged(notification);
                        if (notification.getFeature() == TagsPackage.Literals.TAG__REFS || notification.getFeature() == TagsPackage.Literals.TAG__VALUE || notification.getFeature() == TagsPackage.Literals.TAG__TAGS) {
                            Q7UIPlugin.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!TagsView.this.tagsViewer.getControl().isDisposed()) {
                                        Object parent = notification.getNotifier();
                                        while (parent instanceof Tag) {
                                            TagsView.this.tagsViewer.refresh(parent, true);
                                            parent = TagsUtil.getParentTag((Tag)((Tag)parent));
                                        }
                                    }
                                }
                            });
                        }
                    }
                };
                TagsRegistry tagsRegistry2 = tagsRegistry;
                synchronized (tagsRegistry2) {
                    tagsRegistry.eAdapters().add((Object)TagsView.this.tagsLabelListener);
                }
                TagsView.this.tagsViewer.setSorter(new ViewerSorter());
                TagsView.this.tags = EMFObservables.observeList((EObject)tagsRegistry, (EStructuralFeature)TagsPackage.Literals.TAGS_REGISTRY__TAGS);
                TagsView.this.tagsViewer.setInput((Object)TagsView.this.tags);
                return Status.OK_STATUS;
            }
        };
        setInputJob.schedule();
    }

    private void updateSelection(IStructuredSelection selection) {
        if (this.renameAction != null) {
            this.renameAction.selectionChanged(selection);
        }
        if (this.deleteAction != null) {
            this.deleteAction.selectionChanged(selection);
        }
    }

    private void createActions() {
        this.replayAction = new Action(Messages.TagsView_ReplayActionName, Images.getImageDescriptor("icons/recording/play.gif")){

            public void run() {
                LaunchUtils.launchContext(LaunchUtils.getContext(TagsView.this.tagsViewer.getSelection()), "run");
            }
        };
        this.renameAction = new RenameAction((IShellProvider)this.getSite(), this.tagsViewer.getTree());
        this.deleteAction = new DeleteAction((IShellProvider)this.getSite());
        this.refreshAction = new Action(Messages.TagsView_RefreshActionName, Images.getImageDescriptor("icons/refresh.gif")){

            public void run() {
                Object element = ((IStructuredSelection)TagsView.this.tagsViewer.getSelection()).getFirstElement();
                TagsView.this.tagsViewer.refresh(element, true);
            }
        };
    }

    private void fillMenu(IMenuManager manager) {
        manager.add(this.replayAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.renameAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.refreshAction);
    }

    private void fillToolbar(IToolBarManager manager) {
        manager.add(this.replayAction);
        manager.add((IAction)this.deleteAction);
        manager.add(this.refreshAction);
    }

    public void setFocus() {
        this.tagsViewer.getControl().setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        TagsRegistry registry;
        super.dispose();
        TagsRegistry tagsRegistry = registry = Q7UIPlugin.getDefault().getTags();
        synchronized (tagsRegistry) {
            registry.eAdapters().remove((Object)this.tagsLabelListener);
        }
        if (this.tags != null) {
            this.tags.dispose();
        }
    }
}

