/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryProject;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public final class BrowseRefactoringHistoryLabelProvider
extends RefactoringHistoryLabelProvider {
    private final ILabelProvider fDelegateLabelProvider;
    private final ILabelProvider fWorkbenchLabelProvider = new WorkbenchLabelProvider();

    public BrowseRefactoringHistoryLabelProvider(RefactoringHistoryControlConfiguration configuration) {
        super(configuration);
        Assert.isNotNull((Object)configuration);
        this.fDelegateLabelProvider = configuration.getLabelProvider();
    }

    public Image getImage(Object element) {
        if (element instanceof RefactoringHistoryProject) {
            RefactoringHistoryProject project = (RefactoringHistoryProject)element;
            return this.fWorkbenchLabelProvider.getImage((Object)ResourcesPlugin.getWorkspace().getRoot().getProject(project.getProject()));
        }
        return this.fDelegateLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof RefactoringHistoryProject) {
            RefactoringHistoryProject project = (RefactoringHistoryProject)element;
            return this.fWorkbenchLabelProvider.getText((Object)ResourcesPlugin.getWorkspace().getRoot().getProject(project.getProject()));
        }
        return this.fDelegateLabelProvider.getText(element);
    }

    public void dispose() {
        if (this.fDelegateLabelProvider != null) {
            this.fDelegateLabelProvider.dispose();
        }
        if (this.fWorkbenchLabelProvider != null) {
            this.fWorkbenchLabelProvider.dispose();
        }
        super.dispose();
    }
}

