/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import org.eclipse.core.runtime.IPath;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.state.ICheatSheetStateManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetExpandRestoreAction;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;

public class CheatSheetHelpPart
extends AbstractFormPart
implements IHelpPart {
    public static final String ID = "cheatsheet-page";
    private CheatSheetViewer viewer;
    private String id;

    public CheatSheetHelpPart(Composite parent, FormToolkit toolkit, IToolBarManager tbm, CheatSheetElement content, ICheatSheetStateManager trayManager) {
        this.id = content.getID();
        this.viewer = new CheatSheetViewer(true);
        this.viewer.createPartControl(parent);
        this.viewer.setContent(content, trayManager);
        this.contributeToToolBar(tbm);
    }

    private void contributeToToolBar(IToolBarManager tbm) {
        IPath path = CheatSheetPlugin.ICONS_PATH.append("elcl16/").append("collapseall.gif");
        ImageDescriptor collapseImage = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        CheatSheetExpandRestoreAction expandRestoreAction = new CheatSheetExpandRestoreAction(Messages.COLLAPSE_ALL_BUT_CURRENT_TOOLTIP, false, this.viewer);
        expandRestoreAction.setToolTipText(Messages.COLLAPSE_ALL_BUT_CURRENT_TOOLTIP);
        expandRestoreAction.setImageDescriptor(collapseImage);
        tbm.insertBefore("back", (IAction)expandRestoreAction);
        tbm.insertBefore("back", (IContributionItem)new Separator());
        this.viewer.setExpandRestoreAction(expandRestoreAction);
    }

    public boolean fillContextMenu(IMenuManager manager) {
        return false;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public IAction getGlobalAction(String id) {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasFocusControl(Control control) {
        return this.viewer.hasFocusControl(control);
    }

    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.id = id;
    }

    public void refilter() {
    }

    public void saveState(IMemento memento) {
    }

    public void setVisible(boolean visible) {
        this.viewer.getControl().setVisible(visible);
    }

    public void stop() {
    }

    public void toggleRoleFilter() {
    }
}

