/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.core.util;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.ecl.core.Binding;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Exec;
import org.eclipse.rcptt.ecl.core.ExecutableParameter;
import org.eclipse.rcptt.ecl.core.LiteralParameter;
import org.eclipse.rcptt.ecl.core.Parameter;
import org.eclipse.rcptt.ecl.core.Pipeline;
import org.eclipse.rcptt.ecl.core.Sequence;
import org.eclipse.rcptt.ecl.core.util.DefaultFormatter;
import org.eclipse.rcptt.ecl.core.util.ICommandFormatter;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.core.ParamConverterManager;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.IParamConverter;

public class CommandToStringConverter {
    private static final Pattern id = Pattern.compile("[a-zA-Z][a-zA-Z0-9]*");
    private static final Pattern number = Pattern.compile("[0-9]+");

    public String convert(Command command) {
        return this.convert(command, new DefaultFormatter());
    }

    public String convert(Command command, ICommandFormatter formatter) {
        this.doConvert(command, formatter, false);
        return formatter.toString();
    }

    protected void doConvert(Command command, ICommandFormatter formatter, boolean hasInput) {
        if (command instanceof Sequence) {
            this.convertSequence((Sequence)command, formatter, hasInput);
        } else if (command instanceof Pipeline) {
            this.convertPipeline((Pipeline)command, formatter, hasInput);
        } else if (command instanceof Exec) {
            this.convertExec((Exec)command, formatter, hasInput);
        } else {
            this.convertSimple(command, formatter, hasInput);
        }
    }

    private void convertExec(Exec exec, ICommandFormatter formatter, boolean hasInput) {
        if (exec.getNamespace() != null) {
            formatter.addCommandName(String.valueOf(exec.getNamespace()) + "::" + exec.getName());
        } else {
            formatter.addCommandName(exec.getName());
        }
        String lastParam = null;
        for (Parameter p : exec.getParameters()) {
            String name = p.getName();
            formatter.addAttrName(name, this.isForced(exec.getName(), name) && !name.equals(lastParam));
            lastParam = name;
            if (p instanceof LiteralParameter) {
                String value = this.convertValue(((LiteralParameter)p).getLiteral(), "string");
                formatter.addAttrValue(value);
                continue;
            }
            if (!(p instanceof ExecutableParameter)) continue;
            formatter.openExec();
            this.doConvert(((ExecutableParameter)p).getCommand(), formatter, hasInput);
            formatter.closeExec();
        }
    }

    protected void convertSequence(Sequence sequence, ICommandFormatter formatter, boolean hasInput) {
        EList<Command> commands = sequence.getCommands();
        int i = 0;
        while (i < commands.size()) {
            formatter.newSequenceCommand();
            this.doConvert((Command)commands.get(i), formatter, hasInput);
            ++i;
        }
    }

    protected void convertPipeline(Pipeline pipeline, ICommandFormatter formatter, boolean hasInput) {
        EList<Command> commands = pipeline.getCommands();
        int i = 0;
        while (i < commands.size()) {
            formatter.newPipeCommand();
            this.doConvert((Command)commands.get(i), formatter, i > 0 || hasInput);
            ++i;
        }
    }

    protected void convertSimple(Command command, ICommandFormatter formatter, boolean hasInput) {
        String commandName = CoreUtils.getScriptletNameByClass(command.eClass());
        formatter.addCommandName(commandName);
        HashMap<EStructuralFeature, Command> bindingMap = new HashMap<EStructuralFeature, Command>();
        for (Binding b : command.getBindings()) {
            bindingMap.put(b.getFeature(), b.getCommand());
        }
        List<EStructuralFeature> attributes = CoreUtils.getFeatures(command.eClass());
        boolean forced = false;
        for (EStructuralFeature feature : attributes) {
            boolean isDefault;
            if (feature.getEAnnotation("http://www.eclipse.org/ecl/internal") != null || feature.getEAnnotation("http://www.eclipse.org/ecl/input") != null && hasInput) continue;
            String name = feature.getName();
            if (this.isForced(commandName, name)) {
                forced = true;
            }
            Object val = command.eGet(feature);
            boolean skippped = true;
            Object defaultValue = feature.getDefaultValue();
            boolean bl = isDefault = val == null || val.equals(defaultValue);
            if (!isDefault) {
                if (feature instanceof EAttribute) {
                    EAttribute attr = (EAttribute)feature;
                    String type = attr.getEAttributeType().getInstanceTypeName();
                    if (val instanceof List) {
                        List list = (List)val;
                        for (Object o : list) {
                            String value = this.convertValue(o, type);
                            if (value == null) continue;
                            formatter.addAttrName(name, forced);
                            formatter.addAttrValue(value);
                            skippped = false;
                        }
                    } else if (val.equals(true)) {
                        forced = true;
                        formatter.addAttrName(name, forced);
                    } else {
                        String value = this.convertValue(val, type);
                        if (value != null) {
                            formatter.addAttrName(name, forced);
                            formatter.addAttrValue(value);
                            skippped = false;
                        }
                    }
                } else {
                    EReference ref = (EReference)feature;
                    EClass eclass = ref.getEReferenceType();
                    if (eclass.getClassifierID() == 0) {
                        boolean singleLine = !(val instanceof Sequence);
                        formatter.addAttrName(name, forced);
                        formatter.openGroup(singleLine);
                        this.doConvert((Command)val, formatter, true);
                        formatter.closeGroup(singleLine);
                        skippped = false;
                    } else {
                        IParamConverter converter = ParamConverterManager.getInstance().getConverter(eclass.getInstanceClass());
                        if (converter != null) {
                            try {
                                String strVal = String.format("\"%s\"", converter.convertToCode(val));
                                formatter.addAttrValue(strVal);
                            }
                            catch (CoreException e) {
                                CorePlugin.log(e.getStatus());
                            }
                        }
                    }
                }
            } else {
                Command c = (Command)bindingMap.get(feature);
                if (c != null) {
                    formatter.addAttrName(name, forced);
                    formatter.openExec();
                    this.doConvert(c, formatter, hasInput);
                    formatter.closeExec();
                    skippped = false;
                }
            }
            if (!skippped) continue;
            forced = true;
        }
    }

    protected boolean isForced(String commandName, String paramName) {
        return false;
    }

    protected String convertValue(Object val, String type) {
        String value = val.toString();
        if (type.equals("boolean") && value.equals("false") || type.equals("int") && value.equals("0")) {
            return null;
        }
        String opening = "";
        String closing = "";
        if (type.equals("boolean") && value.equals("true")) {
            value = "";
        } else if (!id.matcher(value).matches() && !number.matcher(value).matches()) {
            value = value.replace("\\", "\\\\");
            value = value.replace("\t", "\\t");
            value = value.replace("\b", "\\b");
            value = value.replace("\n", "\\n");
            value = value.replace("\r", "\\r");
            value = value.replace("\f", "\\f");
            value = value.replace("'", "\\'");
            value = value.replace("\"", "\\\"");
            opening = "\"";
            closing = "\"";
        }
        return String.valueOf(opening) + value + closing;
    }

    protected static class Counter {
        private int value;

        public Counter(int startValue) {
            this.value = startValue;
        }

        public int getNextValue() {
            return ++this.value;
        }
    }
}

