/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.ContentConsumer;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFileNonPluginContentConsumer
extends ContentConsumer {
    private String path;
    private boolean closed = false;

    public SiteFileNonPluginContentConsumer(String featurePath) {
        this.path = featurePath;
    }

    public void store(ContentReference contentReference, IProgressMonitor monitor) throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to store in a closed SiteFileNonPluginContentConsumer", new Exception());
            return;
        }
        InputStream inStream = null;
        String featurePath = this.path;
        String contentKey = contentReference.getIdentifier();
        featurePath = String.valueOf(featurePath) + contentKey;
        try {
            try {
                inStream = contentReference.getInputStream();
                UpdateManagerUtils.copyToLocal(inStream, featurePath, null);
                UpdateManagerUtils.checkPermissions(contentReference, featurePath);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.GlobalConsumer_ErrorCreatingFile, (Object[])new String[]{featurePath}), e);
            }
        }
        catch (Throwable throwable) {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void close() {
        if (this.closed) {
            UpdateCore.warn("Attempt to close a closed SiteFileNonPluginContentConsumer", new Exception());
            return;
        }
        this.closed = true;
    }
}

