/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.UpdateCore;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultPluginParser
extends DefaultHandler {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    private String id = null;
    private String version = null;
    private PluginEntry pluginEntry;
    private static final String PLUGIN = "plugin";
    private static final String FRAGMENT = "fragment";

    public DefaultPluginParser() {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            UpdateCore.log(e);
        }
        catch (SAXException e) {
            UpdateCore.log(e);
        }
    }

    public synchronized PluginEntry parse(InputStream in) throws SAXException, IOException {
        try {
            this.pluginEntry = new PluginEntry();
            this.parser.parse(new InputSource(in), (DefaultHandler)this);
        }
        catch (ParseCompleteException parseCompleteException) {}
        if (this.id == null || this.id.trim().length() == 0) {
            this.id = "_no_id_";
        }
        this.pluginEntry.setVersionedIdentifier(new VersionedIdentifier(this.id, this.version));
        return this.pluginEntry;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String tag = localName.trim();
        if (tag.equalsIgnoreCase(PLUGIN)) {
            this.pluginEntry.isFragment(false);
            this.processPlugin(attributes);
            return;
        }
        if (tag.equalsIgnoreCase(FRAGMENT)) {
            this.pluginEntry.isFragment(true);
            this.processPlugin(attributes);
            return;
        }
    }

    private void processPlugin(Attributes attributes) throws ParseCompleteException {
        this.id = attributes.getValue("id");
        this.version = attributes.getValue("version");
        throw new ParseCompleteException("");
    }

    private class ParseCompleteException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public ParseCompleteException(String arg0) {
            super(arg0);
        }
    }
}

