/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.tesla.core.am.RecordingModeFeature;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.protocol.Click;
import org.eclipse.rcptt.tesla.core.protocol.CompositeUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.MouseEvent;
import org.eclipse.rcptt.tesla.core.protocol.MouseEventKind;
import org.eclipse.rcptt.tesla.core.protocol.PartUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SWTDialogKind;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectData;
import org.eclipse.rcptt.tesla.core.protocol.SetSWTDialogInfo;
import org.eclipse.rcptt.tesla.core.protocol.SetSelection;
import org.eclipse.rcptt.tesla.core.protocol.SetTextOffset;
import org.eclipse.rcptt.tesla.core.protocol.SetTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.TextUIElement;
import org.eclipse.rcptt.tesla.core.protocol.Type;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.ViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawEvent;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.core.utils.TeslaUtils;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTModelMapperExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.Viewers;
import org.eclipse.rcptt.tesla.recording.aspects.IAbstractSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.IExtendedSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.SWTEventManager;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingModeListener;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessorExtension;
import org.eclipse.rcptt.tesla.recording.core.ITeslaRecordingListener;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.CComboSupport;
import org.eclipse.rcptt.tesla.recording.core.swt.DNDSupport;
import org.eclipse.rcptt.tesla.recording.core.swt.EclipseFormsSupport;
import org.eclipse.rcptt.tesla.recording.core.swt.JFaceRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTAssertManager;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTWidgetLocator;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.CommandPostProcessor;
import org.eclipse.rcptt.tesla.recording.core.swt.util.LastEvents;
import org.eclipse.rcptt.tesla.recording.core.swt.util.RecordedEvent;
import org.eclipse.rcptt.tesla.swt.workbench.EclipseWorkbenchProvider;
import org.eclipse.rcptt.util.swt.StringLines;
import org.eclipse.rcptt.util.swt.TableTreeUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.framework.Bundle;

public class SWTEventRecorder
implements IRecordingProcessor,
IExtendedSWTEventListener,
IRecordingModeListener {
    private LastEvents lastEvents = new LastEvents();
    private boolean enabled = true;
    private final IPartListener listener;
    private final IPageListener pageListener;
    private final IWindowListener windowListener;
    private String beforeTextState = null;
    private DNDSupport dragSupport;
    private final Map<Widget, String> lastTabItemSelection = new HashMap<Widget, String>();
    private final Set<String> pressed = new HashSet<String>();
    private boolean inStyledTextAction = false;
    private Event currentEvent;
    private Event lastEvent = null;
    public static boolean keysSeen = false;
    public static Event lastTraverseEvent = null;
    public static int lastTraverseDetail = 0;
    private boolean mouseDownRecorded = false;
    private boolean recordClickInSeletion = false;
    private static final Map<Integer, MouseEventKind> mouseToEventKind = new HashMap<Integer, MouseEventKind>();
    private static final Map<Integer, Integer> defaultCounts;

    static {
        mouseToEventKind.put(8, MouseEventKind.DOUBLE_CLICK);
        mouseToEventKind.put(3, MouseEventKind.DOWN);
        mouseToEventKind.put(6, MouseEventKind.ENTER);
        mouseToEventKind.put(7, MouseEventKind.EXIT);
        mouseToEventKind.put(5, MouseEventKind.MOVE);
        mouseToEventKind.put(4, MouseEventKind.UP);
        mouseToEventKind.put(32, MouseEventKind.HOVER);
        defaultCounts = new HashMap<Integer, Integer>();
        defaultCounts.put(8, 2);
        defaultCounts.put(3, 1);
        defaultCounts.put(6, 0);
        defaultCounts.put(7, 0);
        defaultCounts.put(5, 0);
        defaultCounts.put(4, 1);
        defaultCounts.put(32, 0);
    }

    public SWTWidgetLocator getLocator() {
        return SWTRecordingHelper.getHelper().getLocator();
    }

    public static boolean isModal(Shell shell) {
        int style = shell.getStyle();
        int mask = 229376;
        String text = shell.getText();
        if (text != null && (text.trim().equalsIgnoreCase("problem occurred") || text.trim().equalsIgnoreCase("Operation failed"))) {
            return true;
        }
        return (style & mask) > 0;
    }

    public TeslaRecorder getRecorder() {
        return TeslaRecorder.getInstance();
    }

    public SWTEventRecorder() {
        IWorkbenchWindow[] windows;
        this.dragSupport = new DNDSupport();
        this.listener = new PartListener();
        this.pageListener = new IPageListener(){

            public void pageOpened(IWorkbenchPage page) {
                page.addPartListener(SWTEventRecorder.this.listener);
            }

            public void pageClosed(IWorkbenchPage page) {
            }

            public void pageActivated(IWorkbenchPage page) {
                page.addPartListener(SWTEventRecorder.this.listener);
            }
        };
        this.windowListener = new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                IWorkbenchPage[] pages;
                window.addPageListener(SWTEventRecorder.this.pageListener);
                IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage page = iWorkbenchPageArray[n2];
                    page.addPartListener(SWTEventRecorder.this.listener);
                    ++n2;
                }
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowActivated(IWorkbenchWindow window) {
                window.addPageListener(SWTEventRecorder.this.pageListener);
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener(this.windowListener);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow win = iWorkbenchWindowArray[n2];
            win.addPageListener(this.pageListener);
            IWorkbenchPage[] iWorkbenchPageArray = pages = win.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                page.addPartListener(this.listener);
                ++n4;
            }
            ++n2;
        }
        SWTEventManager.addListener((IAbstractSWTEventListener)this);
    }

    private void enable() {
        this.enabled = true;
    }

    public boolean doProcessing(ContextManagement.Context context, boolean contextChanged) {
        return false;
    }

    public synchronized void recordEvent(Widget widget, int type, Event event) {
        Text text;
        if (this.getRecorder() == null) {
            return;
        }
        if (!this.getRecorder().hasListeners()) {
            return;
        }
        if (!this.enabled) {
            this.enable();
        }
        if (type == 1 || type == 2) {
            keysSeen = true;
            if (type == 2 && lastTraverseEvent != null) {
                RecordedEvent toRecordingTraverse = new RecordedEvent(this.getPlayer(), event, type, widget);
                SWTEventRecorder.lastTraverseEvent.detail = lastTraverseDetail;
                if (!(widget instanceof Browser)) {
                    this.addToPressed(lastTraverseEvent);
                    this.processTraverse(SWTEventRecorder.lastTraverseEvent.widget, lastTraverseEvent, toRecordingTraverse);
                    this.lastEvents.add(toRecordingTraverse);
                }
                lastTraverseEvent = null;
            }
        }
        if (type == 24 && widget instanceof Text && Platform.getOS().equals("win32") && ((text = (Text)widget).getStyle() & 2) != 0 && ContextManagement.currentContext().contains("org.eclipse.swt.widgets.Text", "setText")) {
            return;
        }
        List list = this.getRecorder().getProcessors(IRecordingProcessorExtension.class);
        for (IRecordingProcessorExtension ext : list) {
            if (!ext.isIgnored((Object)widget, type, (Object)event)) continue;
            return;
        }
        if (this.isIgnored(widget)) {
            return;
        }
        if (Platform.getOS().equals("macosx") && event != null && this.lastEvent != null && event.time == this.lastEvent.time && event.widget == this.lastEvent.widget && event.type == this.lastEvent.type) {
            return;
        }
        if (widget instanceof Menu && type == 22) {
            if (this.lastEvent != null && this.lastEvent.widget instanceof Button && this.lastEvent.type == 3) {
                FindResult result;
                SWTEventManager.setMenuSource((Menu)((Menu)widget), (Object)this.lastEvent.widget);
                if (!Platform.getOS().equals("macosx") && (result = this.getLocator().findElement(this.lastEvent.widget, false, false, true)) != null) {
                    ControlUIElement e = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
                    e.clickAndWait();
                }
            } else if (this.lastEvent != null && this.lastEvent.widget instanceof Button && this.lastEvent.type == 13) {
                SWTEventManager.setMenuSource((Menu)((Menu)widget), (Object)this.lastEvent.widget);
            }
        }
        if (event != null) {
            this.lastEvent = event;
        }
        this.recordRawEvent(widget, type, event);
        this.recordEvent_(widget, type, event);
    }

    private void recordRawEvent(Widget widget, int type, Event event) {
        if (!this.getRecorder().isRawEventsEnabled()) {
            return;
        }
        RawEvent rawEvent = RawFactory.eINSTANCE.createRawEvent();
        rawEvent.setType(type);
        if (event != null) {
            rawEvent.setButton(event.button);
            rawEvent.setCharacter(event.character);
            rawEvent.setCount(event.count);
            rawEvent.setData(event.data == null ? null : event.data.toString());
            rawEvent.setDetail(event.detail);
            rawEvent.setEnd(event.end);
            rawEvent.setHeight(event.height);
            rawEvent.setIndex(event.index);
            rawEvent.setKeyCode(event.keyCode);
            rawEvent.setStart(event.start);
            rawEvent.setStateMask(event.stateMask);
            if (event.text != null) {
                String textValue = event.text;
                StringBuilder textResult = new StringBuilder();
                char[] cArray = textValue.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (!Character.isLetterOrDigit(c) && !Character.isWhitespace(c)) {
                        textResult.append(' ');
                    } else {
                        textResult.append(c);
                    }
                    ++n2;
                }
                rawEvent.setText(textResult.toString());
            }
            rawEvent.setTime(event.time);
            rawEvent.setWidth(event.width);
            rawEvent.setX(event.x);
            rawEvent.setY(event.y);
            rawEvent.getItem().add((Object)this.getLocator().getWidgetID(event.item));
            rawEvent.setNativeEvent(!this.isNotNative(widget));
        }
        rawEvent.getWidget().add((Object)this.getLocator().getWidgetID(widget));
        this.getRecorder().addRawEvent(rawEvent);
    }

    public boolean isIgnored(Widget widget) {
        Shell[] ignored = this.getPlayer().getIgnored();
        if (ignored == null) {
            return false;
        }
        Shell s = null;
        if (widget instanceof Control) {
            s = ((Control)widget).getShell();
        }
        if (widget instanceof MenuItem) {
            s = ((MenuItem)widget).getParent().getShell();
        }
        if (widget instanceof Menu) {
            s = ((Menu)widget).getShell();
        }
        if (widget instanceof ToolItem) {
            s = ((ToolItem)widget).getParent().getShell();
        }
        if (s != null) {
            Shell[] shellArray = ignored;
            int n = ignored.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (shell == s) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public SWTUIPlayer getPlayer() {
        return this.getLocator().getPlayer();
    }

    private void recordEvent_(Widget widget, int type, Event event) {
        CCombo[] combo;
        if (type == 2008 || type == 2000 || type == 2002 || type == 2004 || type == 2003 || type == 2006 || type == 2005 || type == 2007 || type == 2001) {
            if (event.widget == null) {
                event.widget = widget;
            }
            event.type = type;
            this.recordDragEvent(event);
            return;
        }
        RecordedEvent toRecording = new RecordedEvent(this.getPlayer(), event, type, widget);
        if (type == 22 && widget instanceof Menu) {
            this.processMenuShow(widget, toRecording);
        } else if (type == 23 && widget instanceof Menu) {
            this.lastEvents.add(toRecording);
        }
        ContextManagement.Context ctx = ContextManagement.currentContext();
        if (this.isNotNative(widget)) {
            return;
        }
        if (widget instanceof Control) {
            Control c = (Control)widget;
            if (c.getParent() instanceof DateTime) {
                this.processDateTime((Control)c.getParent(), c, type, event);
                return;
            }
            if (c instanceof DateTime) {
                this.processDateTime(c, c, type, event);
                return;
            }
        }
        CCombo[] cComboArray = combo = SWTEventManager.getCombo();
        int n = combo.length;
        int n2 = 0;
        while (n2 < n) {
            CCombo cCombo = cComboArray[n2];
            if (CComboSupport.isComboWidget(cCombo, widget)) {
                this.processCCombo(widget, cCombo, type, event);
                return;
            }
            ++n2;
        }
        if (widget instanceof CCombo) {
            return;
        }
        if (this.isCanvas(widget, type)) {
            return;
        }
        if (type == 13 || type == 14) {
            this.processSelection(widget, event, type, ctx);
        } else if (type == 24 && SWTEventRecorder.isSimpleTextControl(widget)) {
            if (ctx.contains("org.eclipse.swt.widgets.Combo", "removeAll") || ctx.contains("org.eclipse.swt.widgets.Combo", "setItems") || ctx.contains("org.eclipse.swt.widgets.Combo", "deselectAll") || ctx.contains("org.eclipse.swt.widgets.Combo", "select") || ctx.contains("org.eclipse.swt.widgets.Combo", "setText") || ctx.contains("org.eclipse.jface.internal.databinding.swt.TextTextProperty", "doSetStringValue") || ctx.contains("org.eclipse.swt.widgets.Text", "paste")) {
                return;
            }
            this.processModify(widget);
        } else if (type == 26) {
            this.lastEvents.add(toRecording);
        } else if (type == 27) {
            this.lastEvents.add(toRecording);
        } else if (type == 4) {
            this.processMouseUp(widget, event, toRecording);
        } else if (type == 3) {
            this.processMouseDown(widget, event, toRecording);
        } else if (type == 1) {
            if (ctx.contains("com.xored.swt.internal.composer.GeckoEditor$KeyAdapter", "handleEvent")) {
                return;
            }
            if (widget instanceof Combo) {
                return;
            }
            this.addToPressed(event);
            this.processKeyDown(widget, event);
            this.lastEvents.add(toRecording);
        } else if (type == 2) {
            boolean isEnterOnMac;
            if (ctx.contains("com.xored.swt.internal.composer.GeckoEditor$KeyAdapter", "handleEvent")) {
                return;
            }
            if (widget instanceof Combo) {
                return;
            }
            String v = KeyStroke.getInstance((int)event.stateMask, (int)event.keyCode).toString().toLowerCase();
            String[] values = v.split("\\+");
            boolean contains = false;
            String[] stringArray = values;
            int n3 = values.length;
            int n4 = 0;
            while (n4 < n3) {
                String val = stringArray[n4];
                if (this.pressed.contains(val)) {
                    contains = true;
                }
                ++n4;
            }
            boolean bl = isEnterOnMac = Platform.getOS().equals("macosx") && event.character == '\r' && event.stateMask == 0;
            if (!contains && !isEnterOnMac) {
                this.processKeyDown(widget, event);
            }
            String[] stringArray2 = values;
            int n5 = values.length;
            n3 = 0;
            while (n3 < n5) {
                String val = stringArray2[n3];
                this.pressed.remove(val);
                ++n3;
            }
            if (SWTEventRecorder.isSimpleTextControl(widget)) {
                this.beforeTextState = null;
            }
            this.lastEvents.add(toRecording);
        } else if (type == 31) {
            keysSeen = false;
            if (event.detail != 512 && event.detail != 256) {
                if (!(widget instanceof Browser)) {
                    this.addToPressed(event);
                    this.processTraverse(widget, event, toRecording);
                    this.lastEvents.add(toRecording);
                }
            } else if (event.detail != 0) {
                event.widget = widget;
                lastTraverseEvent = event;
                lastTraverseDetail = event.detail;
            }
        } else if (type == 8) {
            FindResult result;
            Listener[] listeners = widget.getListeners(8);
            if (listeners.length != 0 && !(widget instanceof ViewForm) && !(widget instanceof Sash) && (result = this.getLocator().findElement(widget, true, false, false)) != null && result.element != null) {
                if (result.realElement.isTree() || result.realElement.isTable() || result.realElement.isList()) {
                    String[] sel = result.realElement.getPathSelection();
                    ViewerUIElement v = new ViewerUIElement(result.element, (UIPlayer)this.getRecorder());
                    Command last = this.getRecorder().getContainer().getLast();
                    if (!(sel == null || last instanceof Click && ((Click)last).isDefault())) {
                        v.setSelection(sel);
                    }
                    v.doubleClick();
                } else if (!this.isCanvas(widget, type) && !widget.getClass().getName().equals("org.eclipse.draw2d.FigureCanvas")) {
                    ControlUIElement e = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
                    e.doubleClickAndWait();
                }
            }
            this.lastEvents.add(toRecording);
        } else if (type == 21) {
            this.processClose(widget);
        } else if (type == 15) {
            this.processFocusIn(widget);
        } else {
            this.lastEvents.add(toRecording);
        }
    }

    private static boolean hasListeners(Widget widget, int event) {
        return SWTEventRecorder.hasNonPlatformListeners(widget.getListeners(event), event);
    }

    private void processFocusIn(Widget widget) {
        if (!(widget instanceof Text) || !SWTEventRecorder.hasListeners(widget, 15)) {
            return;
        }
        ContextManagement.Context ctx = ContextManagement.currentContext();
        if (ctx.contains(WizardDialog.class.getName(), "stopped")) {
            return;
        }
        if (Platform.getOS().equals("macosx") && ctx.contains(Display.class.getName(), "checkFocus")) {
            return;
        }
        FindResult element = this.getLocator().findElement(widget, true, false, true);
        if (element == null || element.element == null) {
            return;
        }
        new ControlUIElement(element.element, (UIPlayer)this.getRecorder()).setFocus();
    }

    private void processFocusOut(Widget widget) {
        if (widget.isDisposed()) {
            return;
        }
        if (!SWTEventRecorder.hasListeners(widget, 16)) {
            return;
        }
        ContextManagement.Context ctx = ContextManagement.currentContext();
        if (ctx.contains(WizardDialog.class.getName(), "stopped")) {
            return;
        }
        if (Platform.getOS().equals("macosx") && ctx.contains(Display.class.getName(), "checkFocus")) {
            return;
        }
        FindResult element = this.getLocator().findElement(widget, true, false, true);
        if (element == null || element.element == null) {
            return;
        }
        new ControlUIElement(element.element, (UIPlayer)this.getRecorder()).unfocus();
    }

    public void addToPressed(Event event) {
        String[] values;
        KeyStroke strk = KeyStroke.getInstance((int)event.stateMask, (int)event.keyCode);
        String split = strk.toString().toLowerCase();
        String[] stringArray = values = split.split("\\+");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (!this.pressed.contains(val)) {
                this.pressed.add(val);
            }
            ++n2;
        }
    }

    private void processDateTime(Control dateTime, Control c, int type, Event event) {
        DateTime dt = (DateTime)dateTime;
        switch (type) {
            case 13: {
                FindResult element = this.getLocator().findElement((Widget)dateTime, false, false, true);
                if (element == null || element.element == null) break;
                TextUIElement e = new TextUIElement(element.element, (UIPlayer)this.getRecorder());
                e.setText(PlayerTextUtils.getDateTimeValue((DateTime)dt));
                break;
            }
            case 8: {
                FindResult element = this.getLocator().findElement((Widget)dateTime, false, false, true);
                if (element == null || element.element == null) break;
                ControlUIElement e = new ControlUIElement(element.element, (UIPlayer)this.getRecorder());
                e.doubleClickAndWait();
                break;
            }
            case 1: {
                this.processKeyDown((Widget)dt, event);
            }
        }
    }

    public boolean isCanvas(Widget widget, int type) {
        List list = this.getRecorder().getProcessors(IRecordingProcessorExtension.class);
        for (IRecordingProcessorExtension ext : list) {
            if (!(widget instanceof Canvas) || !ext.isNotCanvas((Object)widget, type, null)) continue;
            return false;
        }
        if (!(!(widget instanceof Canvas) || widget instanceof Shell || widget instanceof StyledText || widget instanceof Browser || widget instanceof CLabel || type != 3 && type != 4 && type != 5 && type != 8 && type != 6 && type != 7 && type != 32 && type != 37)) {
            String clName = widget.getClass().getName();
            Composite parent = ((Control)widget).getParent();
            boolean val = true;
            try {
                val = EclipseFormsSupport.isNotCanvas(widget, parent);
            }
            catch (Throwable e) {
                TeslaCore.log((Throwable)e);
            }
            if (!clName.equals("org.eclipse.draw2d.FigureCanvas") && val) {
                return true;
            }
        }
        return false;
    }

    public boolean isNotNative(Widget widget) {
        ContextManagement.Context ctx = ContextManagement.currentContext();
        if (ctx.contains("org.eclipse.swt.widgets.Composite", "setFocus")) {
            return true;
        }
        if (ctx.contains("org.eclipse.swt.widgets.Shell", "close")) {
            return true;
        }
        if (ctx.contains("org.eclipse.swt.widgets.TreeItem", "setExpanded")) {
            return true;
        }
        if (ctx.contains("org.eclipse.ui.views.properties.PropertySheetViewer", "removeItem")) {
            return true;
        }
        if (ctx.contains("org.eclipse.swt.widgets.TabFolder", "createItem") || ctx.contains("org.eclipse.swt.widgets.TabFolder", "destroyItem")) {
            return true;
        }
        if (ctx.containsClass("org.eclipse.swt.custom.CCombo") && !(widget instanceof CCombo)) {
            return true;
        }
        if (!this.getRecorder().isNotNativeEventsIgnored()) {
            return false;
        }
        return !ctx.contains("org.eclipse.swt.widgets.Display", "windowProc") && !ctx.contains("org.eclipse.swt.widgets.Display", "runDeferredEvents") && !ctx.contains("org.eclipse.swt.widgets.Control", "traverse");
    }

    private void processCCombo(Widget widget, CCombo cCombo, int type, Event event) {
        switch (type) {
            case 13: {
                FindResult result;
                if (!(widget instanceof org.eclipse.swt.widgets.List) || (result = this.getLocator().findElement((Widget)cCombo, true, false, false)) == null) break;
                org.eclipse.swt.widgets.List l = (org.eclipse.swt.widgets.List)widget;
                TextUIElement e = new TextUIElement(result.element, (UIPlayer)this.getRecorder());
                String[] selection = l.getSelection();
                if (selection.length != 1) break;
                String value = selection[0];
                SWTEventRecorder.processComboSelection(e, cCombo.getItems(), value);
                break;
            }
            case 24: {
                FindResult result = this.getLocator().findElement((Widget)cCombo, true, false, false);
                if (result == null) break;
                TextUIElement e = new TextUIElement(result.element, (UIPlayer)this.getRecorder());
                String text = cCombo.getText();
                if (Arrays.asList(cCombo.getItems()).contains(text)) {
                    e.select(text);
                    break;
                }
                e.setText(text);
            }
        }
    }

    private boolean isDebug() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.rcptt.tesla.recording.ui.dev");
        return bundle != null;
    }

    public static boolean isIgnoreSelection(Widget widget, Event event, int type, ContextManagement.Context ctx) {
        SWTUIElement swtuiElement = SWTRecordingHelper.getHelper().getLocator().getPlayer().wrap((Object)widget);
        if (swtuiElement != null && swtuiElement.getKind().is(ElementKind.Unknown)) {
            return true;
        }
        if (widget instanceof Canvas && !(widget instanceof StyledText) && Arrays.asList(13, 14).contains(type)) {
            return true;
        }
        if (widget instanceof Combo && Arrays.asList(13, 14).contains(type)) {
            return true;
        }
        if (Platform.getOS().equals("macosx")) {
            if (widget instanceof Sash) {
                return true;
            }
            if (widget instanceof Button && (((Button)widget).getStyle() & 0x10) != 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void processSelection(Widget widget, Event event, int type, ContextManagement.Context ctx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processColumnHeaderSelection(Widget widget) {
        FindResult result = this.getLocator().findElement(widget, false, false, false);
        new ControlUIElement(result.element, (UIPlayer)this.getRecorder()).click();
    }

    private boolean isIgnoredAction(IAction action) {
        if (action.getId() != null && action.getId().equals("preferences") ? action.getActionDefinitionId() != null && action.getActionDefinitionId().equals("org.eclipse.ui.window.preferences") && !action.getClass().getName().equals("org.eclipse.ui.internal.OpenPreferencesAction") : action.getId() != null && action.getId().equals("about") && action.getActionDefinitionId() != null && action.getActionDefinitionId().equals("org.eclipse.ui.help.aboutAction")) {
            return true;
        }
        return action.getClass().getName().equals("org.eclipse.ui.internal.OpenPreferencesAction");
    }

    private void processTextWidgetSelectionEvent(Widget widget) {
        if (!this.inStyledTextAction) {
            TeslaSWTAccess.getThis((Object)widget);
            FindResult result = this.getLocator().findElement(widget, true, false, false);
            if (result != null) {
                TextUIElement textCtrl = new TextUIElement(result.element, (UIPlayer)this.getRecorder());
                if (widget instanceof StyledText) {
                    StyledText styledText = (StyledText)widget;
                    Point selection = styledText.getSelectionRange();
                    if (selection.y != 0) {
                        SetTextOffset offset;
                        Command last = this.getRecorder().getContainer().getLast();
                        if (last instanceof SetTextOffset && EcoreUtil.equals((EObject)(offset = (SetTextOffset)last).getElement(), (EObject)result.element)) {
                            this.getRecorder().removeLast();
                        }
                        int startLine = styledText.getLineAtOffset(selection.x);
                        int startOffset = selection.x - styledText.getOffsetAtLine(startLine);
                        int endLine = styledText.getLineAtOffset(selection.x + selection.y);
                        int endOffset = selection.x + selection.y - styledText.getOffsetAtLine(endLine);
                        int caretOffset = styledText.getCaretOffset();
                        if (caretOffset == selection.x) {
                            textCtrl.setSelection(endLine, endOffset, startLine, startOffset);
                        } else {
                            textCtrl.setSelection(startLine, startOffset, endLine, endOffset);
                        }
                    }
                }
            }
        }
    }

    private boolean processTabFolder(Widget widget, boolean tabFolder) {
        String v;
        if (!(widget instanceof TabFolder)) {
            return tabFolder;
        }
        FindResult result = this.getLocator().findElement(widget, true, false, false);
        if (result == null) {
            return tabFolder;
        }
        TabFolder tabFolderWidget = (TabFolder)widget;
        TabItem selectedItem = null;
        int selectionIndex = tabFolderWidget.getSelectionIndex();
        if (selectionIndex != -1) {
            selectedItem = tabFolderWidget.getItem(selectionIndex);
        }
        TabItem[] tabItemArray = tabFolderWidget.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control content;
            TabItem item = tabItemArray[n2];
            if (!item.isDisposed() && (content = item.getControl()) != null && !content.isDisposed() && content.isVisible()) {
                selectedItem = item;
                break;
            }
            ++n2;
        }
        if (selectedItem == null) {
            return tabFolder;
        }
        String tabName = PlayerTextUtils.removeAcceleratorFromText((String)selectedItem.getText());
        if (this.lastTabItemSelection.containsKey(widget) && (v = this.lastTabItemSelection.get(widget)).equals(tabName)) {
            return tabFolder;
        }
        CompositeUIElement v2 = new CompositeUIElement(result.element, (UIPlayer)this.getRecorder());
        CompositeUIElement tabItem = v2.tabItem(tabName);
        tabItem.clickAndWait();
        return false;
    }

    private void processCoolItem(Widget widget) {
        FindResult result = this.getLocator().findElement(widget, false, false, false);
        if (result != null) {
            ControlUIElement ctrl = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
            ctrl.clickAndWait();
        }
    }

    private void processToolItem(Widget widget, Event event) {
        ToolItem item = (ToolItem)widget;
        if ((item.getStyle() & 0x10) != 0 && !item.getSelection()) {
            return;
        }
        boolean arrow = event != null && event.detail == 4;
        FindResult result = this.getLocator().findElement(widget, false, false, false);
        if (result != null && result.element != null) {
            ControlUIElement ctrl = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
            if (arrow) {
                ctrl.clickArrowAndWait();
            } else {
                ctrl.clickAndWait();
            }
        }
    }

    private void processViewers(Event event, int type, FindResult result) {
        if (result.realElement.isSupportMultipleSelections()) {
            ViewerUIElement v = new ViewerUIElement(result.element, (UIPlayer)this.getRecorder());
            if (event.detail == 32 && event.item != null) {
                String[] sel = null;
                if (event.item instanceof TableItem) {
                    TableItem tItem = (TableItem)event.item;
                    sel = Viewers.getPathByTableItem((TableItem)tItem);
                } else if (event.item instanceof TreeItem) {
                    TreeItem trItem = (TreeItem)event.item;
                    sel = Viewers.getPathByTreeItem((TreeItem)trItem);
                }
                boolean checked = true;
                if (event.item instanceof TreeItem) {
                    checked = ((TreeItem)event.item).getChecked();
                } else if (event.item instanceof TableItem) {
                    checked = ((TableItem)event.item).getChecked();
                }
                v.checkItem(checked, sel);
            } else {
                String[][] selection = result.realElement.getMultiPathSelection();
                if (selection != null && selection.length > 0 && !this.lastEvents.checkType(result.realElement.widget, 8)) {
                    if (type == 14) {
                        v.click(true);
                    } else if (this.recordClickInSeletion) {
                        this.recordClickInSeletion = false;
                        String[] path = Viewers.getPathByItem((Object)event.item);
                        v.item(path).click();
                    } else {
                        v.setMultiSelection(selection);
                    }
                }
            }
        } else {
            String[] sel = null;
            if (sel == null) {
                sel = result.realElement.getPathSelection();
            }
            if (event != null && event.item != null && event.detail == 32) {
                if (event.item instanceof TableItem) {
                    TableItem tItem = (TableItem)event.item;
                    sel = Viewers.getPathByTableItem((TableItem)tItem);
                } else if (event.item instanceof TreeItem) {
                    TreeItem trItem = (TreeItem)event.item;
                    sel = Viewers.getPathByTreeItem((TreeItem)trItem);
                }
            }
            if (sel != null && sel.length > 0) {
                ViewerUIElement v = new ViewerUIElement(result.element, (UIPlayer)this.getRecorder());
                if (event != null && event.detail == 32) {
                    boolean checked = true;
                    if (event.item instanceof TreeItem) {
                        checked = ((TreeItem)event.item).getChecked();
                    } else if (event.item instanceof TableItem) {
                        checked = ((TableItem)event.item).getChecked();
                    }
                    v.checkItem(checked, sel);
                } else if (!this.lastEvents.checkType(result.realElement.widget, 8)) {
                    if (type == 14) {
                        v.click(true);
                    } else if (this.recordClickInSeletion) {
                        this.recordClickInSeletion = false;
                        String[] path = Viewers.getPathByItem((Object)event.item);
                        v.item(path).click();
                    } else {
                        v.setSelection(sel);
                    }
                }
            }
        }
    }

    private static void processComboSelection(TextUIElement e, String[] items, String text) {
        if (Arrays.asList(items).contains(text)) {
            e.select(text);
        } else {
            e.setText(text);
        }
    }

    private void processModify(Widget widget) {
        SWTUIElement wrap = this.getPlayer().wrap((Object)widget);
        if (wrap.isDisabled()) {
            return;
        }
        if (this.lastEvents.checkType(widget, 1, 2, 3) && !(widget instanceof Combo)) {
            FindResult element = this.getLocator().findElement(widget, true, false, false);
            if (element != null) {
                RecordedEvent e2;
                TextUIElement e = new TextUIElement(element.element, (UIPlayer)this.getRecorder());
                String currentText = element.realElement.getModificationText();
                if (currentText.trim().length() == 0 && (e2 = this.lastEvents.getEvent(widget, 1)) != null && !Character.isISOControl(e2.event.character)) {
                    currentText = new String(new char[]{e2.event.character});
                }
                if (!(this.beforeTextState != null && this.beforeTextState.equals(currentText) || widget == JFaceRecordingProcessor.lastCellEditorControl)) {
                    if (!(widget instanceof Combo)) {
                        e.setText(currentText, false, (widget.getStyle() & 0x400000) != 0);
                    } else {
                        SWTEventRecorder.processComboSelection(e, ((Combo)widget).getItems(), currentText);
                    }
                }
            }
            this.beforeTextState = null;
            this.lastEvents.clear();
            this.pressed.clear();
        } else if (widget instanceof Combo) {
            Control ctrl = (Control)widget;
            if (!ctrl.getShell().isVisible()) {
                return;
            }
            FindResult element = this.getLocator().findElement(widget, true, false, false);
            if (element != null && element.element != null) {
                TextUIElement e = new TextUIElement(element.element, (UIPlayer)this.getRecorder());
                SWTEventRecorder.processComboSelection(e, ((Combo)widget).getItems(), element.realElement.getModificationText());
                this.lastEvents.clear();
            }
        }
    }

    private void processMenuShow(Widget widget, RecordedEvent toRecording) {
        Decorations parent;
        Widget menuSource = null;
        if (this.lastEvent != null && this.lastEvent.type == 35 && (this.lastEvent.widget instanceof Tree || this.lastEvent.widget instanceof Table)) {
            Point point = this.lastEvent.widget.getDisplay().map(null, (Control)this.lastEvent.widget, this.lastEvent.x, this.lastEvent.y);
            menuSource = TableTreeUtil.getColumnFromPoint((Widget)this.lastEvent.widget, (Point)point);
        }
        if (menuSource == null) {
            for (RecordedEvent e : this.lastEvents.fromMostRecent()) {
                Menu widMenu;
                Widget wid = e.widget;
                if (!(wid instanceof Control) || wid.isDisposed() || (widMenu = ((Control)wid).getMenu()) == null || !widMenu.equals(widget)) continue;
                menuSource = wid;
                break;
            }
        }
        if (menuSource == null && widget instanceof Menu && (menuSource = this.findMenuSource((Composite)(parent = ((Menu)widget).getParent()), widget)) == null) {
            menuSource = SWTWidgetLocator.findViewMenuSource(widget);
        }
        if (menuSource != null) {
            SWTEventManager.setMenuSource((Menu)((Menu)widget), menuSource);
        }
        this.getLocator().cleanMenuSources();
        this.lastEvents.add(toRecording);
        this.getLocator().findElement(widget, false, false, false);
    }

    private Widget findMenuSource(Composite parent, Widget widget) {
        Control[] children;
        Menu menu = parent.getMenu();
        if (menu != null && menu.equals(widget)) {
            return parent;
        }
        Control[] controlArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Widget result;
            Control control = controlArray[n2];
            menu = control.getMenu();
            if (menu != null && menu.equals(widget)) {
                return control;
            }
            if (control instanceof Composite && (result = this.findMenuSource((Composite)control, widget)) != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public void processKeyDown(Widget widget, Event event) {
        boolean shift = (event.stateMask & 0x20000) != 0;
        boolean ctrlb = (event.stateMask & 0x40000) != 0;
        boolean alt = (event.stateMask & 0x10000) != 0;
        boolean check1 = (event.stateMask & SWT.MODIFIER_MASK) != 0 && (!shift || ctrlb || alt);
        boolean enter = event.character == '\r' && event.stateMask == 0;
        boolean helpKey = event.keyCode == 0x100000A;
        boolean arrayKey = event.keyCode == 0x1000001 || event.keyCode == 0x1000002 || event.keyCode == 0x1000003 || event.keyCode == 0x1000004;
        FindResult result = this.getLocator().findElement(widget, true, false, false);
        if (result != null) {
            if (SWTEventRecorder.isSimpleTextControl(widget)) {
                this.beforeTextState = result.realElement.getModificationText();
                if (enter || helpKey || arrayKey) {
                    ControlUIElement ctrl = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
                    ctrl.press(event.keyCode, event.stateMask, widget instanceof Browser || helpKey, event.character, SWTEventRecorder.getMeta(event.stateMask));
                    return;
                }
            }
            if (!SWTEventRecorder.isSimpleTextControl(widget) || check1) {
                ControlUIElement ctrl = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
                if (event.keyCode != 131072 && event.keyCode != 262144 && event.keyCode != 65536 && event.keyCode != 0x400000) {
                    if ((event.keyCode & 0x1000000) == 0 && event.stateMask == 0 && !Character.isISOControl(event.character)) {
                        if (widget instanceof StyledText || widget instanceof Browser || widget.getListeners(1).length > 0 || widget.getListeners(2).length > 0) {
                            ctrl.type(new String(new char[]{event.character}), widget instanceof Browser);
                        }
                    } else if (widget instanceof StyledText || widget instanceof Browser) {
                        if (event.stateMask == 131072 && !Character.isISOControl(event.character)) {
                            ctrl.type(new String(new char[]{event.character}), widget instanceof Browser);
                        } else {
                            ctrl.press(event.keyCode, event.stateMask, widget instanceof Browser, event.character, SWTEventRecorder.getMeta(event.stateMask));
                        }
                    } else {
                        ctrl.press(event.keyCode, event.stateMask, widget instanceof Browser, event.character, SWTEventRecorder.getMeta(event.stateMask));
                    }
                }
            }
            this.lastEvents.clear();
        }
    }

    private static boolean isSimpleTextControl(Widget widget) {
        if (widget instanceof Combo || widget instanceof Spinner) {
            return true;
        }
        return widget instanceof Text;
    }

    public void processTraverse(Widget widget, Event event, RecordedEvent toRecording) {
        FindResult result;
        if (event.detail == 128) {
            String[] assertShortcuts = TeslaRecorder.getInstance().getAssertModeShortcuts();
            String[] recordShortcuts = TeslaRecorder.getInstance().getRecordModeShortcuts();
            String[] startRecordShortcuts = TeslaRecorder.getInstance().getStartRecordShortcuts();
            String[] stopRecordShortcuts = TeslaRecorder.getInstance().getStopRecordShortcuts();
            String[] replayShortcuts = TeslaRecorder.getInstance().getReplayShortcuts();
            SWTAssertManager assertManager = (SWTAssertManager)TeslaRecorder.getInstance().getProcessor(SWTAssertManager.class);
            if (assertManager != null) {
                boolean assertRequest = assertManager.isShortcutRequest(event, assertShortcuts);
                boolean recordingRequest = assertManager.isShortcutRequest(event, recordShortcuts);
                boolean startRecordRequest = assertManager.isShortcutRequest(event, startRecordShortcuts);
                boolean stopRecordRequest = assertManager.isShortcutRequest(event, stopRecordShortcuts);
                boolean replayRequest = assertManager.isShortcutRequest(event, replayShortcuts);
                if (assertRequest || recordingRequest || startRecordRequest || stopRecordRequest || replayRequest) {
                    assertManager.setFreeze(assertRequest, null);
                    Type type = ProtocolFactory.eINSTANCE.createType();
                    type.setState(Integer.valueOf(event.stateMask));
                    type.setCharacter(event.character);
                    type.setCode(Integer.valueOf(event.keyCode));
                    this.getRecorder().safeExecuteCommand((Command)type);
                    event.detail = 0;
                    event.doit = false;
                    return;
                }
            }
        }
        boolean radioWidgetIgnored = widget instanceof Button && (((Button)widget).getStyle() & 0x10) != 0 && (event.detail == 64 || event.detail == 32);
        boolean isEscapeChain = false;
        RecordedEvent lastRecorded = this.lastEvents.lastRecorded();
        if (lastRecorded != null) {
            boolean bl = isEscapeChain = event.detail == 2 && lastRecorded.type == 31 && lastRecorded.event.doit && lastRecorded.event.detail == 2;
        }
        if (event.doit && event.detail != 0 && event.detail != 4 && !isEscapeChain && !radioWidgetIgnored && (result = this.getLocator().findElement(widget, true, false, false)) != null) {
            ControlUIElement ctrl = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
            ctrl.traverse(event.detail, event.character);
        }
    }

    public static int getMeta(int stateMask) {
        int meta = 0;
        if (Platform.getOS().equals("macosx")) {
            if ((stateMask & 0x400000) != 0) {
                meta |= 1;
            }
            if ((stateMask & 0x20000) != 0) {
                meta |= 2;
            }
            if ((stateMask & 0x10000) != 0) {
                meta |= 4;
            }
            if ((stateMask & 0x40000) != 0) {
                meta |= 8;
            }
        } else {
            if ((stateMask & 0x40000) != 0) {
                meta |= 1;
            }
            if ((stateMask & 0x20000) != 0) {
                meta |= 2;
            }
            if ((stateMask & 0x10000) != 0) {
                meta |= 4;
            }
        }
        return meta;
    }

    private String checkForActionCommand(int mask, int keyCode) {
        KeyStroke hotKey = KeyStroke.getInstance((int)mask, (int)Character.toUpperCase(keyCode));
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        Binding binding = bindingService.getPerfectMatch((TriggerSequence)KeySequence.getInstance((KeyStroke)hotKey));
        if (binding != null && binding.getParameterizedCommand() != null && binding.getParameterizedCommand().getId() != null) {
            return binding.getParameterizedCommand().getId();
        }
        return null;
    }

    private void processMouseUp(Widget widget, Event event, RecordedEvent toRecording) {
        ControlUIElement e;
        FindResult result;
        if (widget instanceof Table || widget instanceof Tree) {
            Listener[] listenersUp;
            Viewer viewer = TeslaSWTAccess.getViewer((Control)((Control)widget));
            if (viewer != null && viewer instanceof ColumnViewer) {
                int index;
                ColumnViewer cview = (ColumnViewer)viewer;
                CellEditor[] editors = cview.getCellEditors();
                ViewerCell cell = cview.getCell(new Point(event.x, event.y));
                if (cell != null && editors != null && editors[index = cell.getColumnIndex()] != null && editors[index] instanceof CheckboxCellEditor) {
                    this.recordCellAccess(widget, event, RecordCellAccessSource.MouseUp);
                    return;
                }
            }
            if ((listenersUp = widget.getListeners(4)) != null && SWTEventRecorder.hasNonPlatformListeners(listenersUp, 4) || this.mouseDownRecorded) {
                this.mouseDownRecorded = false;
                this.recordCellAccess(widget, event, RecordCellAccessSource.MouseUp);
            }
        }
        this.recordTextSetFocus(widget, event.button);
        if (Platform.getOS().equals("macosx") && widget instanceof Button) {
            if ((widget.getStyle() & 0x20) != 0) {
                result = this.getLocator().findElement(widget, false, false, true);
                if (result != null) {
                    e = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
                    e.check(((Button)widget).getSelection());
                }
            } else if ((widget.getStyle() & 0x10) != 0 && (result = this.getLocator().findElement(widget, false, false, true)) != null) {
                e = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
                e.clickAndWait();
            }
        }
        if (widget instanceof Label && this.isSearchControlLabel((Label)widget) && this.lastEvents.checkType(widget, 3) && (result = this.getLocator().findElement(widget, true, false, false)) != null) {
            e = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
            e.clickAndWait();
            this.beforeTextState = "";
        }
        this.lastEvents.add(toRecording);
    }

    private boolean isSearchControlLabel(Label label) {
        if (label.getParent() instanceof Composite && label.getParent().getParent() != null && label.getParent().getParent().getClass().getName().equals("org.eclipse.ui.dialogs.FilteredTree")) {
            return true;
        }
        return label.getParent() instanceof Composite && label.getParent().getParent() != null && label.getParent().getParent().getClass().getName().equals("org.eclipse.rcptt.ui.commons.SearchControl");
    }

    private void recordCellAccess(Widget widget, Event event, RecordCellAccessSource source) {
        if (!(widget instanceof Table) && !(widget instanceof Tree)) {
            return;
        }
        Point pt = new Point(event.x, event.y);
        int row = TableTreeUtil.findRow((Widget)widget, (Point)pt);
        if (row == -1) {
            return;
        }
        boolean hasColumns = TableTreeUtil.getColumnCount((Widget)widget) > 0;
        FindResult result = this.getLocator().findElement(widget, true, false, false);
        ViewerUIElement ve = new ViewerUIElement(result.element, (UIPlayer)this.getRecorder());
        if (source == RecordCellAccessSource.MouseDown) {
            List<String> path;
            this.mouseDownRecorded = true;
            boolean bl = this.recordClickInSeletion = !hasColumns && ((widget.getStyle() & 2) == 0 || (event.stateMask & 0x20000) == 0 && (event.stateMask & 0x40000) == 0);
            if (widget instanceof Tree && hasColumns && (path = Arrays.asList(Viewers.getPathByItem((Object)TableTreeUtil.getItem((Widget)widget, (int)row)))).size() > 1) {
                ve.item(path.subList(0, path.size() - 1).toArray(new String[0])).expand();
            }
        }
        if (hasColumns) {
            Point cell = TableTreeUtil.findCell((Widget)widget, (Point)pt);
            if (cell == null) {
                return;
            }
            row = cell.x;
            int column = cell.y;
            this.recordMouseEvent((ControlUIElement)ve.item(new Integer[]{column, row}), event, source == RecordCellAccessSource.MouseDown ? 3 : 4);
        } else if (source == RecordCellAccessSource.MouseUp && this.recordClickInSeletion) {
            this.recordClickInSeletion = false;
            Object[] selection = TableTreeUtil.getSelection((Widget)widget);
            List<String> path = selection.length == 1 ? Arrays.asList(Viewers.getPathByItem((Object)selection[0])) : Arrays.asList(Viewers.getPathByItem((Object)TableTreeUtil.getItem((Widget)widget, (int)row)));
            ve.item(path.toArray(new String[0])).click();
        }
    }

    private void recordTextSetFocus(Widget widget, int button) {
        if (widget instanceof Text) {
            String start = null;
            String end = null;
            Text t = (Text)widget;
            if (!t.getText().isEmpty()) {
                boolean multi;
                boolean bl = multi = (t.getStyle() & 2) != 0;
                if (multi) {
                    int iSelEnd = t.getCaretPosition();
                    Point selection = t.getSelection();
                    int iSelStart = iSelEnd != selection.y ? selection.y : selection.x;
                    StringLines lines = new StringLines(t.getText());
                    if (iSelStart != iSelEnd) {
                        start = lines.calcLineColumn(iSelStart);
                        end = lines.calcLineColumn(iSelEnd);
                    } else {
                        start = lines.calcLineColumn(iSelEnd);
                    }
                } else {
                    int iSelEnd = t.getCaretPosition();
                    Point point = t.getSelection();
                    if (point != null) {
                        int iSelStart = iSelEnd != point.y ? point.y : point.x;
                        if (iSelStart != iSelEnd) {
                            start = Integer.toString(iSelStart + 1);
                            end = Integer.toString(iSelEnd + 1);
                        } else {
                            start = Integer.toString(iSelEnd + 1);
                        }
                    }
                }
            }
            new ControlUIElement(this.getLocator().findElement((Widget)widget, (boolean)true, (boolean)false, (boolean)false).element, (UIPlayer)this.getRecorder()).clickText(start, end, TeslaUtils.intToButtonName((int)button));
        }
    }

    private void recordMouseEvent(ControlUIElement element, Event event, int type) {
        MouseEvent me = ProtocolFactory.eINSTANCE.createMouseEvent();
        me.setButton(event.button);
        me.setCount(SWTEventRecorder.isDefaultCount(event) ? -1 : event.count);
        me.setElement(element.getElement());
        me.setKind(mouseToEventKind.get(event.type == 0 ? type : event.type));
        me.setStateMask(event.stateMask);
        me.setX(Integer.MIN_VALUE);
        me.setY(Integer.MIN_VALUE);
        this.getRecorder().safeExecuteCommand((Command)me);
    }

    private static boolean isDefaultCount(Event event) {
        if (!defaultCounts.containsKey(event.type)) {
            return false;
        }
        return defaultCounts.get(event.type) == event.count;
    }

    private boolean isDublicateCellClick(int col, int row) {
        boolean itemClickCmdFound = false;
        int i = 1;
        while (i <= this.getRecorder().getContainer().size()) {
            Command cmd = this.getRecorder().getContainer().getLastCommand(i);
            if (cmd instanceof Click && ElementKind.Item.toString().equals(((Click)cmd).getElement().getKind())) {
                itemClickCmdFound = true;
            } else {
                SelectData data;
                if (cmd instanceof SelectCommand && itemClickCmdFound && (data = ((SelectCommand)cmd).getData()).getIndexes() != null && data.getIndexes().size() == 2 && (Integer)data.getIndexes().get(0) == col && (Integer)data.getIndexes().get(1) == row) {
                    return true;
                }
                if (!(cmd instanceof SetSelection) && !(cmd instanceof SelectCommand)) {
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean hasNonPlatformListeners(Listener[] listenersDown, int kind) {
        if (listenersDown == null) {
            return false;
        }
        Listener[] listenerArray = listenersDown;
        int n = listenersDown.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                Listener listener;
                block6: {
                    block7: {
                        listener = listenerArray[n2];
                        if (!(listener instanceof TypedListener)) break block6;
                        SWTEventListener eventListener = ((TypedListener)listener).getEventListener();
                        if (eventListener == null) break block7;
                        String lName = eventListener.getClass().getName();
                        if (kind == 4 && lName.contains("org.eclipse.ui.internal.quickaccess.QuickAccessDialog")) {
                            return true;
                        }
                        if (lName.contains("org.eclipse.swt") || lName.contains("org.eclipse.ui") || lName.contains("org.eclipse.jface")) break block8;
                    }
                    return true;
                }
                String lName = listener.getClass().getName();
                if (!(lName.contains("org.eclipse.swt") || lName.contains("org.eclipse.ui") || lName.contains("org.eclipse.jface"))) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasListeners(Listener[] listenersDown) {
        if (listenersDown == null) {
            return false;
        }
        return listenersDown.length > 0;
    }

    private void processMouseDown(Widget widget, Event event, RecordedEvent toRecording) {
        FindResult result;
        Listener[] listenersDown;
        if (widget instanceof TabFolder || widget instanceof CTabFolder) {
            FindResult result2;
            int n;
            boolean skip = false;
            if (!TeslaCore.isEclipse4()) {
                IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                Control ctrl = (Control)widget;
                Shell shell = ctrl.getShell();
                IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows;
                n = workbenchWindows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n2];
                    Shell wshell = iWorkbenchWindow.getShell();
                    if (wshell == shell) {
                        WorkbenchPage page = (WorkbenchPage)iWorkbenchWindow.getActivePage();
                        Composite composite = page.getClientComposite();
                        Composite p1 = ctrl.getParent();
                        if (p1.equals(composite) || p1.getParent().equals(composite)) {
                            skip = true;
                            break;
                        }
                    }
                    ++n2;
                }
            } else if (widget instanceof CTabFolder) {
                boolean bl = skip = EclipseWorkbenchProvider.getProvider().extractViewOrEditorControl((CTabFolder)widget) != null;
            }
            if (!skip && (result2 = this.getLocator().findElement(widget, true, false, false)) != null && result2.realElement.getKind().is(ElementKind.TabFolder)) {
                Rectangle bounds;
                TabItem[] tabItemArray;
                TabItem[] items;
                String tabName = null;
                boolean closeAction = false;
                if (widget instanceof TabFolder) {
                    tabItemArray = items = ((TabFolder)widget).getItems();
                    int n3 = items.length;
                    n = 0;
                    while (n < n3) {
                        TabItem tabItem = tabItemArray[n];
                        bounds = tabItem.getBounds();
                        if (bounds.contains(event.x, event.y)) {
                            tabName = PlayerTextUtils.removeAcceleratorFromText((String)tabItem.getText());
                            break;
                        }
                        ++n;
                    }
                } else if (widget instanceof CTabFolder) {
                    tabItemArray = items = ((CTabFolder)widget).getItems();
                    int n4 = items.length;
                    n = 0;
                    while (n < n4) {
                        TabItem tabItem = tabItemArray[n];
                        bounds = tabItem.getBounds();
                        if (bounds.contains(event.x, event.y)) {
                            tabName = PlayerTextUtils.removeAcceleratorFromText((String)tabItem.getText());
                            Rectangle rect = TeslaSWTAccess.getCTabItemCloseRect((CTabItem)tabItem);
                            if (rect == null || !rect.contains(event.x, event.y)) break;
                            closeAction = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (tabName != null) {
                    if (!closeAction) {
                        if (widget instanceof CTabFolder) {
                            this.ProcessCTabFolderItemSelection((CTabFolder)widget, result2, tabName);
                        }
                    } else {
                        CompositeUIElement v = new CompositeUIElement(result2.element, (UIPlayer)this.getRecorder());
                        CompositeUIElement tabItem = v.tabItem(tabName);
                        tabItem.close();
                    }
                }
            }
        }
        try {
            EclipseFormsSupport.recordFormsMouseDown(widget, this.getLocator(), this.getRecorder(), this.getPlayer(), event);
        }
        catch (Throwable e) {
            TeslaCore.log((Throwable)e);
        }
        this.recordTextSetFocus(widget, event.button);
        if (widget instanceof org.eclipse.swt.widgets.List && ((Control)widget).isVisible()) {
            this.getLocator().findElement(widget, false, false, false);
        }
        if ((listenersDown = widget.getListeners(3)) != null && SWTEventRecorder.hasNonPlatformListeners(listenersDown, 3)) {
            this.recordCellAccess(widget, event, RecordCellAccessSource.MouseDown);
        }
        Listener[] listenersUp = widget.getListeners(4);
        if (widget instanceof Label && (listenersDown != null && SWTEventRecorder.hasNonPlatformListeners(listenersDown, 3) || listenersUp != null && SWTEventRecorder.hasNonPlatformListeners(listenersUp, 4)) && (result = this.getLocator().findElement(widget, true, false, false)) != null) {
            ControlUIElement e = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
            e.clickAndWait();
            this.beforeTextState = "";
        }
        this.lastEvents.add(toRecording);
    }

    private void ProcessCTabFolderItemSelection(CTabFolder tabFolder, FindResult result, String tabName) {
        String v;
        boolean needSelection = true;
        if (this.lastTabItemSelection.containsKey(tabFolder) && (v = this.lastTabItemSelection.get(tabFolder)).equals(tabName)) {
            needSelection = false;
        }
        if (needSelection) {
            this.lastTabItemSelection.put((Widget)tabFolder, tabName);
            v = new CompositeUIElement(result.element, (UIPlayer)this.getRecorder());
            CompositeUIElement tabItem = v.tabItem(tabName);
            tabItem.clickAndWait();
        }
    }

    private void processClose(Widget widget) {
        Command lastCmd = this.getRecorder().getContainer().getLast();
        if (lastCmd instanceof Type && ((Type)lastCmd).isTraverse() && ((Type)lastCmd).getCode() == 2) {
            return;
        }
        FindResult result = this.getLocator().findElement(widget, true, false, false);
        if (result != null) {
            ControlUIElement e = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
            e.close();
        }
    }

    List<RecordedEvent> takeMenuEvents(List<RecordedEvent> lastEvents2) {
        ArrayList<RecordedEvent> result = new ArrayList<RecordedEvent>();
        for (RecordedEvent e : lastEvents2) {
            if (!(e.widget instanceof Menu) && !(e.widget instanceof MenuItem) || e.widget.isDisposed()) continue;
            result.add(e);
        }
        return result;
    }

    public synchronized void clear() {
        SWTRecordingHelper.getHelper().clear();
        SWTModelMapper.initializeExtensions((List)this.getRecorder().getProcessors(ISWTModelMapperExtension.class));
        this.lastEvents.clear();
        this.getLocator().cleanMenuSources();
        this.lastTabItemSelection.clear();
        this.inStyledTextAction = false;
        this.lastEvent = null;
        lastTraverseEvent = null;
        this.pressed.clear();
    }

    public void recordDragEvent(Event event) {
        if (this.getRecorder() == null) {
            return;
        }
        if (!this.getRecorder().hasListeners()) {
            return;
        }
        this.dragSupport.processDND(event);
    }

    public void recordSWTDialog(Dialog dialog, Object result) {
        if (this.getRecorder() == null) {
            return;
        }
        if (!this.getRecorder().hasListeners()) {
            return;
        }
        SetSWTDialogInfo info = ProtocolFactory.eINSTANCE.createSetSWTDialogInfo();
        if (dialog instanceof FileDialog) {
            info.setKind(SWTDialogKind.FILE_SELECTOR);
        } else if (dialog instanceof DirectoryDialog) {
            info.setKind(SWTDialogKind.FOLDER_SELECTOR);
        } else if (dialog instanceof MessageBox) {
            info.setKind(SWTDialogKind.MESSAGE_BOX);
        } else if (dialog instanceof FontDialog) {
            info.setKind(SWTDialogKind.FONT_DIALOG);
        } else if (dialog instanceof ColorDialog) {
            info.setKind(SWTDialogKind.COLOR);
        } else {
            return;
        }
        if (result instanceof String[]) {
            String[] stringArray = (String[])result;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String currentStr = stringArray[n2];
                if (dialog instanceof FileDialog) {
                    this.processFileDialogValue(info, currentStr);
                } else {
                    info.getPath().add((Object)currentStr);
                }
                ++n2;
            }
        } else if (result instanceof String) {
            if (dialog instanceof DirectoryDialog) {
                this.processFileDialogValue(info, (String)result);
            } else {
                info.getPath().add((Object)((String)result));
            }
        } else if (result instanceof Integer) {
            info.getPath().add((Object)Integer.toString((Integer)result));
        } else if (result instanceof FontData) {
            info.getPath().add((Object)((FontData)result).toString());
        } else if (result instanceof RGB) {
            RGB rgb = (RGB)result;
            info.getPath().add((Object)(rgb.red + "," + rgb.green + "," + rgb.blue));
        } else {
            info.getPath().clear();
        }
        this.getRecorder().safeExecuteCommand((Command)info);
    }

    private void processFileDialogValue(SetSWTDialogInfo info, String pathStr) {
        try {
            Class.forName("org.eclipse.core.resources.ResourcesPlugin");
        }
        catch (Throwable throwable) {
            info.getPath().add((Object)pathStr);
            return;
        }
        try {
            IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            File f = new File(pathStr);
            Path path = new Path(f.getCanonicalPath());
            if (workspaceLocation.isPrefixOf((IPath)path)) {
                info.getPath().add((Object)("platform:/resource/" + path.removeFirstSegments(workspaceLocation.segmentCount()).setDevice(null)));
            } else {
                info.getPath().add((Object)pathStr);
            }
        }
        catch (IOException iOException) {}
    }

    public void setFreeze(boolean value, SetMode command) {
    }

    public void recordStyledTextOffset(StyledText text) {
        if (this.inStyledTextAction) {
            return;
        }
        if (this.getRecorder() == null) {
            return;
        }
        if (!this.getRecorder().hasListeners()) {
            return;
        }
        if (!this.enabled) {
            this.enable();
        }
        List list = this.getRecorder().getProcessors(IRecordingProcessorExtension.class);
        for (IRecordingProcessorExtension ext : list) {
            if (!ext.isIgnored((Object)text, 13, null)) continue;
            return;
        }
        if (this.isIgnored((Widget)text)) {
            return;
        }
        ContextManagement.Context context = ContextManagement.currentContext();
        if (!(context.contains("org.eclipse.swt.custom.StyledText", "doContent") || context.contains("org.eclipse.swt.custom.StyledText", "setContent") || context.contains("org.eclipse.swt.custom.StyledText", "reset") || context.contains("org.eclipse.swt.custom.StyledText", "handleKey") || context.contains("org.eclipse.swt.custom.StyledText", "setSelectionRange") || context.contains("org.eclipse.swt.custom.StyledText", "setSelection") || context.contains("org.eclipse.swt.custom.StyledText", "setStyleRanges"))) {
            FindResult element;
            Command last = this.getRecorder().getContainer().getLast();
            if (last instanceof Type) {
                Type type = (Type)last;
                if (type.getCode() != null && type.getCode() == 8 && type.getState() != null && type.getState() == 262144) {
                    return;
                }
                if (type.getCode() != null && type.getCode() == 9 && type.getState() != null && type.getState() == 0) {
                    return;
                }
            }
            if ((element = this.getLocator().findElement((Widget)text, false, false, false)) != null) {
                TextUIElement textCtrl = new TextUIElement(element.element, (UIPlayer)this.getRecorder());
                int offset = text.getCaretOffset();
                int lineAtOffset = text.getLineAtOffset(offset);
                int offsetAtLine = text.getOffsetAtLine(lineAtOffset);
                if (!(last instanceof SetTextSelection) || !EcoreUtil.equals((EObject)((SetTextSelection)last).getElement(), (EObject)element.element)) {
                    textCtrl.setTextOffset(lineAtOffset, offset - offsetAtLine);
                }
            }
        }
    }

    public void recordStyledTextActionAfter(StyledText text, int action) {
        this.inStyledTextAction = false;
    }

    public void recordStyledTextActionBefore(StyledText text, int action) {
        this.inStyledTextAction = true;
    }

    public void initialize(final TeslaRecorder teslaRecorder) {
        teslaRecorder.addListener((IRecordingModeListener)this);
        final CommandPostProcessor pp = new CommandPostProcessor(teslaRecorder);
        teslaRecorder.addListener(new IRecordingModeListener(){

            public void changeMode(boolean inRecording) {
                if (inRecording) {
                    teslaRecorder.addListener((ITeslaRecordingListener)pp);
                } else {
                    teslaRecorder.removeListener((ITeslaRecordingListener)pp);
                }
            }
        });
    }

    public int getInitLevel() {
        return 10;
    }

    public void changeMode(boolean inRecording) {
        RecordingModeFeature.setRecordingModeActive((boolean)inRecording);
    }

    public void recordTabFolderEvent(Control tabControl, int eventId) {
        if (this.getRecorder() == null || !this.getRecorder().hasListeners()) {
            return;
        }
        FindResult result = null;
        if (tabControl instanceof CTabFolder) {
            CTabFolder tabFolder = (CTabFolder)tabControl;
            Widget w = EclipseWorkbenchProvider.getProvider().extractViewOrEditorControl(tabFolder);
            if (w != null) {
                Map references = EclipseWorkbenchProvider.getProvider().getWorkbenchReference(this.getPlayer());
                SWTUIElement element = (SWTUIElement)references.get(w);
                result = this.getLocator().findElement(element, false, false, true);
            }
        }
        if (result == null) {
            result = this.getLocator().findElement((Widget)tabControl, false, false, true);
        }
        if (result != null) {
            ControlUIElement ctrl = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
            switch (eventId) {
                case 1: {
                    ctrl.minimize();
                    break;
                }
                case 2: {
                    ctrl.maximize();
                    break;
                }
                case 0: {
                    ctrl.restore();
                    break;
                }
                case 3: {
                    ctrl.showTabList();
                }
            }
        }
    }

    public void resetAssertSelection() {
    }

    public IRecordingHelper getHelper() {
        return SWTRecordingHelper.getHelper();
    }

    public boolean isExclusiveEventHandle(Widget widget, int type, Event event) {
        return false;
    }

    public Event getCurrentEvent() {
        return this.currentEvent;
    }

    public void setCurrentEvent(Event event) {
        this.currentEvent = event;
    }

    private final class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            Shell[] shells;
            if (SWTEventRecorder.this.getLocator().getRecorder() == null) {
                return;
            }
            if (!SWTEventRecorder.this.getRecorder().hasListeners()) {
                return;
            }
            ContextManagement.Context context = ContextManagement.currentContext();
            if (!context.contains("org.eclipse.swt.custom.CTabFolder", "onMouse")) {
                return;
            }
            if (!TeslaCore.isEclipse4() && part instanceof IEditorPart) {
                return;
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            Shell[] shellArray = shells = display.getShells();
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (SWTEventRecorder.isModal(shell)) {
                    return;
                }
                ++n2;
            }
            PartUIElement resultPart = SWTEventRecorder.this.getLocator().findPartElement(part, false);
            if (resultPart != null) {
                resultPart.close();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            int n;
            int n2;
            StackTraceElement[] stackTraceElementArray;
            if (SWTEventRecorder.this.getRecorder() == null) {
                return;
            }
            if (!SWTEventRecorder.this.getRecorder().hasListeners()) {
                return;
            }
            ContextManagement.Context context = ContextManagement.currentContext();
            if (!TeslaCore.isEclipse4()) {
                if (!context.contains("org.eclipse.swt.custom.CTabFolder", "onMouse")) {
                    return;
                }
            } else {
                StackTraceElement[] stack = context.getStackTrace();
                boolean hashMouseUp = false;
                stackTraceElementArray = stack;
                n2 = stack.length;
                n = 0;
                while (n < n2) {
                    StackTraceElement e = stackTraceElementArray[n];
                    if (e.getMethodName().equals("mouseUp")) {
                        String className = e.getClassName();
                        int dollarPos = className.indexOf(36);
                        if (dollarPos > 0) {
                            className = className.substring(0, dollarPos);
                        }
                        if ("org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer".equals(className)) {
                            hashMouseUp = true;
                            break;
                        }
                    }
                    ++n;
                }
                if (!hashMouseUp) {
                    return;
                }
            }
            if (context.contains("org.eclipse.ui.internal.WorkbenchPage", "hideView")) {
                return;
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            Shell[] shells = display.getShells();
            stackTraceElementArray = shells;
            n2 = shells.length;
            n = 0;
            while (n < n2) {
                StackTraceElement shell = stackTraceElementArray[n];
                if (SWTEventRecorder.isModal((Shell)shell)) {
                    return;
                }
                ++n;
            }
            PartUIElement resultPart = SWTEventRecorder.this.getLocator().findPartElement(part, false);
            if (resultPart != null) {
                resultPart.click();
            }
        }
    }

    private static enum RecordCellAccessSource {
        MouseDown,
        MouseUp;

    }
}

