/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.service.ServiceUnavailableException;
import org.eclipse.epp.internal.mpc.core.util.ITransport;
import org.eclipse.epp.internal.mpc.core.util.Messages;

public abstract class TransportFactory {
    private static final String[] factoryClasses = new String[]{"org.eclipse.epp.internal.mpc.core.util.P2TransportFactory", "org.eclipse.epp.internal.mpc.core.util.Eclipse36TransportFactory", "org.eclipse.epp.internal.mpc.core.util.JavaPlatformTransportFactory"};
    private static TransportFactory instance;

    public static synchronized TransportFactory instance() {
        if (instance == null) {
            String[] stringArray = factoryClasses;
            int n = factoryClasses.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    TransportFactory factory;
                    String factoryClass = stringArray[n2];
                    try {
                        factory = (TransportFactory)Class.forName(factoryClass, true, TransportFactory.class.getClassLoader()).newInstance();
                    }
                    catch (Throwable throwable) {
                        break block6;
                    }
                    if (factory.isAvailable()) {
                        instance = factory;
                        break;
                    }
                }
                ++n2;
            }
            if (instance == null) {
                throw new IllegalStateException();
            }
        }
        return instance;
    }

    public ITransport getTransport() {
        return new ITransport(){

            public InputStream stream(URI location, IProgressMonitor monitor) throws FileNotFoundException, CoreException {
                try {
                    return TransportFactory.this.invokeStream(location, monitor);
                }
                catch (Exception e) {
                    TransportFactory.this.handleStreamExceptions(e);
                    return null;
                }
            }
        };
    }

    protected abstract boolean isAvailable();

    protected abstract InputStream invokeStream(URI var1, IProgressMonitor var2) throws Exception;

    protected void handleStreamExceptions(Exception e) throws ServiceUnavailableException, CoreException, FileNotFoundException {
        if (e instanceof InvocationTargetException) {
            InvocationTargetException targetException = (InvocationTargetException)e;
            Throwable cause = targetException.getCause();
            if (cause instanceof CoreException) {
                CoreException coreCause = (CoreException)cause;
                TransportFactory.handleServiceUnavailable(coreCause);
                throw coreCause;
            }
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.epp.mpc.core", e.getMessage(), (Throwable)e));
        }
    }

    protected static void handleServiceUnavailable(CoreException e) throws ServiceUnavailableException {
        Throwable cause;
        if (e.getStatus().getCode() == 1002 && (cause = e.getCause()) != null && cause.getMessage() != null && cause.getMessage().indexOf("503") != -1) {
            throw new ServiceUnavailableException((IStatus)new Status(4, "org.eclipse.epp.mpc.core", 503, Messages.DefaultMarketplaceService_serviceUnavailable503, (Throwable)e));
        }
    }
}

