/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final long KiB = 1024L;
    private static final long MiB = 0x100000L;
    private static final long GiB = 0x40000000L;
    private final ListenerList listeners = new ListenerList();
    private final AtomicReference<State> state;
    private final Config baseConfig;
    private static final String MAGIC_EMPTY_VALUE = new String();

    public Config() {
        this(null);
    }

    public Config(Config defaultConfig) {
        this.baseConfig = defaultConfig;
        this.state = new AtomicReference<State>(this.newState());
    }

    private static String escapeValue(String x) {
        boolean inquote = false;
        int lineStart = 0;
        StringBuilder r = new StringBuilder(x.length());
        block9: for (int k = 0; k < x.length(); ++k) {
            char c = x.charAt(k);
            switch (c) {
                case '\n': {
                    if (inquote) {
                        r.append('\"');
                        inquote = false;
                    }
                    r.append("\\n\\\n");
                    lineStart = r.length();
                    continue block9;
                }
                case '\t': {
                    r.append("\\t");
                    continue block9;
                }
                case '\b': {
                    r.append("\\b");
                    continue block9;
                }
                case '\\': {
                    r.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    r.append("\\\"");
                    continue block9;
                }
                case '#': 
                case ';': {
                    if (!inquote) {
                        r.insert(lineStart, '\"');
                        inquote = true;
                    }
                    r.append(c);
                    continue block9;
                }
                case ' ': {
                    if (!inquote && r.length() > 0 && r.charAt(r.length() - 1) == ' ') {
                        r.insert(lineStart, '\"');
                        inquote = true;
                    }
                    r.append(' ');
                    continue block9;
                }
                default: {
                    r.append(c);
                }
            }
        }
        if (inquote) {
            r.append('\"');
        }
        return r.toString();
    }

    public int getInt(String section, String name, int defaultValue) {
        return this.getInt(section, null, name, defaultValue);
    }

    public int getInt(String section, String subsection, String name, int defaultValue) {
        long val = this.getLong(section, subsection, name, defaultValue);
        if (Integer.MIN_VALUE <= val && val <= Integer.MAX_VALUE) {
            return (int)val;
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().integerValueOutOfRange, section, name));
    }

    public long getLong(String section, String name, long defaultValue) {
        return this.getLong(section, null, name, defaultValue);
    }

    public long getLong(String section, String subsection, String name, long defaultValue) {
        String str = this.getString(section, subsection, name);
        if (str == null) {
            return defaultValue;
        }
        String n = str.trim();
        if (n.length() == 0) {
            return defaultValue;
        }
        long mul = 1L;
        switch (StringUtils.toLowerCase(n.charAt(n.length() - 1))) {
            case 'g': {
                mul = 0x40000000L;
                break;
            }
            case 'm': {
                mul = 0x100000L;
                break;
            }
            case 'k': {
                mul = 1024L;
            }
        }
        if (mul > 1L) {
            n = n.substring(0, n.length() - 1).trim();
        }
        if (n.length() == 0) {
            return defaultValue;
        }
        try {
            return mul * Long.parseLong(n);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidIntegerValue, section, name, str));
        }
    }

    public boolean getBoolean(String section, String name, boolean defaultValue) {
        return this.getBoolean(section, null, name, defaultValue);
    }

    public boolean getBoolean(String section, String subsection, String name, boolean defaultValue) {
        String n = this.getRawString(section, subsection, name);
        if (n == null) {
            return defaultValue;
        }
        if (MAGIC_EMPTY_VALUE == n) {
            return true;
        }
        try {
            return StringUtils.toBoolean(n);
        }
        catch (IllegalArgumentException err) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidBooleanValue, section, name, n));
        }
    }

    public <T extends Enum<?>> T getEnum(String section, String subsection, String name, T defaultValue) {
        Enum[] all = Config.allValuesOf(defaultValue);
        return (T)this.getEnum(all, section, subsection, name, defaultValue);
    }

    private static <T> T[] allValuesOf(T value) {
        try {
            return (Object[])value.getClass().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception err) {
            String typeName = value.getClass().getName();
            String msg = MessageFormat.format(JGitText.get().enumValuesNotAvailable, typeName);
            throw new IllegalArgumentException(msg, err);
        }
    }

    public <T extends Enum<?>> T getEnum(T[] all, String section, String subsection, String name, T defaultValue) {
        String value = this.getString(section, subsection, name);
        if (value == null) {
            return defaultValue;
        }
        String n = value.replace(' ', '_');
        T trueState = null;
        T falseState = null;
        for (T e : all) {
            if (StringUtils.equalsIgnoreCase(((Enum)e).name(), n)) {
                return e;
            }
            if (StringUtils.equalsIgnoreCase(((Enum)e).name(), "TRUE")) {
                trueState = e;
                continue;
            }
            if (!StringUtils.equalsIgnoreCase(((Enum)e).name(), "FALSE")) continue;
            falseState = e;
        }
        if (trueState != null && falseState != null) {
            try {
                return StringUtils.toBoolean(n) ? trueState : falseState;
            }
            catch (IllegalArgumentException err) {
                // empty catch block
            }
        }
        if (subsection != null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported3, section, name, value));
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported2, section, name, value));
    }

    public String getString(String section, String subsection, String name) {
        return this.getRawString(section, subsection, name);
    }

    public String[] getStringList(String section, String subsection, String name) {
        String[] baseList = this.baseConfig != null ? this.baseConfig.getStringList(section, subsection, name) : EMPTY_STRING_ARRAY;
        List<String> lst = this.getRawStringList(section, subsection, name);
        if (lst != null) {
            String[] res = new String[baseList.length + lst.size()];
            int idx = baseList.length;
            System.arraycopy(baseList, 0, res, 0, idx);
            for (String val : lst) {
                res[idx++] = val;
            }
            return res;
        }
        return baseList;
    }

    public Set<String> getSubsections(String section) {
        return this.get(new SubsectionNames(section));
    }

    public Set<String> getSections() {
        return this.get(new SectionNames());
    }

    public Set<String> getNames(String section) {
        return this.getNames(section, null);
    }

    public Set<String> getNames(String section, String subsection) {
        return this.get(new NamesInSection(section, subsection));
    }

    public <T> T get(SectionParser<T> parser) {
        State myState = this.getState();
        Object obj = myState.cache.get(parser);
        if (obj == null) {
            obj = parser.parse(this);
            myState.cache.put(parser, obj);
        }
        return (T)obj;
    }

    public void uncache(SectionParser<?> parser) {
        this.state.get().cache.remove(parser);
    }

    public ListenerHandle addChangeListener(ConfigChangedListener listener) {
        return this.listeners.addConfigChangedListener(listener);
    }

    protected boolean notifyUponTransientChanges() {
        return true;
    }

    protected void fireConfigChangedEvent() {
        this.listeners.dispatch(new ConfigChangedEvent());
    }

    private String getRawString(String section, String subsection, String name) {
        List<String> lst = this.getRawStringList(section, subsection, name);
        if (lst != null) {
            return lst.get(0);
        }
        if (this.baseConfig != null) {
            return this.baseConfig.getRawString(section, subsection, name);
        }
        return null;
    }

    private List<String> getRawStringList(String section, String subsection, String name) {
        List<String> r = null;
        for (Entry e : this.state.get().entryList) {
            if (!e.match(section, subsection, name)) continue;
            r = Config.add(r, e.value);
        }
        return r;
    }

    private static List<String> add(List<String> curr, String value) {
        if (curr == null) {
            return Collections.singletonList(value);
        }
        if (curr.size() == 1) {
            ArrayList<String> r = new ArrayList<String>(2);
            r.add(curr.get(0));
            r.add(value);
            return r;
        }
        curr.add(value);
        return curr;
    }

    private State getState() {
        State base;
        State upd;
        State cur;
        do {
            cur = this.state.get();
            base = this.getBaseState();
            if (cur.baseState != base) continue;
            return cur;
        } while (!this.state.compareAndSet(cur, upd = new State(cur.entryList, base)));
        return upd;
    }

    private State getBaseState() {
        return this.baseConfig != null ? this.baseConfig.getState() : null;
    }

    public void setInt(String section, String subsection, String name, int value) {
        this.setLong(section, subsection, name, value);
    }

    public void setLong(String section, String subsection, String name, long value) {
        String s = value >= 0x40000000L && value % 0x40000000L == 0L ? String.valueOf(value / 0x40000000L) + " g" : (value >= 0x100000L && value % 0x100000L == 0L ? String.valueOf(value / 0x100000L) + " m" : (value >= 1024L && value % 1024L == 0L ? String.valueOf(value / 1024L) + " k" : String.valueOf(value)));
        this.setString(section, subsection, name, s);
    }

    public void setBoolean(String section, String subsection, String name, boolean value) {
        this.setString(section, subsection, name, value ? "true" : "false");
    }

    public <T extends Enum<?>> void setEnum(String section, String subsection, String name, T value) {
        String n = value.name().toLowerCase().replace('_', ' ');
        this.setString(section, subsection, name, n);
    }

    public void setString(String section, String subsection, String name, String value) {
        this.setStringList(section, subsection, name, Collections.singletonList(value));
    }

    public void unset(String section, String subsection, String name) {
        this.setStringList(section, subsection, name, Collections.<String>emptyList());
    }

    public void unsetSection(String section, String subsection) {
        State res;
        State src;
        while (!this.state.compareAndSet(src = this.state.get(), res = this.unsetSection(src, section, subsection))) {
        }
    }

    private State unsetSection(State srcState, String section, String subsection) {
        int max = srcState.entryList.size();
        ArrayList<Entry> r = new ArrayList<Entry>(max);
        boolean lastWasMatch = false;
        for (Entry e : srcState.entryList) {
            if (e.match(section, subsection)) {
                lastWasMatch = true;
                continue;
            }
            if (lastWasMatch && e.section == null && e.subsection == null) continue;
            r.add(e);
        }
        return this.newState(r);
    }

    public void setStringList(String section, String subsection, String name, List<String> values) {
        State res;
        State src;
        while (!this.state.compareAndSet(src = this.state.get(), res = this.replaceStringList(src, section, subsection, name, values))) {
        }
        if (this.notifyUponTransientChanges()) {
            this.fireConfigChangedEvent();
        }
    }

    private State replaceStringList(State srcState, String section, String subsection, String name, List<String> values) {
        Entry e;
        int entryIndex;
        List<Entry> entries = Config.copy(srcState, values);
        int valueIndex = 0;
        int insertPosition = -1;
        for (entryIndex = 0; entryIndex < entries.size() && valueIndex < values.size(); ++entryIndex) {
            e = entries.get(entryIndex);
            if (!e.match(section, subsection, name)) continue;
            entries.set(entryIndex, e.forValue(values.get(valueIndex++)));
            insertPosition = entryIndex + 1;
        }
        if (valueIndex == values.size() && entryIndex < entries.size()) {
            while (entryIndex < entries.size()) {
                if (!(e = entries.get(entryIndex++)).match(section, subsection, name)) continue;
                entries.remove(--entryIndex);
            }
        }
        if (valueIndex < values.size() && entryIndex == entries.size()) {
            if (insertPosition < 0) {
                insertPosition = Config.findSectionEnd(entries, section, subsection);
            }
            if (insertPosition < 0) {
                e = new Entry();
                e.section = section;
                e.subsection = subsection;
                entries.add(e);
                insertPosition = entries.size();
            }
            while (valueIndex < values.size()) {
                e = new Entry();
                e.section = section;
                e.subsection = subsection;
                e.name = name;
                e.value = values.get(valueIndex++);
                entries.add(insertPosition++, e);
            }
        }
        return this.newState(entries);
    }

    private static List<Entry> copy(State src, List<String> values) {
        int max = src.entryList.size() + values.size() + 1;
        ArrayList<Entry> r = new ArrayList<Entry>(max);
        r.addAll(src.entryList);
        return r;
    }

    private static int findSectionEnd(List<Entry> entries, String section, String subsection) {
        for (int i = 0; i < entries.size(); ++i) {
            Entry e = entries.get(i);
            if (!e.match(section, subsection, null)) continue;
            ++i;
            while (i < entries.size() && (e = entries.get(i)).match(section, subsection, e.name)) {
                ++i;
            }
            return i;
        }
        return -1;
    }

    public String toText() {
        StringBuilder out = new StringBuilder();
        for (Entry e : this.state.get().entryList) {
            if (e.prefix != null) {
                out.append(e.prefix);
            }
            if (e.section != null && e.name == null) {
                out.append('[');
                out.append(e.section);
                if (e.subsection != null) {
                    boolean quoted;
                    out.append(' ');
                    String escaped = Config.escapeValue(e.subsection);
                    boolean bl = quoted = escaped.startsWith("\"") && escaped.endsWith("\"");
                    if (!quoted) {
                        out.append('\"');
                    }
                    out.append(escaped);
                    if (!quoted) {
                        out.append('\"');
                    }
                }
                out.append(']');
            } else if (e.section != null && e.name != null) {
                if (e.prefix == null || "".equals(e.prefix)) {
                    out.append('\t');
                }
                out.append(e.name);
                if (MAGIC_EMPTY_VALUE != e.value) {
                    out.append(" =");
                    if (e.value != null) {
                        out.append(' ');
                        out.append(Config.escapeValue(e.value));
                    }
                }
                if (e.suffix != null) {
                    out.append(' ');
                }
            }
            if (e.suffix != null) {
                out.append(e.suffix);
            }
            out.append('\n');
        }
        return out.toString();
    }

    public void fromText(String text) throws ConfigInvalidException {
        int input;
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        StringReader in = new StringReader(text);
        Entry last = null;
        Entry e = new Entry();
        while (-1 != (input = in.read())) {
            char c = (char)input;
            if ('\n' == c) {
                newEntries.add(e);
                if (e.section != null) {
                    last = e;
                }
                e = new Entry();
                continue;
            }
            if (e.suffix != null) {
                e.suffix = e.suffix + c;
                continue;
            }
            if (';' == c || '#' == c) {
                e.suffix = String.valueOf(c);
                continue;
            }
            if (e.section == null && Character.isWhitespace(c)) {
                if (e.prefix == null) {
                    e.prefix = "";
                }
                e.prefix = e.prefix + c;
                continue;
            }
            if ('[' == c) {
                e.section = Config.readSectionName(in);
                input = in.read();
                if (34 == input) {
                    e.subsection = Config.readValue(in, true, 34);
                    input = in.read();
                }
                if (93 != input) {
                    throw new ConfigInvalidException(JGitText.get().badGroupHeader);
                }
                e.suffix = "";
                continue;
            }
            if (last != null) {
                e.section = last.section;
                e.subsection = last.subsection;
                in.reset();
                e.name = Config.readKeyName(in);
                if (e.name.endsWith("\n")) {
                    e.name = e.name.substring(0, e.name.length() - 1);
                    e.value = MAGIC_EMPTY_VALUE;
                    continue;
                }
                e.value = Config.readValue(in, false, -1);
                continue;
            }
            throw new ConfigInvalidException(JGitText.get().invalidLineInConfigFile);
        }
        this.state.set(this.newState(newEntries));
    }

    private State newState() {
        return new State(Collections.<Entry>emptyList(), this.getBaseState());
    }

    private State newState(List<Entry> entries) {
        return new State(Collections.unmodifiableList(entries), this.getBaseState());
    }

    protected void clear() {
        this.state.set(this.newState());
    }

    private static String readSectionName(StringReader in) throws ConfigInvalidException {
        StringBuilder name;
        block6: {
            name = new StringBuilder();
            while (true) {
                int c;
                if ((c = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (93 == c) {
                    in.reset();
                    break block6;
                }
                if (32 == c || 9 == c) {
                    do {
                        if ((c = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (34 != c) continue;
                        in.reset();
                        break block6;
                    } while (32 == c || 9 == c);
                    throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name));
                }
                if (!Character.isLetterOrDigit((char)c) && 46 != c && 45 != c) break;
                name.append((char)c);
            }
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name));
        }
        return name.toString();
    }

    private static String readKeyName(StringReader in) throws ConfigInvalidException {
        StringBuilder name;
        block7: {
            int c;
            name = new StringBuilder();
            while (true) {
                if ((c = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (61 == c) break block7;
                if (32 == c || 9 == c) {
                    do {
                        if ((c = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (61 == c) break block7;
                        if (59 != c && 35 != c && 10 != c) continue;
                        in.reset();
                        break block7;
                    } while (32 == c || 9 == c);
                    throw new ConfigInvalidException(JGitText.get().badEntryDelimiter);
                }
                if (!Character.isLetterOrDigit((char)c) && c != 45) break;
                name.append((char)c);
            }
            if (10 == c) {
                in.reset();
                name.append((char)c);
            } else {
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEntryName, name));
            }
        }
        return name.toString();
    }

    private static String readValue(StringReader in, boolean quote, int eol) throws ConfigInvalidException {
        StringBuilder value = new StringBuilder();
        boolean space = false;
        block9: while (true) {
            int c;
            if ((c = in.read()) < 0) {
                if (value.length() != 0) break;
                throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
            }
            if (10 == c) {
                if (quote) {
                    throw new ConfigInvalidException(JGitText.get().newlineInQuotesNotAllowed);
                }
                in.reset();
                break;
            }
            if (eol == c) break;
            if (!quote) {
                if (Character.isWhitespace((char)c)) {
                    space = true;
                    continue;
                }
                if (59 == c || 35 == c) {
                    in.reset();
                    break;
                }
            }
            if (space) {
                if (value.length() > 0) {
                    value.append(' ');
                }
                space = false;
            }
            if (92 == c) {
                c = in.read();
                switch (c) {
                    case -1: {
                        throw new ConfigInvalidException(JGitText.get().endOfFileInEscape);
                    }
                    case 10: {
                        continue block9;
                    }
                    case 116: {
                        value.append('\t');
                        continue block9;
                    }
                    case 98: {
                        value.append('\b');
                        continue block9;
                    }
                    case 110: {
                        value.append('\n');
                        continue block9;
                    }
                    case 92: {
                        value.append('\\');
                        continue block9;
                    }
                    case 34: {
                        value.append('\"');
                        continue block9;
                    }
                }
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEscape, Character.valueOf((char)c)));
            }
            if (34 == c) {
                quote = !quote;
                continue;
            }
            value.append((char)c);
        }
        return value.length() > 0 ? value.toString() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseFoldingSet
    extends AbstractSet<String> {
        private final Map<String, String> names;

        CaseFoldingSet(Map<String, String> names) {
            this.names = Collections.unmodifiableMap(names);
        }

        @Override
        public boolean contains(Object needle) {
            if (!(needle instanceof String)) {
                return false;
            }
            String n = (String)needle;
            return this.names.containsKey(n) || this.names.containsKey(StringUtils.toLowerCase(n));
        }

        @Override
        public Iterator<String> iterator() {
            return this.names.values().iterator();
        }

        @Override
        public int size() {
            return this.names.size();
        }
    }

    private static class Entry {
        String prefix;
        String section;
        String subsection;
        String name;
        String value;
        String suffix;

        private Entry() {
        }

        Entry forValue(String newValue) {
            Entry e = new Entry();
            e.prefix = this.prefix;
            e.section = this.section;
            e.subsection = this.subsection;
            e.name = this.name;
            e.value = newValue;
            e.suffix = this.suffix;
            return e;
        }

        boolean match(String aSection, String aSubsection, String aKey) {
            return Entry.eqIgnoreCase(this.section, aSection) && Entry.eqSameCase(this.subsection, aSubsection) && Entry.eqIgnoreCase(this.name, aKey);
        }

        boolean match(String aSection, String aSubsection) {
            return Entry.eqIgnoreCase(this.section, aSection) && Entry.eqSameCase(this.subsection, aSubsection);
        }

        private static boolean eqIgnoreCase(String a, String b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return StringUtils.equalsIgnoreCase(a, b);
        }

        private static boolean eqSameCase(String a, String b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.equals(b);
        }

        public String toString() {
            if (this.section == null) {
                return "<empty>";
            }
            StringBuilder b = new StringBuilder(this.section);
            if (this.subsection != null) {
                b.append(".").append(this.subsection);
            }
            if (this.name != null) {
                b.append(".").append(this.name);
            }
            if (this.value != null) {
                b.append("=").append(this.value);
            }
            return b.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamesInSection
    implements SectionParser<Set<String>> {
        private final String section;
        private final String subsection;

        NamesInSection(String sectionName, String subSectionName) {
            this.section = sectionName;
            this.subsection = subSectionName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.section.hashCode();
            result = 31 * result + (this.subsection == null ? 0 : this.subsection.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NamesInSection other = (NamesInSection)obj;
            if (!this.section.equals(other.section)) {
                return false;
            }
            return !(this.subsection == null ? other.subsection != null : !this.subsection.equals(other.subsection));
        }

        @Override
        public Set<String> parse(Config cfg) {
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            while (cfg != null) {
                for (Entry e : ((State)((Config)cfg).state.get()).entryList) {
                    String lc;
                    if (e.name == null || !StringUtils.equalsIgnoreCase(this.section, e.section) || (this.subsection != null || e.subsection != null) && (this.subsection == null || !this.subsection.equals(e.subsection)) || m.containsKey(lc = StringUtils.toLowerCase(e.name))) continue;
                    m.put(lc, e.name);
                }
                cfg = cfg.baseConfig;
            }
            return new CaseFoldingSet(m);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SectionNames
    implements SectionParser<Set<String>> {
        private SectionNames() {
        }

        @Override
        public Set<String> parse(Config cfg) {
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            while (cfg != null) {
                for (Entry e : ((State)((Config)cfg).state.get()).entryList) {
                    String lc;
                    if (e.section == null || m.containsKey(lc = StringUtils.toLowerCase(e.section))) continue;
                    m.put(lc, e.section);
                }
                cfg = cfg.baseConfig;
            }
            return new CaseFoldingSet(m);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SectionParser<T> {
        public T parse(Config var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class State {
        final List<Entry> entryList;
        final Map<Object, Object> cache;
        final State baseState;

        State(List<Entry> entries, State base) {
            this.entryList = entries;
            this.cache = new ConcurrentHashMap<Object, Object>(16, 0.75f, 1);
            this.baseState = base;
        }
    }

    private static class StringReader {
        private final char[] buf;
        private int pos;

        StringReader(String in) {
            this.buf = in.toCharArray();
        }

        int read() {
            try {
                return this.buf[this.pos++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.pos = this.buf.length;
                return -1;
            }
        }

        void reset() {
            --this.pos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubsectionNames
    implements SectionParser<Set<String>> {
        private final String section;

        SubsectionNames(String sectionName) {
            this.section = sectionName;
        }

        public int hashCode() {
            return this.section.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof SubsectionNames) {
                return this.section.equals(((SubsectionNames)other).section);
            }
            return false;
        }

        @Override
        public Set<String> parse(Config cfg) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            while (cfg != null) {
                for (Entry e : ((State)((Config)cfg).state.get()).entryList) {
                    if (e.subsection == null || e.name != null || !StringUtils.equalsIgnoreCase(this.section, e.section)) continue;
                    result.add(e.subsection);
                }
                cfg = cfg.baseConfig;
            }
            return Collections.unmodifiableSet(result);
        }
    }
}

