/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.TreeFormatter;

class NonNoteEntry
extends ObjectId {
    private final byte[] name;
    private final FileMode mode;
    NonNoteEntry next;

    NonNoteEntry(byte[] name, FileMode mode, AnyObjectId id) {
        super(id);
        this.name = name;
        this.mode = mode;
    }

    void format(TreeFormatter fmt) {
        fmt.append(this.name, this.mode, (AnyObjectId)this);
    }

    int treeEntrySize() {
        return TreeFormatter.entrySize(this.mode, this.name.length);
    }

    int pathCompare(byte[] bBuf, int bPos, int bLen, FileMode bMode) {
        return NonNoteEntry.pathCompare(this.name, 0, this.name.length, this.mode, bBuf, bPos, bLen, bMode);
    }

    private static int pathCompare(byte[] aBuf, int aPos, int aEnd, FileMode aMode, byte[] bBuf, int bPos, int bEnd, FileMode bMode) {
        while (aPos < aEnd && bPos < bEnd) {
            int cmp;
            if ((cmp = (aBuf[aPos++] & 0xFF) - (bBuf[bPos++] & 0xFF)) == 0) continue;
            return cmp;
        }
        if (aPos < aEnd) {
            return (aBuf[aPos] & 0xFF) - NonNoteEntry.lastPathChar(bMode);
        }
        if (bPos < bEnd) {
            return NonNoteEntry.lastPathChar(aMode) - (bBuf[bPos] & 0xFF);
        }
        return 0;
    }

    private static int lastPathChar(FileMode mode) {
        return FileMode.TREE.equals(mode.getBits()) ? 47 : 0;
    }
}

