/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.ObjectDirectoryInserter;
import org.eclipse.jgit.storage.file.PackFile;
import org.eclipse.jgit.storage.file.WindowCursor;
import org.eclipse.jgit.storage.pack.CachedPack;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.util.FS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FileObjectDatabase
extends ObjectDatabase {
    FileObjectDatabase() {
    }

    @Override
    public ObjectReader newReader() {
        return new WindowCursor(this);
    }

    @Override
    public ObjectDirectoryInserter newInserter() {
        return new ObjectDirectoryInserter(this, this.getConfig());
    }

    @Override
    public boolean has(AnyObjectId objectId) {
        return this.hasObjectImpl1(objectId) || this.hasObjectImpl2(objectId.name());
    }

    File fileFor(AnyObjectId objectId) {
        return this.fileFor(objectId.name());
    }

    File fileFor(String objectName) {
        String d = objectName.substring(0, 2);
        String f = objectName.substring(2);
        return new File(new File(this.getDirectory(), d), f);
    }

    final boolean hasObjectImpl1(AnyObjectId objectId) {
        if (this.hasObject1(objectId)) {
            return true;
        }
        for (AlternateHandle alt : this.myAlternates()) {
            if (!alt.db.hasObjectImpl1(objectId)) continue;
            return true;
        }
        return this.tryAgain1() && this.hasObject1(objectId);
    }

    final boolean hasObjectImpl2(String objectId) {
        if (this.hasObject2(objectId)) {
            return true;
        }
        for (AlternateHandle alt : this.myAlternates()) {
            if (!alt.db.hasObjectImpl2(objectId)) continue;
            return true;
        }
        return false;
    }

    abstract void resolve(Set<ObjectId> var1, AbbreviatedObjectId var2) throws IOException;

    abstract Config getConfig();

    abstract FS getFS();

    ObjectLoader openObject(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openObjectImpl1(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        ldr = this.openObjectImpl2(curs, objectId.name(), objectId);
        if (ldr != null) {
            return ldr;
        }
        return null;
    }

    final ObjectLoader openObjectImpl1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openObject1(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        for (AlternateHandle alt : this.myAlternates()) {
            ldr = alt.db.openObjectImpl1(curs, objectId);
            if (ldr == null) continue;
            return ldr;
        }
        if (this.tryAgain1() && (ldr = this.openObject1(curs, objectId)) != null) {
            return ldr;
        }
        return null;
    }

    final ObjectLoader openObjectImpl2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openObject2(curs, objectName, objectId);
        if (ldr != null) {
            return ldr;
        }
        for (AlternateHandle alt : this.myAlternates()) {
            ldr = alt.db.openObjectImpl2(curs, objectName, objectId);
            if (ldr == null) continue;
            return ldr;
        }
        return null;
    }

    long getObjectSize(WindowCursor curs, AnyObjectId objectId) throws IOException {
        long sz = this.getObjectSizeImpl1(curs, objectId);
        if (0L <= sz) {
            return sz;
        }
        return this.getObjectSizeImpl2(curs, objectId.name(), objectId);
    }

    final long getObjectSizeImpl1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        long sz = this.getObjectSize1(curs, objectId);
        if (0L <= sz) {
            return sz;
        }
        for (AlternateHandle alt : this.myAlternates()) {
            sz = alt.db.getObjectSizeImpl1(curs, objectId);
            if (0L > sz) continue;
            return sz;
        }
        if (this.tryAgain1() && 0L <= (sz = this.getObjectSize1(curs, objectId))) {
            return sz;
        }
        return -1L;
    }

    final long getObjectSizeImpl2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        long sz = this.getObjectSize2(curs, objectName, objectId);
        if (0L <= sz) {
            return sz;
        }
        for (AlternateHandle alt : this.myAlternates()) {
            sz = alt.db.getObjectSizeImpl2(curs, objectName, objectId);
            if (0L > sz) continue;
            return sz;
        }
        return -1L;
    }

    abstract void selectObjectRepresentation(PackWriter var1, ObjectToPack var2, WindowCursor var3) throws IOException;

    abstract File getDirectory();

    abstract Collection<? extends CachedPack> getCachedPacks() throws IOException;

    abstract AlternateHandle[] myAlternates();

    abstract boolean tryAgain1();

    abstract boolean hasObject1(AnyObjectId var1);

    abstract boolean hasObject2(String var1);

    abstract ObjectLoader openObject1(WindowCursor var1, AnyObjectId var2) throws IOException;

    abstract ObjectLoader openObject2(WindowCursor var1, String var2, AnyObjectId var3) throws IOException;

    abstract long getObjectSize1(WindowCursor var1, AnyObjectId var2) throws IOException;

    abstract long getObjectSize2(WindowCursor var1, String var2, AnyObjectId var3) throws IOException;

    abstract InsertLooseObjectResult insertUnpackedObject(File var1, ObjectId var2, boolean var3) throws IOException;

    abstract PackFile openPack(File var1, File var2) throws IOException;

    abstract FileObjectDatabase newCachedFileObjectDatabase();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AlternateHandle {
        final FileObjectDatabase db;

        AlternateHandle(FileObjectDatabase db) {
            this.db = db;
        }

        Collection<CachedPack> getCachedPacks() throws IOException {
            return this.db.getCachedPacks();
        }

        void close() {
            this.db.close();
        }
    }

    static class AlternateRepository
    extends AlternateHandle {
        final FileRepository repository;

        AlternateRepository(FileRepository r) {
            super(r.getObjectDatabase());
            this.repository = r;
        }

        void close() {
            this.repository.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InsertLooseObjectResult {
        INSERTED,
        EXISTS_PACKED,
        EXISTS_LOOSE,
        FAILURE;

    }
}

