/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;

public abstract class Executable
implements IExecutable {
    protected static final Executable[] EMPTY = new Executable[0];
    private Executable parent;
    private final ExecutionPhase phase;
    private final boolean debug;

    public abstract Executable[] getChildren();

    public abstract void startLaunching();

    public abstract void terminate(boolean var1);

    public abstract IStatus execute() throws InterruptedException;

    protected Executable getParent() {
        return this.parent;
    }

    protected void setParent(Executable parent) {
        this.parent = parent;
    }

    protected Executable(boolean debug) {
        this(debug, ExecutionPhase.AUTO);
    }

    protected Executable(boolean debug, ExecutionPhase phase) {
        this.debug = debug;
        this.phase = phase;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void dispose() {
        Executable[] childs = this.getChildren();
        if (childs != null) {
            Executable[] executableArray = childs;
            int n = childs.length;
            int n2 = 0;
            while (n2 < n) {
                Executable child = executableArray[n2];
                child.dispose();
                ++n2;
            }
        }
    }

    public abstract void postExecute();

    @Override
    public Report getResultReport() {
        return null;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public ExecutionPhase getPhase() {
        return this.phase;
    }
}

