/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.ConfigurationPolicy;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.LocalSite;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteReconciler
extends ModelObject {
    private SiteReconciler(LocalSite siteLocal) {
    }

    public static void checkConfiguredFeatures(IConfiguredSite configuredSite) {
        Map patches;
        ConfiguredSite cSite = (ConfiguredSite)configuredSite;
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Validate configuration of site " + cSite.getSite().getURL());
        }
        IFeatureReference[] configuredRefs = cSite.getConfiguredFeatures();
        ArrayList<IFeature> allPossibleConfiguredFeatures = new ArrayList<IFeature>();
        int i = 0;
        while (i < configuredRefs.length) {
            try {
                IFeature feature = configuredRefs[i].getFeature(null);
                allPossibleConfiguredFeatures.add(feature);
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                    UpdateCore.debug("   configured feature " + feature.getVersionedIdentifier().toString());
                }
            }
            catch (CoreException e) {
                UpdateCore.warn("", e);
            }
            ++i;
        }
        ArrayList topFeatures = SiteReconciler.computeTopFeatures(allPossibleConfiguredFeatures);
        ArrayList topNonEfixFeatures = SiteReconciler.getNonEfixFeatures(topFeatures);
        ArrayList configuredFeatures = SiteReconciler.expandFeatures(topNonEfixFeatures, configuredSite);
        if (topFeatures.size() != topNonEfixFeatures.size() && !(patches = SiteReconciler.getPatchesAsFeature(allPossibleConfiguredFeatures)).isEmpty()) {
            List efixesToEnable = SiteReconciler.getPatchesToEnable(patches, configuredFeatures);
            Iterator iter = efixesToEnable.iterator();
            while (iter.hasNext()) {
                IFeature element = (IFeature)iter.next();
                ArrayList expandedEfix = new ArrayList();
                SiteReconciler.expandEfixFeature(element, expandedEfix, configuredSite);
                configuredFeatures.addAll(expandedEfix);
            }
        }
        ArrayList extras = SiteReconciler.diff(allPossibleConfiguredFeatures, configuredFeatures);
        ConfigurationPolicy cPolicy = cSite.getConfigurationPolicy();
        int i2 = 0;
        while (i2 < extras.size()) {
            IFeature feature = (IFeature)extras.get(i2);
            ISiteFeatureReference ref = cSite.getSite().getFeatureReference(feature);
            try {
                cPolicy.unconfigure(ref, true, false);
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                    UpdateCore.debug("Unconfiguring \"extra\" feature " + feature.getVersionedIdentifier().toString());
                }
            }
            catch (CoreException e) {
                UpdateCore.warn("", e);
            }
            ++i2;
        }
    }

    private static ArrayList computeTopFeatures(ArrayList features) {
        HashMap<VersionedIdentifier, IFeature> topFeatures = new HashMap<VersionedIdentifier, IFeature>(features.size());
        Iterator it = features.iterator();
        while (it.hasNext()) {
            IFeature f = (IFeature)it.next();
            topFeatures.put(f.getVersionedIdentifier(), f);
        }
        it = features.iterator();
        while (it.hasNext()) {
            try {
                IIncludedFeatureReference[] children = ((IFeature)it.next()).getIncludedFeatureReferences();
                int j = 0;
                while (j < children.length) {
                    block9: {
                        try {
                            topFeatures.remove(children[j].getVersionedIdentifier());
                        }
                        catch (CoreException e1) {
                            if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_WARNINGS) break block9;
                            UpdateCore.warn("", e1);
                        }
                    }
                    ++j;
                }
            }
            catch (CoreException e) {
                UpdateCore.warn("", e);
            }
        }
        ArrayList list = new ArrayList();
        list.addAll(topFeatures.values());
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Computed top-level features");
            int i = 0;
            while (i < topFeatures.size()) {
                UpdateCore.debug("   " + ((IFeature)list.get(i)).getVersionedIdentifier().toString());
                ++i;
            }
        }
        return list;
    }

    private static ArrayList expandFeatures(ArrayList features, IConfiguredSite configuredSite) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < features.size()) {
            SiteReconciler.expandFeature((IFeature)features.get(i), result, configuredSite);
            ++i;
        }
        return result;
    }

    private static void expandFeature(IFeature feature, ArrayList features, IConfiguredSite configuredSite) {
        if (!features.contains(feature)) {
            features.add(feature);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("Retaining configured feature " + feature.getVersionedIdentifier().toString());
            }
        }
        IIncludedFeatureReference[] children = null;
        try {
            children = feature.getIncludedFeatureReferences();
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
            return;
        }
        int j = 0;
        while (j < children.length) {
            IFeature child;
            block8: {
                child = null;
                try {
                    child = children[j].getFeature(null);
                }
                catch (CoreException e) {
                    if (UpdateManagerUtils.isOptional(children[j])) break block8;
                    UpdateCore.warn("", e);
                }
            }
            if (child != null) {
                SiteReconciler.expandFeature(child, features, configuredSite);
            }
            ++j;
        }
    }

    private static ArrayList diff(ArrayList left, ArrayList right) {
        ArrayList<IFeature> result = new ArrayList<IFeature>();
        int i = 0;
        while (i < left.size()) {
            IFeature feature = (IFeature)left.get(i);
            if (!right.contains(feature)) {
                result.add(feature);
            }
            ++i;
        }
        return result;
    }

    private static Map getPatchesAsFeature(ArrayList allConfiguredFeatures) {
        HashMap patches = new HashMap();
        if (allConfiguredFeatures != null) {
            Iterator iter = allConfiguredFeatures.iterator();
            while (iter.hasNext()) {
                ArrayList<VersionedIdentifier> patchedFeaturesID = new ArrayList<VersionedIdentifier>();
                IFeature element = (IFeature)iter.next();
                int i = 0;
                while (i < element.getImports().length) {
                    if (element.getImports()[i].isPatch()) {
                        VersionedIdentifier id = element.getImports()[i].getVersionedIdentifier();
                        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                            UpdateCore.debug("Found patch " + element + " for feature identifier " + id);
                        }
                        patchedFeaturesID.add(id);
                    }
                    ++i;
                }
                if (patchedFeaturesID.isEmpty()) continue;
                patches.put(element, patchedFeaturesID);
            }
        }
        return patches;
    }

    private static List getPatchesToEnable(Map efixes, ArrayList configuredFeatures) {
        ArrayList<VersionedIdentifier> enabledVersionedIdentifier = new ArrayList<VersionedIdentifier>();
        Iterator<Object> iter = configuredFeatures.iterator();
        while (iter.hasNext()) {
            IFeature element = (IFeature)iter.next();
            enabledVersionedIdentifier.add(element.getVersionedIdentifier());
        }
        ArrayList<IFeature> result = new ArrayList<IFeature>();
        iter = efixes.keySet().iterator();
        while (iter.hasNext()) {
            boolean toEnable = false;
            IFeature efixFeature = (IFeature)iter.next();
            List patchedFeatures = (List)efixes.get(efixFeature);
            Iterator patchedFeaturesIter = patchedFeatures.iterator();
            while (patchedFeaturesIter.hasNext() && !toEnable) {
                VersionedIdentifier patchedFeatureID = (VersionedIdentifier)patchedFeaturesIter.next();
                if (!enabledVersionedIdentifier.contains(patchedFeatureID)) continue;
                toEnable = true;
            }
            if (!toEnable) {
                if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_RECONCILER) continue;
                UpdateCore.debug("The Patch " + efixFeature + " does not patch any enabled features: it will be disabled");
                continue;
            }
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("The patch " + efixFeature + " will be enabled.");
            }
            result.add(efixFeature);
        }
        return result;
    }

    private static ArrayList getNonEfixFeatures(ArrayList topFeatures) {
        Map efixFeatures = SiteReconciler.getPatchesAsFeature(topFeatures);
        Set keySet = efixFeatures.keySet();
        if (keySet == null || keySet.isEmpty()) {
            return topFeatures;
        }
        Iterator iter = topFeatures.iterator();
        ArrayList<IFeature> result = new ArrayList<IFeature>();
        while (iter.hasNext()) {
            IFeature element = (IFeature)iter.next();
            if (keySet.contains(element)) continue;
            result.add(element);
        }
        return result;
    }

    private static void expandEfixFeature(IFeature feature, ArrayList features, IConfiguredSite configuredSite) {
        if (!features.contains(feature)) {
            features.add(feature);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("Retaining configured feature " + feature.getVersionedIdentifier().toString());
            }
        }
        IIncludedFeatureReference[] children = null;
        try {
            children = feature.getIncludedFeatureReferences();
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
            return;
        }
        int j = 0;
        while (j < children.length) {
            IFeature child;
            block8: {
                child = null;
                try {
                    child = children[j].getFeature(null);
                }
                catch (CoreException e) {
                    if (children[j].isOptional()) break block8;
                    UpdateCore.warn("", e);
                }
            }
            if (child != null && !UpdateCore.isPatch(child)) {
                SiteReconciler.expandEfixFeature(child, features, configuredSite);
            }
            ++j;
        }
    }
}

