/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.DefaultContextMaker;
import org.eclipse.rcptt.core.IContextMaker;
import org.eclipse.rcptt.core.IContextProcessor;
import org.eclipse.rcptt.core.IEclAwareProcessor;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ecl.runtime.ISession;
import org.eclipse.rcptt.internal.core.RcpttPlugin;

public class ContextTypeManager {
    private static ContextTypeManager instance;
    private static final String EXPT_ID = "org.eclipse.rcptt.core.contextTypes";
    private static final String PROCESSOR_EXPT_ID = "org.eclipse.rcptt.core.contextProcessors";
    private static final String MAKER_EXPT_ID = "org.eclipse.rcptt.core.contextMaker";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_CLASS = "class";
    private static Map<String, String> legacyTypes;
    private ContextType[] types;
    private Map<EClass, ContextType> classToType;
    private Map<String, ContextType> idToType;
    private Map<String, IContextProcessor> idToProcessor;
    private Map<String, IContextMaker> idToMaker;

    static {
        legacyTypes = new HashMap<String, String>();
        legacyTypes.put("com.xored.q7.debug.context", "org.eclipse.rcptt.ctx.debug");
        legacyTypes.put("com.xored.q7.filesystem.context", "org.eclipse.rcptt.ctx.filesystem");
        legacyTypes.put("com.xored.q7.ui.context.group", "org.eclipse.rcptt.ctx.group");
        legacyTypes.put("com.xored.q7.ui.context.superc", "org.eclipse.rcptt.ctx.super");
        legacyTypes.put("com.xored.q7.ui.context.workbench", "org.eclipse.rcptt.ctx.workbench");
        legacyTypes.put("com.xored.q7.workspace.context", "org.eclipse.rcptt.ctx.workspace");
        legacyTypes.put("com.xored.q7.parameters.context", "org.eclipse.rcptt.ctx.parameters");
        legacyTypes.put("com.xored.q7.preferences.context", "org.eclipse.rcptt.ctx.preferences");
        legacyTypes.put("com.xored.q7.ecl.context", "org.eclipse.rcptt.ctx.ecl");
    }

    public static ContextTypeManager getInstance() {
        if (instance == null) {
            instance = new ContextTypeManager();
        }
        return instance;
    }

    public ContextType getTypeByContext(Context context) {
        this.init();
        return this.classToType.get(context.eClass());
    }

    public ContextType getTypeById(String id) {
        this.init();
        if (legacyTypes.containsKey(id)) {
            id = legacyTypes.get(id);
        }
        return this.idToType.get(id);
    }

    public ContextType[] getTypes() {
        this.init();
        return this.types;
    }

    public void apply(Context context, ISession session) throws CoreException {
        ContextType type = this.getTypeByContext(context);
        IContextProcessor processor = this.getProcessor(type.getId());
        if (processor == null) {
            throw new CoreException(RcpttPlugin.createStatus("Failed to locate processor for context:" + context.getId()));
        }
        if (processor instanceof IEclAwareProcessor) {
            ((IEclAwareProcessor)((Object)processor)).apply(context, session);
        } else {
            processor.apply(context);
        }
    }

    public Context createContext(String contextType, EObject param) throws CoreException {
        ContextType type = this.getTypeById(contextType);
        IContextProcessor processor = this.getProcessor(type.getId());
        return processor.create(param);
    }

    public synchronized IContextMaker getMaker(String contextTypeId) {
        IContextMaker maker;
        if (this.idToMaker == null) {
            IConfigurationElement[] elements;
            this.idToMaker = new HashMap<String, IContextMaker>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(MAKER_EXPT_ID);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    String id = element.getAttribute(ATTR_TYPE);
                    IContextMaker processor = (IContextMaker)element.createExecutableExtension(ATTR_CLASS);
                    this.idToMaker.put(id, processor);
                }
                catch (CoreException e) {
                    RcpttPlugin.log(e);
                }
                ++n2;
            }
        }
        if ((maker = this.idToMaker.get(contextTypeId)) == null) {
            return new DefaultContextMaker();
        }
        return maker;
    }

    public synchronized IContextProcessor getProcessor(String contextTypeId) {
        if (this.idToProcessor == null) {
            IConfigurationElement[] elements;
            this.idToProcessor = new HashMap<String, IContextProcessor>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PROCESSOR_EXPT_ID);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    String id = element.getAttribute(ATTR_TYPE);
                    IContextProcessor processor = (IContextProcessor)element.createExecutableExtension(ATTR_CLASS);
                    this.idToProcessor.put(id, processor);
                }
                catch (CoreException e) {
                    RcpttPlugin.log(e);
                }
                ++n2;
            }
        }
        return this.idToProcessor.get(contextTypeId);
    }

    private synchronized void init() {
        IConfigurationElement[] elements;
        if (this.classToType != null) {
            return;
        }
        ArrayList<ContextType> list = new ArrayList<ContextType>();
        this.classToType = new HashMap<EClass, ContextType>();
        this.idToType = new HashMap<String, ContextType>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                ContextType type = new ContextType(element);
                list.add(type);
                this.classToType.put(type.getEClass(), type);
                this.idToType.put(type.getId(), type);
            }
            catch (CoreException e) {
                RcpttPlugin.log(e);
            }
            ++n2;
        }
        this.types = list.toArray(new ContextType[list.size()]);
        Arrays.sort(this.types, new Comparator<ContextType>(){

            @Override
            public int compare(ContextType t1, ContextType t2) {
                return -Integer.valueOf(t1.getPriority()).compareTo(t2.getPriority());
            }
        });
    }
}

