/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.text.NumberFormat;
import org.eclipse.jdt.internal.junit.BasicElementLabels;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.junit.model.ITestCaseElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.junit.model.ITestRunSession;
import org.eclipse.jdt.junit.model.ITestSuiteElement;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class TestSessionLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final TestRunnerViewPart fTestRunnerPart;
    private final int fLayoutMode;
    private final NumberFormat timeFormat;
    private boolean fShowTime;

    public TestSessionLabelProvider(TestRunnerViewPart testRunnerPart, int layoutMode) {
        this.fTestRunnerPart = testRunnerPart;
        this.fLayoutMode = layoutMode;
        this.fShowTime = true;
        this.timeFormat = NumberFormat.getNumberInstance();
        this.timeFormat.setGroupingUsed(true);
        this.timeFormat.setMinimumFractionDigits(3);
        this.timeFormat.setMaximumFractionDigits(3);
        this.timeFormat.setMinimumIntegerDigits(1);
    }

    public StyledString getStyledText(Object element) {
        String label = this.getSimpleLabel(element);
        if (label == null) {
            return new StyledString(element.toString());
        }
        StyledString text = new StyledString(label);
        ITestElement testElement = (ITestElement)element;
        if (this.fLayoutMode == 1) {
            String testKindDisplayName;
            if (testElement.getParentContainer() instanceof ITestRunSession && (testKindDisplayName = this.fTestRunnerPart.getTestKindDisplayName()) != null) {
                String decorated = Messages.format((String)JUnitMessages.TestSessionLabelProvider_testName_JUnitVersion, (Object[])new Object[]{label, testKindDisplayName});
                text = StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)text);
            }
        } else if (element instanceof ITestCaseElement) {
            String className = BasicElementLabels.getJavaElementName((String)((ITestCaseElement)element).getTestClassName());
            String decorated = Messages.format((String)JUnitMessages.TestSessionLabelProvider_testMethodName_className, (Object[])new Object[]{label, className});
            text = StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)text);
        }
        return this.addElapsedTime(text, testElement.getElapsedTimeInSeconds());
    }

    private StyledString addElapsedTime(StyledString styledString, double time) {
        String string = styledString.getString();
        String decorated = this.addElapsedTime(string, time);
        return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.COUNTER_STYLER, (StyledString)styledString);
    }

    private String addElapsedTime(String string, double time) {
        if (!this.fShowTime || Double.isNaN(time)) {
            return string;
        }
        String formattedTime = this.timeFormat.format(time);
        return Messages.format((String)JUnitMessages.TestSessionLabelProvider_testName_elapsedTimeInSeconds, (Object[])new String[]{string, formattedTime});
    }

    private String getSimpleLabel(Object element) {
        if (element instanceof ITestCaseElement) {
            return BasicElementLabels.getJavaElementName((String)((ITestCaseElement)element).getTestMethodName());
        }
        if (element instanceof ITestSuiteElement) {
            return BasicElementLabels.getJavaElementName((String)((ITestSuiteElement)element).getSuiteTypeName());
        }
        return null;
    }

    public String getText(Object element) {
        String label = this.getSimpleLabel(element);
        if (label == null) {
            return element.toString();
        }
        ITestElement testElement = (ITestElement)element;
        if (this.fLayoutMode == 1) {
            String testKindDisplayName;
            if (testElement.getParentContainer() instanceof ITestRunSession && (testKindDisplayName = this.fTestRunnerPart.getTestKindDisplayName()) != null) {
                label = Messages.format((String)JUnitMessages.TestSessionLabelProvider_testName_JUnitVersion, (Object[])new Object[]{label, testKindDisplayName});
            }
        } else if (element instanceof ITestCaseElement) {
            String className = BasicElementLabels.getJavaElementName((String)((ITestCaseElement)element).getTestClassName());
            label = Messages.format((String)JUnitMessages.TestSessionLabelProvider_testMethodName_className, (Object[])new Object[]{label, className});
        }
        return this.addElapsedTime(label, testElement.getElapsedTimeInSeconds());
    }

    public Image getImage(Object element) {
        if (element instanceof TestCaseElement) {
            TestCaseElement testCaseElement = (TestCaseElement)element;
            if (testCaseElement.isIgnored()) {
                return this.fTestRunnerPart.fTestIgnoredIcon;
            }
            TestElement.Status status = testCaseElement.getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fTestIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fTestRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fTestErrorIcon;
            }
            if (status.isFailure()) {
                return this.fTestRunnerPart.fTestFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fTestOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        if (element instanceof TestSuiteElement) {
            TestElement.Status status = ((TestSuiteElement)element).getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fSuiteIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fSuiteRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fSuiteErrorIcon;
            }
            if (status.isFailure()) {
                return this.fTestRunnerPart.fSuiteFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fSuiteOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        throw new IllegalArgumentException(String.valueOf(element));
    }

    public void setShowTime(boolean showTime) {
        this.fShowTime = showTime;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }
}

