/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.am;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.tesla.core.am.Activator;
import org.eclipse.rcptt.tesla.core.am.AspectListener;
import org.eclipse.rcptt.tesla.core.am.BundleAspects;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class AspectManager {
    private static Map<String, List<String>> aspectBundleActivationState = new HashMap<String, List<String>>();
    private static CopyOnWriteArrayList<AspectListener> listeners = new CopyOnWriteArrayList();

    public static synchronized void activateBundle(String bundle) {
        if (!aspectBundleActivationState.containsKey(bundle)) {
            aspectBundleActivationState.put(bundle, new ArrayList());
        }
    }

    public static void activateAspect(String bundle, String aspect) {
        AspectManager.addAspect(bundle, aspect);
        if (Activator.getDefault().LOGGING) {
            System.out.println("Tesla: Activate aspect in bundle:" + bundle + " aspect:" + aspect);
        }
        for (AspectListener listener : listeners) {
            listener.activated(bundle, aspect);
        }
    }

    public static synchronized Collection<BundleAspects> getAspects() {
        ArrayList<BundleAspects> result = new ArrayList<BundleAspects>();
        for (Map.Entry<String, List<String>> e : aspectBundleActivationState.entrySet()) {
            result.add(new BundleAspects(e.getKey(), new ArrayList<String>((Collection)e.getValue())));
        }
        return result;
    }

    public static void addListener(AspectListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(AspectListener listener) {
        listeners.remove(listener);
    }

    public static void printInfo() {
        if (Activator.getDefault().LOGGING) {
            for (BundleAspects ba : AspectManager.getAspects()) {
                if (!ba.getAspects().isEmpty()) continue;
                System.out.print("Bundle: " + ba.getBundle());
                if (ba.getAspects().isEmpty()) {
                    System.out.println();
                    System.out.println("\t No Aspects are activated...");
                    continue;
                }
                System.out.println();
                for (String aspect : ba.getAspects()) {
                    System.out.println("\t" + aspect);
                }
            }
        }
    }

    public static IStatus initialize() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.rcptt.tesla.swt.aspects");
        if (bundle != null && bundle.getState() != 32) {
            try {
                bundle.start(0);
            }
            catch (BundleException e) {
                Activator.log(e);
            }
        }
        long stTime = System.currentTimeMillis();
        if (bundle != null && bundle.getState() != 32) {
            while (stTime + 50000L > System.currentTimeMillis()) {
                if (bundle.getState() != 32) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
        }
        if (bundle != null && bundle.getState() != 32) {
            Status st = new Status(4, "org.eclipse.rcptt.tesla.core.am", 700, "RCPTT aspects plugin \"org.eclipse.rcptt.tesla.swt.aspects\" could not be activated. Could not continue...", null);
            Activator.getDefault().getLog().log((IStatus)st);
            return st;
        }
        if (!AspectManager.isAspectsInitialized()) {
            Status st = new Status(4, "org.eclipse.rcptt.tesla.core.am", 700, "RCPTT aspects plugin \"org.eclipse.rcptt.tesla.swt.aspects\" is not initialized. Could not continue...", null);
            Activator.getDefault().getLog().log((IStatus)st);
            return st;
        }
        return Status.OK_STATUS;
    }

    private static synchronized void addAspect(String bundle, String aspect) {
        AspectManager.activateBundle(bundle);
        aspectBundleActivationState.get(bundle).add(aspect);
    }

    private static synchronized boolean isAspectsInitialized() {
        List<String> swtAspectBundle = aspectBundleActivationState.get("org.eclipse.rcptt.tesla.swt.aspects");
        return swtAspectBundle != null && !swtAspectBundle.isEmpty();
    }
}

