/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.rcptt.launching.internal.target.TargetPlatformHelper;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.osgi.framework.Version;

public class AUTInformation {
    public static final String VERSION = "Version";
    public static final String EMF_WORKSPACE = "EMF Workspace";
    public static final String EMF_TRANSACTION = "EMF Transaction";
    public static final String EMF_VALIDATION = "EMF Validation";
    public static final String PDE = "PDE";
    public static final String EMF = "EMF";
    public static final String GMF = "GMF";
    public static final String GEF = "GEF";
    public static final String JDT = "JDT";
    public static final String PLATFORM = "Platform";
    private static final String EMF_WORKSPACE_PLUGIN = "org.eclipse.emf.workspace";
    private static final String TESLA_PLUGIN = "org.eclipse.rcptt.tesla";
    private static final String Q7_PLUGIN = "org.eclipse.rcptt";
    private static final String PDE_PLUGIN = "org.eclipse.pde";
    private static final String EMF_VALIDATION_PLUGIN = "org.eclipse.emf.validation";
    private static final String EMF_TRANSACTION_PLUGIN = "org.eclipse.emf.transaction";
    private static final String EMF_FEATURE = "org.eclipse.emf";
    private static final String GMF_PLUGIN = "org.eclipse.gmf";
    private static final String GMF2_PLUGIN = "org.eclipse.gmf.runtime.diagram.ui";
    private static final String GEF_PLUGIN = "org.eclipse.gef";
    private static final String JDT_PLUGIN = "org.eclipse.jdt";

    public static Map<String, String> getInformationMap(ITargetPlatformHelper platform) {
        TargetPlatformHelper target = (TargetPlatformHelper)platform;
        TreeMap<String, String> values = new TreeMap<String, String>();
        if (!platform.isValid()) {
            return values;
        }
        if (target.getBundleContainers().length > 0) {
            IFeatureModel[] features;
            String version;
            BundleInfo platformBundle;
            String version2;
            BundleInfo osgiBundle;
            IResolvedBundle[] allBundles = target.getAllBundles();
            HashMap<String, BundleInfo> resolvedBundles = new HashMap<String, BundleInfo>();
            IResolvedBundle[] iResolvedBundleArray = allBundles;
            int n = allBundles.length;
            int n2 = 0;
            while (n2 < n) {
                IResolvedBundle bundle = iResolvedBundleArray[n2];
                BundleInfo bundleInfo = bundle.getBundleInfo();
                String bundleName = bundleInfo.getSymbolicName();
                resolvedBundles.put(bundleName, bundleInfo);
                if (bundleName.equals("org.eclipse.swt")) {
                    String version3 = bundleInfo.getVersion();
                    if (VersionUtil.validateVersion((String)version3).getSeverity() != 0) break;
                    Version vid = new Version(version3);
                    AUTInformation.putVersion(values, vid.getMajor(), vid.getMinor());
                    break;
                }
                if (bundleName.equals(GEF_PLUGIN)) {
                    values.put(GEF, bundle.getBundleInfo().getVersion());
                }
                if (bundleName.equals(GMF2_PLUGIN)) {
                    values.put(GMF, bundle.getBundleInfo().getVersion());
                }
                ++n2;
            }
            if ((osgiBundle = (BundleInfo)resolvedBundles.get("org.eclipse.osgi")) != null && VersionUtil.validateVersion((String)(version2 = osgiBundle.getVersion())).getSeverity() == 0) {
                Version vid = new Version(version2);
                AUTInformation.putVersionOSGI(values, vid.getMajor(), vid.getMinor());
            }
            if ((platformBundle = (BundleInfo)resolvedBundles.get("org.eclipse.platform")) != null && VersionUtil.validateVersion((String)(version = platformBundle.getVersion())).getSeverity() == 0) {
                Version vid = new Version(version);
                AUTInformation.putVersionPlatform(values, vid.getMajor(), vid.getMinor());
            }
            IFeatureModel[] iFeatureModelArray = features = target.getAllFeatures();
            int n3 = features.length;
            int n4 = 0;
            while (n4 < n3) {
                IFeatureModel feature = iFeatureModelArray[n4];
                IFeature iFeature = feature.getFeature();
                if (iFeature.getId().equals("org.eclipse.platform")) {
                    values.put(PLATFORM, iFeature.getVersion());
                }
                if (iFeature.getId().equals(EMF_FEATURE)) {
                    values.put(EMF, iFeature.getVersion());
                }
                if (iFeature.getId().equals(JDT_PLUGIN)) {
                    values.put(JDT, iFeature.getVersion());
                }
                if (iFeature.getId().equals(GEF_PLUGIN)) {
                    values.put(GEF, iFeature.getVersion());
                }
                if (iFeature.getId().equals(GMF_PLUGIN)) {
                    values.put(GMF, iFeature.getVersion());
                }
                if (iFeature.getId().equals(EMF_TRANSACTION_PLUGIN)) {
                    values.put(EMF_TRANSACTION, iFeature.getVersion());
                }
                if (iFeature.getId().equals(EMF_VALIDATION_PLUGIN)) {
                    values.put(EMF_VALIDATION, iFeature.getVersion());
                }
                if (iFeature.getId().equals(PDE_PLUGIN)) {
                    values.put(PDE, iFeature.getVersion());
                }
                if (iFeature.getId().equals(Q7_PLUGIN)) {
                    values.put("Q7", iFeature.getVersion());
                }
                if (iFeature.getId().equals(TESLA_PLUGIN)) {
                    values.put("Tesla", iFeature.getVersion());
                }
                if (iFeature.getId().equals(EMF_WORKSPACE_PLUGIN)) {
                    values.put(EMF_WORKSPACE, iFeature.getVersion());
                }
                ++n4;
            }
        }
        return values;
    }

    private static void putVersion(Map<String, String> values, int major, int minor) {
        if (major == 3 && minor == 0) {
            values.put(VERSION, "3.0");
        } else if (major == 3 && minor == 1) {
            values.put(VERSION, "3.1");
        } else if (major == 3 && minor == 2) {
            values.put(VERSION, "3.2");
        } else if (major == 3 && minor == 3) {
            values.put(VERSION, "3.3");
        } else if (major == 3 && minor == 4) {
            values.put(VERSION, "3.4");
        } else if (major == 3 && minor == 5) {
            values.put(VERSION, "3.5");
        } else if (major == 3 && minor == 6) {
            values.put(VERSION, "3.6");
        } else if (major == 3 && minor == 7) {
            values.put(VERSION, "3.7");
        } else if (major == 3 && minor == 8) {
            values.put(VERSION, "3.8");
        } else if (major == 3 && minor == 100) {
            values.put(VERSION, "4.2");
        } else if (major == 3 && minor == 102) {
            values.put(VERSION, "4.3");
        }
    }

    private static void putVersionOSGI(Map<String, String> values, int major, int minor) {
        if (major == 3 && minor == 10) {
            values.put(VERSION, "4.4");
        }
    }

    private static void putVersionPlatform(Map<String, String> values, int major, int minor) {
        if (major == 4 && minor == 4) {
            values.put(VERSION, "4.4");
        }
    }
}

