/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.util.Arrays;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class DecorationOverlayDescriptor
extends CompositeImageDescriptor {
    private ImageDescriptor base;
    private ImageDescriptor[] overlays;
    private Point size;

    public DecorationOverlayDescriptor(ImageDescriptor baseImage, ImageDescriptor[] overlaysArray, Point sizeValue) {
        this.base = baseImage;
        this.overlays = overlaysArray;
        this.size = sizeValue;
    }

    public DecorationOverlayDescriptor(ImageDescriptor baseImage, ImageDescriptor[] overlaysArray) {
        this(baseImage, overlaysArray, UIUtils.getSize(baseImage));
    }

    public DecorationOverlayDescriptor(ImageDescriptor baseImage, ImageDescriptor overlayImage, int quadrant) {
        this(baseImage, DecorationOverlayDescriptor.createArrayFrom(overlayImage, quadrant));
    }

    private static ImageDescriptor[] createArrayFrom(ImageDescriptor overlayImage, int quadrant) {
        ImageDescriptor[] descs = new ImageDescriptor[5];
        descs[quadrant] = overlayImage;
        return descs;
    }

    private void drawOverlays(ImageDescriptor[] overlaysArray) {
        int i = 0;
        while (i < this.overlays.length) {
            ImageDescriptor overlay = overlaysArray[i];
            if (overlay != null) {
                ImageData overlayData = overlay.getImageData();
                if (overlayData == null) {
                    overlayData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                }
                switch (i) {
                    case 0: {
                        this.drawImage(overlayData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(overlayData, this.size.x - overlayData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(overlayData, 0, this.size.y - overlayData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(overlayData, this.size.x - overlayData.width, this.size.y - overlayData.height);
                    }
                }
            }
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DecorationOverlayDescriptor)) {
            return false;
        }
        DecorationOverlayDescriptor other = (DecorationOverlayDescriptor)((Object)o);
        return this.base.equals(other.base) && Arrays.equals(this.overlays, other.overlays);
    }

    public int hashCode() {
        int code = System.identityHashCode(this.base);
        int i = 0;
        while (i < this.overlays.length) {
            if (this.overlays[i] != null) {
                code ^= this.overlays[i].hashCode();
            }
            ++i;
        }
        return code;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageDescriptor underlay;
        if (this.overlays.length > 4 && (underlay = this.overlays[4]) != null) {
            this.drawImage(underlay.getImageData(), 0, 0);
        }
        if (this.overlays.length > 5 && this.overlays[5] != null) {
            this.drawImage(this.overlays[5].getImageData(), 0, 0);
        } else {
            this.drawImage(this.getBaseImageData(), 0, 0);
        }
        this.drawOverlays(this.overlays);
    }

    private ImageData getBaseImageData() {
        ImageData data = this.base.getImageData();
        return data != null ? data : DEFAULT_IMAGE_DATA;
    }

    protected Point getSize() {
        return this.size;
    }

    protected int getTransparentPixel() {
        return this.getBaseImageData().transparentPixel;
    }
}

