/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.clone.AbstractGitCloneWizard;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.provisional.wizards.IRepositorySearchResult;
import org.eclipse.egit.ui.internal.provisional.wizards.NoRepositoryInfoException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.swt.widgets.Shell;

public class GitCloneWizard
extends AbstractGitCloneWizard {
    private static final String HELP_CONTEXT = "org.eclipse.egit.ui.GitCloneWizard";

    public GitCloneWizard() {
        this.initialize();
    }

    public GitCloneWizard(String presetUri) {
        super(new RepositorySelectionPage(true, presetUri));
        this.initialize();
    }

    public GitCloneWizard(IRepositorySearchResult searchResult) {
        super(searchResult);
        this.initialize();
    }

    private void initialize() {
        this.setWindowTitle(UIText.GitCloneWizard_title);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
        this.setNeedsProgressMonitor(true);
        this.validSource.setHelpContext(HELP_CONTEXT);
        this.cloneDestination.setHelpContext(HELP_CONTEXT);
    }

    public AbstractGitCloneWizard setShowProjectImport(boolean show) {
        this.cloneDestination.setShowProjectImport(show);
        return this;
    }

    public boolean performCancel() {
        File test;
        if (this.alreadyClonedInto != null && (test = new File(this.alreadyClonedInto)).exists() && MessageDialog.openQuestion((Shell)this.getShell(), (String)UIText.GitCloneWizard_abortingCloneTitle, (String)UIText.GitCloneWizard_abortingCloneMsg)) {
            try {
                FileUtils.delete((File)test, (int)3);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    protected void addPreClonePages() {
    }

    protected void addPostClonePages() {
    }

    public boolean canFinish() {
        return this.cloneDestination.isPageComplete();
    }

    public boolean performFinish() {
        try {
            boolean bl = this.performClone(this.currentSearchResult.getGitRepositoryInfo());
            return bl;
        }
        catch (URISyntaxException e) {
            Activator.error(UIText.GitImportWizard_errorParsingURI, e);
        }
        catch (NoRepositoryInfoException e) {
            Activator.error(UIText.GitImportWizard_noRepositoryInfo, e);
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
        }
        finally {
            this.setWindowTitle(UIText.GitCloneWizard_title);
        }
        return false;
    }
}

