/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.decorators.DecoratableResource;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratableResourceMapping
extends DecoratableResource {
    public static final int RESOURCE_MAPPING = 16;
    private ResourceMapping mapping;

    public DecoratableResourceMapping(ResourceMapping mapping) {
        super(null);
        this.mapping = mapping;
        IProject[] projects = mapping.getProjects();
        if (projects == null || projects.length == 0) {
            return;
        }
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IndexDiffData diffData;
            IProject prj = iProjectArray[n2];
            RepositoryMapping repoMapping = RepositoryMapping.getMapping((IResource)prj);
            if (repoMapping != null && (diffData = GitLightweightDecorator.getIndexDiffDataOrNull((IResource)prj)) != null) {
                this.tracked = true;
                String repoRelative = String.valueOf(this.makeRepoRelative(repoMapping.getRepository(), (IResource)prj)) + "/";
                Set modified = diffData.getModified();
                Set conflicting = diffData.getConflicting();
                if (this.containsPrefix(modified, repoRelative)) {
                    this.dirty = true;
                }
                if (this.containsPrefix(conflicting, repoRelative)) {
                    this.conflicts = true;
                }
            }
            ++n2;
        }
    }

    @Override
    public int getType() {
        return 16;
    }

    @Override
    public String getName() {
        if (this.mapping.getModelObject() instanceof IWorkingSet) {
            IWorkingSet ws = (IWorkingSet)this.mapping.getModelObject();
            return ws.getLabel();
        }
        return "<unknown>";
    }

    private String makeRepoRelative(Repository repository, IResource res) {
        return Repository.stripWorkDir((File)repository.getWorkTree(), (File)res.getLocation().toFile());
    }

    private boolean containsPrefix(Set<String> collection, String prefix) {
        if (prefix.length() == 1 && !collection.isEmpty()) {
            return true;
        }
        for (String path : collection) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

