/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddToIndexCommand
extends RepositoriesViewCommandHandler<FileNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        AddCommand addCommand = null;
        List selectedNodes = this.getSelectedNodes(event);
        for (Object selectedNode : selectedNodes) {
            RepositoryTreeNode node = (RepositoryTreeNode)selectedNode;
            if (addCommand == null) {
                addCommand = new Git(node.getRepository()).add();
            }
            Repository repository = node.getRepository();
            Path path = node.getType().equals((Object)RepositoryTreeNodeType.FOLDER) ? new Path(((File)((FolderNode)node).getObject()).getAbsolutePath()) : (node.getType().equals((Object)RepositoryTreeNodeType.FILE) ? new Path(((File)((FileNode)node).getObject()).getAbsolutePath()) : new Path(repository.getWorkTree().getAbsolutePath()));
            Path workTreePath = new Path(repository.getWorkTree().getAbsolutePath());
            String repoRelativepath = path.equals((Object)workTreePath) ? "." : path.removeFirstSegments(path.matchingFirstSegments((IPath)workTreePath)).setDevice(null).toString();
            addCommand.addFilepattern(repoRelativepath);
        }
        if (addCommand != null) {
            try {
                addCommand.call();
            }
            catch (NoFilepatternException e) {
                Activator.logError(UIText.AddToIndexCommand_addingFilesFailed, e);
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.enableWorkingDirCommand(evaluationContext);
    }
}

