/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public abstract class GitModelObject
extends PlatformObject {
    private final GitModelObject parent;

    public static GitModelObject createRoot(GitSynchronizeData data) throws MissingObjectException, IOException {
        return new GitModelRepository(data);
    }

    public abstract GitModelObject[] getChildren();

    public abstract String getName();

    public abstract IProject[] getProjects();

    public abstract IPath getLocation();

    public abstract boolean isContainer();

    protected GitModelObject(GitModelObject parent) {
        this.parent = parent;
    }

    public GitModelObject getParent() {
        return this.parent;
    }

    public Repository getRepository() {
        return this.parent.getRepository();
    }

    protected TreeWalk createTreeWalk() {
        Repository repo = this.getRepository();
        TreeWalk tw = new TreeWalk(repo);
        tw.reset();
        tw.setRecursive(false);
        tw.setFilter(TreeFilter.ANY_DIFF);
        return tw;
    }
}

