/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.pde.api.tools.internal.model.ApiMember;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ApiField
extends ApiMember
implements IApiField {
    private Object fValue;
    private IFieldDescriptor fHandle;

    protected ApiField(IApiType enclosing, String name, String signature, String genericSig, int flags, Object value) {
        super(enclosing, name, signature, genericSig, 5, flags);
        this.fValue = value;
    }

    public boolean isEnumConstant() {
        return Flags.isEnum((int)this.getModifiers());
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiField) {
            return super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + (this.fValue != null ? this.fValue.hashCode() : 0);
    }

    public Object getConstantValue() {
        return this.fValue;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Field : access(").append(this.getModifiers()).append(") ").append(this.getSignature()).append(' ').append(this.getName()).append(" isEnum constant ").append(this.isEnumConstant());
        if (this.getConstantValue() != null) {
            buffer.append(" = ").append(this.getConstantValue());
        }
        buffer.append(';').append(Util.LINE_DELIMITER);
        if (this.getGenericSignature() != null) {
            buffer.append(" Signature : ").append(this.getGenericSignature()).append(Util.LINE_DELIMITER);
        }
        return String.valueOf(buffer);
    }

    public IMemberDescriptor getHandle() {
        if (this.fHandle == null) {
            try {
                IApiType type = this.getEnclosingType();
                this.fHandle = ((IReferenceTypeDescriptor)type.getHandle()).getField(this.getName());
            }
            catch (CoreException coreException) {}
        }
        return this.fHandle;
    }
}

