/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.team.core.history.IFileRevision;

public class WorkingTreeFileRevision
extends GitFileRevision
implements IFileRevision {
    private final File file;

    public WorkingTreeFileRevision(File file) {
        super(file.getName());
        this.file = file;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        return new IStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return true;
            }

            public String getName() {
                return WorkingTreeFileRevision.this.file.getName();
            }

            public IPath getFullPath() {
                return new Path(WorkingTreeFileRevision.this.file.getAbsolutePath());
            }

            public InputStream getContents() throws CoreException {
                try {
                    return new FileInputStream(WorkingTreeFileRevision.this.file);
                }
                catch (FileNotFoundException e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
            }
        };
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public String getAuthor() {
        return "";
    }

    public long getTimestamp() {
        return -1L;
    }

    public String getComment() {
        return "";
    }

    public String getContentIdentifier() {
        return "Working Tree";
    }
}

