/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.debug.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VariableKind implements Enumerator
{
    VARIABLE(0, "Variable", "Variable"),
    COMMAND(1, "Command", "Command"),
    LOCAL(2, "Local", "Local"),
    ARGUMENT(4, "Argument", "Argument"),
    OBJECT(5, "Object", "Object"),
    FIELD(6, "Field", "Field"),
    REFERENCE(7, "Reference", "Reference");

    public static final int VARIABLE_VALUE = 0;
    public static final int COMMAND_VALUE = 1;
    public static final int LOCAL_VALUE = 2;
    public static final int ARGUMENT_VALUE = 4;
    public static final int OBJECT_VALUE = 5;
    public static final int FIELD_VALUE = 6;
    public static final int REFERENCE_VALUE = 7;
    private static final VariableKind[] VALUES_ARRAY;
    public static final List<VariableKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariableKind[]{VARIABLE, COMMAND, LOCAL, ARGUMENT, OBJECT, FIELD, REFERENCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariableKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariableKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariableKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariableKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariableKind get(int value) {
        switch (value) {
            case 0: {
                return VARIABLE;
            }
            case 1: {
                return COMMAND;
            }
            case 2: {
                return LOCAL;
            }
            case 4: {
                return ARGUMENT;
            }
            case 5: {
                return OBJECT;
            }
            case 6: {
                return FIELD;
            }
            case 7: {
                return REFERENCE;
            }
        }
        return null;
    }

    private VariableKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

