/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mirror.util;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.Modifier;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationFilter {
    public static final DeclarationFilter FILTER_PUBLIC = new AccessFilter(Modifier.PUBLIC);
    public static final DeclarationFilter FILTER_PROTECTED = new AccessFilter(Modifier.PROTECTED);
    public static final DeclarationFilter FILTER_PUBLIC_OR_PROTECTED = new AccessFilter(Modifier.PUBLIC, Modifier.PROTECTED);
    public static final DeclarationFilter FILTER_PACKAGE = new AccessFilter();
    public static final DeclarationFilter FILTER_PRIVATE = new AccessFilter(Modifier.PRIVATE);

    public static DeclarationFilter getFilter(final Collection<Modifier> mods) {
        return new DeclarationFilter(){

            public boolean matches(Declaration d) {
                return d.getModifiers().containsAll(mods);
            }
        };
    }

    public static DeclarationFilter getFilter(final Class<? extends Declaration> kind) {
        return new DeclarationFilter(){

            public boolean matches(Declaration d) {
                return kind.isInstance(d);
            }
        };
    }

    public DeclarationFilter and(DeclarationFilter f) {
        final DeclarationFilter f1 = this;
        final DeclarationFilter f2 = f;
        return new DeclarationFilter(){

            public boolean matches(Declaration d) {
                return f1.matches(d) && f2.matches(d);
            }
        };
    }

    public DeclarationFilter or(DeclarationFilter f) {
        final DeclarationFilter f1 = this;
        final DeclarationFilter f2 = f;
        return new DeclarationFilter(){

            public boolean matches(Declaration d) {
                return f1.matches(d) || f2.matches(d);
            }
        };
    }

    public DeclarationFilter not() {
        return new DeclarationFilter(){

            public boolean matches(Declaration d) {
                return !DeclarationFilter.this.matches(d);
            }
        };
    }

    public boolean matches(Declaration decl) {
        return true;
    }

    public <D extends Declaration> Collection<D> filter(Collection<D> decls) {
        ArrayList<Declaration> res = new ArrayList<Declaration>(decls.size());
        for (Declaration d : decls) {
            if (!this.matches(d)) continue;
            res.add(d);
        }
        return res;
    }

    public <D extends Declaration> Collection<D> filter(Collection<? extends Declaration> decls, Class<D> resType) {
        ArrayList<Declaration> res = new ArrayList<Declaration>(decls.size());
        for (Declaration declaration : decls) {
            if (!resType.isInstance(declaration) || !this.matches(declaration)) continue;
            res.add((Declaration)resType.cast(declaration));
        }
        return res;
    }

    private static class AccessFilter
    extends DeclarationFilter {
        private Modifier mod1 = null;
        private Modifier mod2 = null;

        AccessFilter() {
        }

        AccessFilter(Modifier m) {
            this.mod1 = m;
        }

        AccessFilter(Modifier m1, Modifier m2) {
            this.mod1 = m1;
            this.mod2 = m2;
        }

        public boolean matches(Declaration d) {
            Collection<Modifier> mods = d.getModifiers();
            if (this.mod1 == null) {
                return !mods.contains((Object)Modifier.PUBLIC) && !mods.contains((Object)Modifier.PROTECTED) && !mods.contains((Object)Modifier.PRIVATE);
            }
            return mods.contains((Object)this.mod1) && (this.mod2 == null || mods.contains((Object)this.mod2));
        }
    }
}

