/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding;

import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;

public class EMFUpdateListStrategy
extends UpdateListStrategy {
    public EMFUpdateListStrategy() {
        this(true, POLICY_UPDATE);
    }

    public EMFUpdateListStrategy(int updatePolicy) {
        this(true, updatePolicy);
    }

    public EMFUpdateListStrategy(boolean provideDefaults, int updatePolicy) {
        super(provideDefaults, updatePolicy);
    }

    protected IConverter createConverter(Object fromType, Object toType) {
        if (fromType == String.class) {
            if (toType instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)toType;
                final EDataType eDataType = eAttribute.getEAttributeType();
                final EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                return new Converter(fromType, toType){

                    public Object convert(Object fromObject) {
                        return eFactory.createFromString(eDataType, (String)fromObject);
                    }
                };
            }
        } else if (toType == String.class && fromType instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)fromType;
            final EDataType eDataType = eAttribute.getEAttributeType();
            final EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            return new Converter(fromType, toType){

                public Object convert(Object fromObject) {
                    return eFactory.convertToString(eDataType, fromObject);
                }
            };
        }
        return super.createConverter(fromType, toType);
    }
}

