/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.filesystem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.ctx.filesystem.FileSystemResolver;
import org.eclipse.rcptt.ctx.filesystem.FilesystemContextPlugin;
import org.eclipse.rcptt.filesystem.FSFile;
import org.eclipse.rcptt.filesystem.FSFolder;
import org.eclipse.rcptt.filesystem.FSResource;
import org.eclipse.rcptt.filesystem.FilesystemContext;
import org.eclipse.rcptt.filesystem.FilesystemFactory;
import org.eclipse.rcptt.util.FileUtil;

public class FSUtils {
    private static final FilesystemFactory factory = FilesystemFactory.eINSTANCE;
    private static final FSFile[] EMPTY_FILES = new FSFile[0];

    public static void apply(FilesystemContext context, FileSystemResolver resolver) throws CoreException {
        String path = context.getPath();
        if (path == null) {
            path = "";
        }
        if (path.equals("workspace://")) {
            throw new CoreException(FilesystemContextPlugin.createErr("Cannot clear entire workspace. Please use workspace context for that purpose.", new Object[0]));
        }
        if (path.equals("home://")) {
            throw new CoreException(FilesystemContextPlugin.createErr("Cannot clear user's home directory. Please use more detailed root path.", new Object[0]));
        }
        String resolved = resolver.resolve(path);
        if (resolved == null) {
            resolved = path;
        }
        try {
            File filePath = new File(resolved);
            if (context.isClear() && filePath.exists()) {
                if (filePath.isDirectory()) {
                    FileUtil.deleteFile((File)filePath, (boolean)false);
                }
                if (filePath.exists() && (filePath.isFile() || filePath.isDirectory() && filePath.listFiles().length > 0)) {
                    throw new CoreException(FilesystemContextPlugin.createErr("Unable to clear '%s'", resolved));
                }
            }
            if (!filePath.exists() && !filePath.mkdirs()) {
                throw new CoreException(FilesystemContextPlugin.createErr("Unable to create '%s'", resolved));
            }
            if (context.getRoot() != null) {
                FSUtils.apply(context.getRoot(), filePath);
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(FilesystemContextPlugin.createErr(e, "Error while applying '%s'", resolved));
        }
    }

    private static void apply(FSFolder folder, File path) throws CoreException {
        try {
            for (FSResource f : folder.getFiles()) {
                File filePath = new File(path, f.getName());
                if (!filePath.exists() && !filePath.createNewFile() || !filePath.isFile()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.filesystem", "Unable to create " + filePath));
                }
                FSUtils.save((FSFile)f, filePath);
            }
            for (FSResource f : folder.getFolders()) {
                File folderPath = new File(path, f.getName());
                if (!folderPath.exists() && !folderPath.mkdirs() || !folderPath.isDirectory()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.filesystem", "Unable to create " + folderPath));
                }
                FSUtils.apply((FSFolder)f, folderPath);
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.filesystem", "Error while applying " + path.toString(), (Throwable)e));
        }
    }

    public static void capture(FilesystemContext context, String path, FileSystemResolver resolver) throws CoreException {
        if (path == null) {
            path = "";
        }
        FSFolder root = factory.createFSFolder();
        String resolved = resolver.resolve(path);
        if (resolved == null) {
            resolved = path;
        }
        FSUtils.capture(root, new File(resolved));
        context.setRoot(root);
    }

    public static FSFile[] addFiles(FSFolder parent, File[] files) throws CoreException {
        String parentName = parent.getName() == null ? "Context" : parent.getName();
        File duplicate = FSUtils.findFirstDuplicate(files);
        if (duplicate != null) {
            throw new CoreException(FilesystemContextPlugin.createErr("Name collision detected: '%s'", duplicate.getName()));
        }
        ArrayList<FSFile> result = new ArrayList<FSFile>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (FSUtils.findResource(f.getName(), parent) != null) {
                throw new CoreException(FilesystemContextPlugin.createErr("%s already contains file '%s'", parentName, f.getName()));
            }
            FSFile file = factory.createFSFile();
            file.setName(f.getName());
            FSUtils.load(file, f);
            parent.getFiles().add((Object)file);
            result.add(file);
            ++n2;
        }
        return result.toArray(EMPTY_FILES);
    }

    public static FSResource findResource(String name, FSFolder folder) {
        for (FSResource r : folder.getFolders()) {
            if (!r.getName().equalsIgnoreCase(name)) continue;
            return r;
        }
        for (FSResource r : folder.getFiles()) {
            if (!r.getName().equalsIgnoreCase(name)) continue;
            return r;
        }
        return null;
    }

    public static FSFolder addFolder(FSFolder parent, String path) throws CoreException {
        String parentName;
        File folderPath = new File(path);
        String name = folderPath.getName();
        String string = parentName = parent.getName() == null ? "Context" : parent.getName();
        if (FSUtils.findResource(folderPath.getName(), parent) != null) {
            throw new CoreException(FilesystemContextPlugin.createErr("%s already contains folder '%s'", parentName, name));
        }
        FSFolder newFolder = factory.createFSFolder();
        newFolder.setName(folderPath.getName());
        FSUtils.capture(newFolder, folderPath);
        parent.getFolders().add((Object)newFolder);
        return newFolder;
    }

    public static void remove(FSResource resource) {
        EReference ref = resource.eContainmentFeature();
        List list = (List)resource.eContainer().eGet((EStructuralFeature)ref);
        list.remove(resource);
    }

    private static File findFirstDuplicate(File[] list) {
        HashSet<String> members = new HashSet<String>();
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!members.add(f.getName().toLowerCase())) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    private static void capture(FSFolder folder, File path) throws CoreException {
        try {
            if (!path.exists() || !path.isDirectory()) {
                throw new CoreException(FilesystemContextPlugin.createErr("Directory '%s' does not exist", path.getAbsolutePath()));
            }
            File[] files = path.listFiles();
            if (files == null) {
                return;
            }
            File duplicate = FSUtils.findFirstDuplicate(files);
            if (duplicate != null) {
                throw new CoreException(FilesystemContextPlugin.createErr("Name collision detected: '%s'", duplicate.getName()));
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    FSFolder newFolder = factory.createFSFolder();
                    newFolder.setName(f.getName());
                    FSUtils.capture(newFolder, f);
                    folder.getFolders().add((Object)newFolder);
                } else if (f.isFile()) {
                    FSFile newFile = factory.createFSFile();
                    newFile.setName(f.getName());
                    FSUtils.load(newFile, f);
                    folder.getFiles().add((Object)newFile);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(FilesystemContextPlugin.createErr(e, "Error while capturing '%s':\n\n%s", path.getAbsolutePath(), e.getMessage()));
        }
    }

    private static void save(FSFile f, File file) throws FileNotFoundException, IOException {
        byte[] data = f.getData();
        if (data != null) {
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
            stream.write(data, 0, data.length);
            stream.close();
        }
    }

    private static void load(FSFile file, File path) throws CoreException {
        if (!path.exists()) {
            throw new CoreException(FilesystemContextPlugin.createErr("File '%s' does not exist", path.getAbsolutePath()));
        }
        try {
            file.setData(FSUtils.getStreamContent(new BufferedInputStream(new FileInputStream(path))));
        }
        catch (IOException iOException) {
            throw new CoreException(FilesystemContextPlugin.createErr("Error reading file '%s'", path.getAbsolutePath()));
        }
    }

    private static byte[] getStreamContent(InputStream stream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = stream.read(buffer)) > 0) {
                output.write(buffer, 0, len);
            }
        }
        finally {
            FSUtils.safeClose(stream);
        }
        return output.toByteArray();
    }

    private static void safeClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {}
    }
}

