/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.Q7Statistics;
import org.eclipse.rcptt.reporting.core.Q7ReportIterator;
import org.eclipse.rcptt.reporting.internal.Q7ReportingPlugin;
import org.eclipse.rcptt.reporting.internal.ReportUtils;
import org.eclipse.rcptt.reporting.internal.XMLUtils;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.EventSource;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLReportGenerator {
    private Document newDocument;
    private Report report;

    public String generateContent(Report report) throws CoreException {
        this.report = report;
        this.newDocument = XMLUtils.createDocument();
        Node nodes = report.getRoot();
        Element rootElement = this.newDocument.createElement("node");
        this.newDocument.appendChild(rootElement);
        EList sources = report.getSources();
        for (EventSource source : sources) {
            Element cElement = this.newDocument.createElement("eventSource");
            cElement.setAttribute("name", source.getName());
            this.processAttributes(cElement, (EMap<String, EObject>)source.getProperties());
            int val = sources.indexOf((Object)source);
            cElement.setAttribute("index", Integer.toString(val));
            rootElement.appendChild(cElement);
        }
        this.processAttributes(rootElement, (EMap<String, EObject>)nodes.getProperties());
        rootElement.setAttribute("name", this.getCombinedVariantName(nodes));
        EList children = nodes.getChildren();
        for (Node node : children) {
            this.printNode(node, rootElement);
        }
        return XMLUtils.toString(this.newDocument);
    }

    private void processAttributes(Element cElement, EMap<String, EObject> list) {
        for (String key : list.keySet()) {
            EObject obj = (EObject)list.get((Object)key);
            if (obj instanceof Q7Info) {
                this.toStringAttrs(cElement, obj, "", new String[0]);
                continue;
            }
            if (obj instanceof Q7Statistics) {
                this.toStringAttrs(cElement, obj, "", new String[0]);
                continue;
            }
            this.toString(cElement, obj, new String[0]);
        }
    }

    private String getCombinedVariantName(Node node) {
        Q7Info info = (Q7Info)node.getProperties().get((Object)"q7");
        String name = info != null && info.getVariant() != null && info.getVariant().size() != 0 ? String.valueOf(node.getName()) + "_" + ReportUtils.combineNames(info.getVariant(), "_") : node.getName();
        return name;
    }

    private void printNode(Node infoNode, Element element) {
        Element childrenElement;
        Element nodeElement = this.newDocument.createElement("node");
        element.appendChild(nodeElement);
        nodeElement.setAttribute("name", this.getCombinedVariantName(infoNode));
        nodeElement.setAttribute("totalTime", Long.toString(infoNode.getEndTime() - infoNode.getStartTime()));
        this.processAttributes(nodeElement, (EMap<String, EObject>)infoNode.getProperties());
        if (!infoNode.getChildren().isEmpty()) {
            for (Node child : infoNode.getChildren()) {
                this.printNode(child, nodeElement);
            }
        }
        if (!infoNode.getEvents().isEmpty()) {
            childrenElement = this.newDocument.createElement("events");
            nodeElement.appendChild(childrenElement);
            for (Event child : infoNode.getEvents()) {
                this.printEvent(child, childrenElement);
            }
        }
        if (!infoNode.getSnapshots().isEmpty()) {
            childrenElement = this.newDocument.createElement("snapshots");
            nodeElement.appendChild(childrenElement);
            for (Event child : infoNode.getSnapshots()) {
                this.printSnapshot((Snaphot)child, childrenElement);
            }
        }
    }

    private void printEvent(Event child, Element childrenElement) {
        Element eventElement = this.newDocument.createElement("event");
        childrenElement.appendChild(eventElement);
        eventElement.setAttribute("time", Long.toString(child.getTime()));
        if (child.getSource() != null) {
            eventElement.setAttribute("source", Integer.toString(this.report.getSources().indexOf((Object)child.getSource())));
        }
        if (child.getKind() != null) {
            eventElement.setAttribute("kind", child.getKind().name());
        }
        if (child.getColor() != null) {
            eventElement.setAttribute("color", child.getColor());
        }
        this.processAttributes(eventElement, (EMap<String, EObject>)child.getProperties());
        if (child.getData() != null) {
            this.toString(eventElement, child.getData(), new String[0]);
        }
    }

    private void printSnapshot(Snaphot child, Element element) {
        Element e = this.newDocument.createElement("snapshot");
        element.appendChild(e);
        this.processAttributes(e, (EMap<String, EObject>)child.getProperties());
        if (child.getData() != null) {
            this.toString(e, child.getData(), new String[0]);
        }
    }

    public void toString(Element element, EObject obj, String ... ignores) {
        Object e;
        String ignore;
        if (obj == null) {
            return;
        }
        EClass eClass = obj.eClass();
        Element eobjElement = this.newDocument.createElement("eobject");
        element.appendChild(eobjElement);
        eobjElement.setAttribute("class", eClass.getName());
        EList eAllAttributes = eClass.getEAllAttributes();
        for (EAttribute eAttribute : eAllAttributes) {
            Object eGet = obj.eGet((EStructuralFeature)eAttribute);
            if (eGet == null) continue;
            boolean needArg = true;
            Object defaultValue = eAttribute.getDefaultValue();
            boolean bl = needArg = defaultValue == null || !defaultValue.equals(eGet);
            if (eGet instanceof List && ((List)eGet).size() == 0) {
                needArg = false;
            }
            String[] stringArray = ignores;
            int n = ignores.length;
            int n2 = 0;
            while (n2 < n) {
                ignore = stringArray[n2];
                if (ignore.equals(eAttribute.getName())) {
                    needArg = false;
                    break;
                }
                ++n2;
            }
            if (!needArg) continue;
            if (eGet instanceof List) {
                for (Object o : (List)eGet) {
                    Element ee = this.newDocument.createElement(eAttribute.getName());
                    eobjElement.appendChild(ee);
                    e = this.newDocument.createTextNode(o.toString());
                    ee.appendChild((org.w3c.dom.Node)e);
                }
                continue;
            }
            eobjElement.setAttribute(eAttribute.getName(), eGet.toString());
        }
        EList features = eClass.getEAllReferences();
        for (EReference f : features) {
            Object eGet = obj.eGet((EStructuralFeature)f);
            boolean needArg = true;
            e = ignores;
            int ee = ignores.length;
            int n = 0;
            while (n < ee) {
                ignore = e[n];
                if (ignore.equals(f.getName())) {
                    needArg = false;
                    break;
                }
                ++n;
            }
            if (!needArg || eGet == null || !needArg) continue;
            Element e2 = this.newDocument.createElement(f.getName());
            eobjElement.appendChild(e2);
            if (eGet instanceof EObject) {
                this.toString(e2, (EObject)eGet, "eFactoryInstance");
                continue;
            }
            if (!(eGet instanceof EList)) continue;
            EList l = (EList)eGet;
            int i = 0;
            while (i < l.size()) {
                Object va = l.get(i);
                if (va instanceof EObject) {
                    this.toString(e2, (EObject)va, "eFactoryInstance");
                }
                ++i;
            }
        }
    }

    public void toStringAttrs(Element element, EObject obj, String prefix, String ... ignores) {
        if (obj == null) {
            return;
        }
        EClass eClass = obj.eClass();
        EList eAllAttributes = eClass.getEAllAttributes();
        for (EAttribute eAttribute : eAllAttributes) {
            Object eGet = obj.eGet((EStructuralFeature)eAttribute);
            if (eGet == null) continue;
            boolean needArg = true;
            Object defaultValue = eAttribute.getDefaultValue();
            boolean bl = needArg = defaultValue == null || !defaultValue.equals(eGet);
            if (eGet instanceof List && ((List)eGet).size() == 0) {
                needArg = false;
            }
            String[] stringArray = ignores;
            int n = ignores.length;
            int n2 = 0;
            while (n2 < n) {
                String ignore = stringArray[n2];
                if (ignore.equals(eAttribute.getName())) {
                    needArg = false;
                    break;
                }
                ++n2;
            }
            if (!needArg || eGet instanceof List) continue;
            element.setAttribute(String.valueOf(prefix) + eAttribute.getName(), eGet.toString());
        }
    }

    public void generateContent(OutputStream stream, String reportName, Q7ReportIterator report, Q7Statistics statistics) throws CoreException {
        try {
            stream.write(StringUtils.getUtf8Bytes((String)"<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n"));
            stream.write(StringUtils.getUtf8Bytes((String)String.format("<report name=\"%s\">", reportName)));
            report.reset();
            while (report.hasNext()) {
                Report r = report.next();
                String s = this.generateContent(r);
                int pos = s.indexOf("?>");
                s = s.substring(pos + 2);
                stream.write(StringUtils.getUtf8Bytes((String)s));
            }
            stream.write(StringUtils.getUtf8Bytes((String)"\n</report>"));
        }
        catch (IOException e) {
            Q7ReportingPlugin.log(e);
        }
    }
}

