/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.JDTUtils;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.internal.launching.ext.ui.Activator;
import org.eclipse.rcptt.internal.launching.ext.ui.SyncProgressMonitor;
import org.eclipse.rcptt.internal.launching.ext.ui.TimeTriggeredProgressMonitorDialog;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutLaunchState;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.eclipse.rcptt.ui.commons.SWTFactory;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.UIJob;

public class NewAUTPage
extends WizardPage {
    private static final int FIELD_TIMEOUT = 500;
    private DataBindingContext dbc = new DataBindingContext();
    private Shell shell;
    private WritableValue nameValue = new WritableValue((Object)"", String.class);
    private WritableValue locationValue = new WritableValue((Object)"", String.class);
    private WritableValue info = new WritableValue(null, ITargetPlatformHelper.class);
    private WritableValue platformArchitecture64 = new WritableValue((Object)Boolean.FALSE, Boolean.class);
    private WritableValue platformArchitecture32 = new WritableValue((Object)Boolean.TRUE, Boolean.class);
    private WritableValue architectureError = new WritableValue((Object)Boolean.FALSE, Boolean.class);
    private WritableValue archEnabled = new WritableValue((Object)Boolean.TRUE, Boolean.class);
    private WritableValue showAdvanced = new WritableValue((Object)Boolean.FALSE, Boolean.class);
    private WritableValue detailsValue = new WritableValue((Object)"", String.class);
    private WritableValue warningMessageValue = new WritableValue((Object)"", String.class);
    private String JobFamily = "";
    private OSArchitecture architecture;
    private IVMInstall jvmInstall;
    private OSArchitecture jvmArch;
    private String currentName = null;
    private Runnable advancedHandler;
    private IObservableValue delayedName;
    private ISWTObservableValue locationModifyObservable;
    private ISWTObservableValue nameModifyObservable;

    protected NewAUTPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void validate(boolean clean) {
        this.setErrorMessage(null);
        this.setMessage(null);
        final String location = (String)this.locationValue.getValue();
        if (location.trim().length() == 0) {
            this.setErrorMessage("Please specify your Eclipse application installation directory.");
            this.setPageComplete(false);
            this.archEnabled.setValue((Object)Boolean.FALSE);
            return;
        }
        ITargetPlatformHelper helper = (ITargetPlatformHelper)this.info.getValue();
        if (clean) {
            if (helper != null) {
                helper.delete();
            }
            this.runInDialog(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Validate AUT", 100);
                    TargetPlatformManager.clearTargets();
                    final ITargetPlatformHelper platform = Q7TargetPlatformManager.createTargetPlatform((String)location, (IProgressMonitor)monitor, (boolean)false);
                    if (!monitor.isCanceled()) {
                        NewAUTPage.this.shell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                NewAUTPage.this.info.setValue((Object)platform);
                            }
                        });
                    }
                }
            });
        } else if (helper != null) {
            this.validatePlatform();
        }
    }

    private void validatePlatform() {
        String defaultProduct;
        ITargetPlatformHelper helper = (ITargetPlatformHelper)this.info.getValue();
        if (helper == null) {
            this.archEnabled.setValue((Object)Boolean.FALSE);
            this.setErrorMessage("Please specify correct Application installation directory...");
            this.setPageComplete(false);
            return;
        }
        if (!helper.isValid()) {
            this.archEnabled.setValue((Object)Boolean.FALSE);
            this.setErrorMessage(helper.getErrorMessage());
            this.setPageComplete(false);
            return;
        }
        this.setMessage(helper.getWarningMessage());
        this.setErrorMessage(null);
        if (((String)this.nameValue.getValue()).trim().length() == 0 && (defaultProduct = helper.getDefaultProduct()) != null) {
            this.nameValue.setValue((Object)helper.getDefaultProduct());
            int i = 2;
            while (!this.validateAUTName()) {
                this.nameValue.setValue((Object)(String.valueOf(helper.getDefaultProduct()) + Integer.toString(i)));
                ++i;
            }
        }
        StringBuilder builder = new StringBuilder();
        this.architecture = helper.detectArchitecture(false, new StringBuilder());
        builder.append("name:").append(this.architecture).append("\n");
        switch (this.architecture) {
            case Unknown: {
                this.archEnabled.setValue((Object)Boolean.TRUE);
                if (Boolean.TRUE.equals(this.platformArchitecture32.getValue())) {
                    this.architecture = OSArchitecture.x86;
                    break;
                }
                this.architecture = OSArchitecture.x86_64;
                break;
            }
            case x86: {
                this.archEnabled.setValue((Object)Boolean.FALSE);
                this.platformArchitecture32.setValue((Object)Boolean.TRUE);
                this.platformArchitecture64.setValue((Object)Boolean.FALSE);
                break;
            }
            case x86_64: {
                this.archEnabled.setValue((Object)Boolean.FALSE);
                this.platformArchitecture32.setValue((Object)Boolean.FALSE);
                this.platformArchitecture64.setValue((Object)Boolean.TRUE);
            }
        }
        boolean haveArch = this.findJVM();
        if (!haveArch) {
            try {
                JDTUtils.registerCurrentJVM();
                haveArch = this.findJVM();
            }
            catch (CoreException e) {
                Q7UIPlugin.log((Throwable)e);
            }
        }
        this.architectureError.setValue((Object)(!haveArch ? 1 : 0));
        if (!haveArch) {
            this.setPageComplete(false);
            this.setErrorMessage("The selected AUT requires " + (OSArchitecture.x86.equals((Object)this.architecture) ? "32 bit" : "64 bit") + " Java VM which cannot be found.");
            return;
        }
        this.detailsValue.setValue((Object)builder.toString());
        if (this.validateAUTName()) {
            this.setPageComplete(true);
        }
    }

    private boolean findJVM() {
        boolean haveArch = false;
        if (!this.architecture.equals((Object)OSArchitecture.Unknown)) {
            IVMInstallType[] types;
            IVMInstallType[] iVMInstallTypeArray = types = JavaRuntime.getVMInstallTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall[] installs;
                IVMInstallType ivmInstallType = iVMInstallTypeArray[n2];
                IVMInstall[] iVMInstallArray = installs = ivmInstallType.getVMInstalls();
                int n3 = installs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVMInstall ivmInstall = iVMInstallArray[n4];
                    this.jvmArch = JDTUtils.detect((IVMInstall)ivmInstall);
                    if (this.jvmArch != null && (this.jvmArch.equals((Object)this.architecture) || this.jvmArch.equals((Object)OSArchitecture.x86_64) && JDTUtils.canRun32bit((IVMInstall)ivmInstall))) {
                        this.jvmInstall = ivmInstall;
                        haveArch = true;
                        break;
                    }
                    ++n4;
                }
                if (haveArch) break;
                ++n2;
            }
        }
        return haveArch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateAUTName() {
        String name = ((String)this.nameValue.getValue()).trim();
        if (name.length() == 0) {
            this.setErrorMessage("The name of Application Under Test (AUT) can not be empty.");
            this.setPageComplete(false);
            this.archEnabled.setValue((Object)Boolean.FALSE);
            return false;
        }
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (FileUtil.isInvalidFileNameChar((char)c)) {
                this.setErrorMessage("Symbol \"" + c + "\" is not acceptable in AUT name.");
                this.setPageComplete(false);
                this.archEnabled.setValue((Object)Boolean.FALSE);
                return false;
            }
            ++n2;
        }
        if (this.currentName != null && this.currentName.equals(name)) {
            return true;
        }
        try {
            ILaunchConfiguration[] configurations;
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.rcptt.launching.ext");
            ILaunchConfiguration[] iLaunchConfigurationArray = configurations = launchManager.getLaunchConfigurations(type);
            int n3 = configurations.length;
            int n4 = 0;
            while (true) {
                if (n4 >= n3) {
                    return true;
                }
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n4];
                if (name.equals(iLaunchConfiguration.getName())) {
                    this.setErrorMessage(MessageFormat.format("Application {0} already exists. Please specify a different name.", name));
                    this.archEnabled.setValue((Object)Boolean.FALSE);
                    this.setPageComplete(false);
                    return false;
                }
                ++n4;
            }
        }
        catch (Throwable e) {
            Q7UIPlugin.log((Throwable)e);
        }
        return true;
    }

    private Job runInDialog(final IRunnableWithProgress run) {
        Job.getJobManager().cancel((Object)this.JobFamily);
        UIJob myJob = new UIJob("Validate install location"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                final TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(NewAUTPage.this.shell, 500);
                try {
                    dialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            run.run((IProgressMonitor)new SyncProgressMonitor(monitor, dialog.getShell().getDisplay()));
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Activator.log(e);
                }
                catch (InterruptedException e) {
                    Activator.log(e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return NewAUTPage.this.JobFamily.equals(family);
            }
        };
        myJob.schedule();
        return myJob;
    }

    public void createControl(Composite sparent) {
        this.initializeDialogUnits((Control)sparent);
        this.shell = sparent.getShell();
        Composite parent = new Composite(sparent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        Label l = new Label(parent, 0);
        l.setText("Location:");
        Text locationField = new Text(parent, 2048);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).hint(200, -1).applyTo((Control)locationField);
        this.locationModifyObservable = SWTObservables.observeText((Control)locationField, (int)24);
        this.locationModifyObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NewAUTPage.this.setPageComplete(false);
            }
        });
        this.dbc.bindValue(Observables.observeDelayedValue((int)500, (IObservableValue)this.locationModifyObservable), (IObservableValue)this.locationValue);
        Button fileLocationButton = new Button(parent, 8);
        fileLocationButton.setText("&Browse...");
        fileLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewAUTPage.this.handleSelectLocation();
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)fileLocationButton);
        SWTFactory.setButtonDimensionHint((Button)fileLocationButton);
        l = new Label(parent, 0);
        l.setText("Name:");
        Text nameField = new Text(parent, 2048);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).hint(200, -1).span(2, 1).applyTo((Control)nameField);
        this.nameModifyObservable = SWTObservables.observeText((Control)nameField, (int)24);
        this.nameModifyObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NewAUTPage.this.setPageComplete(false);
            }
        });
        this.delayedName = Observables.observeDelayedValue((int)500, (IObservableValue)this.nameModifyObservable);
        this.dbc.bindValue(this.delayedName, (IObservableValue)this.nameValue);
        l = new Label(parent, 0);
        l.setText("Architecture:");
        Composite archGroup = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(archGroup);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)archGroup);
        Button b32 = new Button(archGroup, 16);
        Button b64 = new Button(archGroup, 16);
        b32.setText("32bit");
        b64.setText("64bit");
        this.dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)b32), (IObservableValue)this.archEnabled);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)b64), (IObservableValue)this.archEnabled);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)b64), (IObservableValue)this.platformArchitecture64);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)b32), (IObservableValue)this.platformArchitecture32);
        Link link = new Link(parent, 4);
        link.setText("There is no appropriate JVM configured. <a>Configure JVM...</a>");
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)NewAUTPage.this.shell, (String)"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", (String[])new String[]{"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage"}, null);
                if (dialog.open() == 0) {
                    NewAUTPage.this.validatePlatform();
                }
            }
        });
        Link advanced = new Link(parent, 4);
        advanced.setText("<a>Advanced...</a>");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)advanced);
        advanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewAUTPage.this.advancedHandler != null) {
                    NewAUTPage.this.advancedHandler.run();
                }
            }
        });
        Label warning = new Label(parent, 64);
        warning.setText("");
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)warning);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)warning), (IObservableValue)this.warningMessageValue);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeVisible((Control)advanced), (IObservableValue)this.showAdvanced);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeVisible((Control)link), (IObservableValue)this.architectureError);
        this.locationValue.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NewAUTPage.this.validate(true);
            }
        });
        IChangeListener validatePlatformListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NewAUTPage.this.validatePlatform();
            }
        };
        this.nameValue.addChangeListener(validatePlatformListener);
        this.info.addChangeListener(validatePlatformListener);
        this.platformArchitecture32.addChangeListener(validatePlatformListener);
        this.platformArchitecture64.addChangeListener(validatePlatformListener);
        this.setControl((Control)parent);
        this.validate(this.info.getValue() == null);
        Dialog.applyDialogFont((Control)parent);
    }

    protected void handleSelectLocation() {
        DirectoryDialog fileDialog = new DirectoryDialog(this.shell, 0);
        fileDialog.setFilterPath((String)this.locationValue.getValue());
        String text = fileDialog.open();
        if (text != null) {
            this.locationValue.setValue((Object)text);
        }
    }

    public ITargetPlatformHelper getTarget() {
        return (ITargetPlatformHelper)this.info.getValue();
    }

    public String getTargetName() {
        return (String)this.nameValue.getValue();
    }

    public String getTargetLocation() {
        return (String)this.locationValue.getValue();
    }

    public IVMInstall getJVMInstall() {
        return this.jvmInstall;
    }

    public OSArchitecture getJVMArch() {
        return this.jvmArch;
    }

    public OSArchitecture getArchitecture() {
        if (Boolean.TRUE.equals(this.platformArchitecture32.getValue())) {
            return OSArchitecture.x86;
        }
        return OSArchitecture.x86_64;
    }

    public void initializeExisting(String configName, String autLocation, String targetName, final ILaunchConfiguration configuration) {
        Aut launch;
        this.currentName = configName;
        final ITargetPlatformHelper[] helper = new ITargetPlatformHelper[1];
        TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(this.shell, 500);
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        helper[0] = Q7TargetPlatformManager.loadTarget((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        RcpttPlugin.log((Throwable)e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
        if (helper[0] != null && helper[0].isValid()) {
            this.info.setValue((Object)helper[0]);
        }
        this.nameValue.setValue((Object)configName);
        this.locationValue.setValue((Object)autLocation);
        if (configuration != null && (launch = AutManager.INSTANCE.getByLaunch(configuration)) != null) {
            List list = launch.getLaunches();
            for (AutLaunch autLaunch : list) {
                if (!autLaunch.getState().equals((Object)AutLaunchState.ACTIVE)) continue;
                this.warningMessageValue.setValue((Object)"Running AUT is detected.\nPlease restart AUT manually, after configuration update, if required.");
                break;
            }
        }
    }

    public void addAdvancedHandler(Runnable runnable) {
        this.showAdvanced.setValue((Object)Boolean.TRUE);
        this.advancedHandler = runnable;
    }
}

