/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProjectSetCapability;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.core.TeamPlugin;

public class CVSTeamProviderType
extends RepositoryProviderType
implements IAdaptable {
    private static AutoShareJob autoShareJob;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static synchronized AutoShareJob getAutoShareJob() {
        if (autoShareJob == null) {
            autoShareJob = new AutoShareJob();
            autoShareJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (!autoShareJob.isQueueEmpty()) {
                        autoShareJob.schedule();
                    }
                }
            });
            autoShareJob.setSystem(true);
            autoShareJob.setPriority(20);
            autoShareJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        return autoShareJob;
    }

    public boolean supportsProjectSetImportRelocation() {
        return false;
    }

    public ProjectSetCapability getProjectSetCapability() {
        return new CVSProjectSetCapability();
    }

    public void metaFilesDetected(IProject project, IContainer[] containers) {
        int i = 0;
        while (i < containers.length) {
            IContainer container = containers[i];
            IContainer cvsDir = null;
            if (container.getName().equals("CVS")) {
                cvsDir = container;
            } else {
                IResource resource = container.findMember("CVS");
                if (resource.getType() != 1) {
                    cvsDir = (IContainer)resource;
                }
            }
            try {
                if (cvsDir != null && !cvsDir.isTeamPrivateMember()) {
                    cvsDir.setTeamPrivateMember(true);
                }
            }
            catch (CoreException e) {
                TeamPlugin.log((int)4, (String)("Could not flag meta-files as team-private for " + cvsDir.getFullPath()), (Throwable)e);
            }
            ++i;
        }
        if (CVSProviderPlugin.getPlugin().isAutoshareOnImport()) {
            CVSTeamProviderType.getAutoShareJob().share(project);
        }
    }

    public Subscriber getSubscriber() {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
    }

    public Object getAdapter(Class adapter) {
        block12: {
            block11: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz) break block11;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.team.core.mapping.IChangeGroupingRequestor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter != clazz2) break block12;
            }
            return CVSProviderPlugin.getPlugin().getChangeSetManager();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public static class AutoShareJob
    extends Job {
        List projectsToShare = new ArrayList();

        AutoShareJob() {
            super(CVSMessages.CVSTeamProviderType_0);
        }

        public boolean isQueueEmpty() {
            return this.projectsToShare.isEmpty();
        }

        public boolean shouldSchedule() {
            return !this.isQueueEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            List list = this.projectsToShare;
            synchronized (list) {
                Iterator iter = this.projectsToShare.iterator();
                while (iter.hasNext()) {
                    IProject project = (IProject)iter.next();
                    if (!RepositoryProvider.isShared((IProject)project)) continue;
                    iter.remove();
                }
                return !this.projectsToShare.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void share(IProject project) {
            if (!RepositoryProvider.isShared((IProject)project)) {
                List list = this.projectsToShare;
                synchronized (list) {
                    if (!this.projectsToShare.contains(project)) {
                        this.projectsToShare.add(project);
                    }
                }
                if (this.getState() == 0 && !this.isQueueEmpty()) {
                    this.schedule();
                }
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            IProject next = null;
            next = this.getNextProject();
            monitor.beginTask(null, -1);
            while (next != null) {
                this.autoconnectCVSProject(next, Policy.subMonitorFor(monitor, -1));
                next = this.getNextProject();
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IProject getNextProject() {
            IProject next = null;
            List list = this.projectsToShare;
            synchronized (list) {
                if (!this.projectsToShare.isEmpty()) {
                    next = (IProject)this.projectsToShare.remove(0);
                }
            }
            return next;
        }

        private void autoconnectCVSProject(IProject project, IProgressMonitor monitor) {
            try {
                ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)project);
                FolderSyncInfo info = folder.getFolderSyncInfo();
                if (info != null) {
                    CVSWorkspaceRoot.setSharing(project, info, monitor);
                }
            }
            catch (TeamException e) {
                CVSProviderPlugin.log(4, "Could not auto-share project " + project.getName(), e);
            }
        }
    }
}

