/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.FileStructureVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

class TagFileSender
extends FileStructureVisitor {
    public TagFileSender(Session session, Command.LocalOption[] localOptions) {
        super(session, localOptions, false, false);
    }

    protected void sendFile(ICVSFile mFile) throws CVSException {
        Policy.checkCanceled(this.monitor);
        byte[] syncBytes = mFile.getSyncBytes();
        if (syncBytes != null) {
            this.sendFolder(mFile.getParent());
            if (ResourceSyncInfo.isDeletion(syncBytes)) {
                syncBytes = ResourceSyncInfo.convertFromDeletion(syncBytes);
            }
            if (!ResourceSyncInfo.isAddition(syncBytes)) {
                this.session.sendEntry(syncBytes, ResourceSyncInfo.getTimestampToServer(syncBytes, mFile.getTimeStamp()));
                this.session.sendIsModified(mFile, ResourceSyncInfo.isBinary(syncBytes), this.monitor);
            }
        }
    }
}

